/*
 * Decompiled with CFR 0.152.
 */
package com.els.im.controller;

import com.els.common.util.SpringContextUtils;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.enumerate.ImRecordTypeEnum;
import com.els.modules.im.api.enumerate.ImRecordTypeEnumExtend;
import com.els.modules.im.api.service.ImUserRecordRpcService;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tioRecordData"})
@Api(tags={"\u6c9f\u901a\u5355\u636e\u7528\u6237\u67e5\u8be2"})
public class ImDataProvideController {
    private static final Logger log = LoggerFactory.getLogger(ImDataProvideController.class);
    @Autowired
    private SupplierMasterDataRpcService supplierMasterDataRpcService;
    @Autowired(required=false)
    private ImGroupInvokeRpcService baseImGroupService;

    @GetMapping(value={"/getRecordByRecordIdAndType"})
    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ImRecordTypeEnum recordTypeEnum = ImRecordTypeEnum.getImRecordTypeEnum((String)imRecordDto.getType());
        if (recordTypeEnum == null) {
            ImRecordTypeEnumExtend imRecordTypeEnum = ImRecordTypeEnumExtend.getImRecordTypeEnum((String)imRecordDto.getType());
            if (imRecordTypeEnum == null) {
                return Lists.newArrayList();
            }
            ImUserRecordRpcService service = (ImUserRecordRpcService)SpringContextUtils.getBean((String)imRecordTypeEnum.getRpcServiceName(), ImUserRecordRpcService.class);
            return service.getRecordPersonInCharge(imRecordDto);
        }
        ImUserRecordRpcService service = (ImUserRecordRpcService)SpringContextUtils.getBean((String)recordTypeEnum.getRpcServiceName(), ImUserRecordRpcService.class);
        return service.getRecordPersonInCharge(imRecordDto);
    }

    @PostMapping(value={"/getToElsAccount"})
    public List<String> getToElsAccount(String name) {
        return this.supplierMasterDataRpcService.getSupplierToElsAccount(name);
    }

    @PostMapping(value={"/getElsAccount"})
    public List<String> getElsAccount(String name) {
        return this.supplierMasterDataRpcService.getSupplierElsAccount(name);
    }

    @PostMapping(value={"/initGroup"})
    public void initGroup(String userId) {
        this.baseImGroupService.initGroup(userId);
    }

    @PostMapping(value={"/batchInitGroup"})
    public void batchInitGroup(List<String> ids) {
        this.baseImGroupService.initGroupBatch(ids);
    }
}

