/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.els.common.api.vo.Result;
import com.els.common.system.vo.DictModel;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.service.DictExtendService;
import com.els.modules.system.vo.DictPage;
import com.els.modules.topman.vo.KuaiShouTopManCategory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/dictExtend"})
@Api(tags={"\u6570\u636e\u5b57\u5178"})
public class DictExtendController {
    private static final Logger log = LoggerFactory.getLogger(DictExtendController.class);
    @Autowired
    private DictExtendService dictService;

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u660e\u7ec6", notes="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u660e\u7ec6")
    @RequestMapping(value={"/findDictItems"}, method={RequestMethod.POST})
    public Result<Object> findDictItems(@RequestBody DictPage dictPage) {
        log.info(" dictCode : " + dictPage.getDictCode());
        log.info(" busAccount : " + dictPage.getBusAccount());
        String elsAccount = StrUtil.isEmpty((CharSequence)dictPage.getBusAccount()) ? TenantContext.getTenant() : dictPage.getBusAccount();
        String dictCode = dictPage.getDictCode();
        Result result = new Result();
        List<Object> maps = new ArrayList();
        try {
            if (dictCode.contains(";")) {
                maps = this.dictService.queryDictItemsByCodeList(dictCode, elsAccount);
                result.setSuccess(true);
                result.setResult(maps);
                log.info(result.toString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.error500("\u64cd\u4f5c\u5931\u8d25");
            return result;
        }
        return result;
    }

    @GetMapping(value={"/getDouYinCategoryData"})
    public Result<Object> getDouYinCategoryData() {
        List<String> checkbox = Arrays.asList("\u54c1\u724c\u81ea\u64ad", "\u5e97\u64ad", "\u661f\u56fe\u8fbe\u4eba", "\u9ed1\u9a6c", "\u9690\u85cf\u65b0\u95fb\u53f7");
        ArrayList data = Lists.newArrayList();
        List<Map<String, List<DictModel>>> all = this.dictService.queryDictItemsByCodeList("IndustryTiktok", "100000");
        for (DictModel dictModels : all.get(0).get("IndustryTiktok")) {
            KuaiShouTopManCategory category = new KuaiShouTopManCategory();
            category.setTitle(dictModels.getText());
            category.setFieldName(dictModels.getValue());
            ArrayList children = Lists.newArrayList();
            List<Map<String, List<DictModel>>> codeList = this.dictService.queryDictItemsByCodeList(dictModels.getValue(), "100000");
            for (DictModel cm : codeList.get(0).get(dictModels.getValue())) {
                KuaiShouTopManCategory.ContentCategory contentCategory = new KuaiShouTopManCategory.ContentCategory();
                contentCategory.setStarTagId(cm.getValue());
                contentCategory.setStarTagName(cm.getText());
                switch (dictModels.getValue()) {
                    case "CargoClassification": 
                    case "TalentClassification": {
                        contentCategory.setComponent("RButton");
                        break;
                    }
                    case "TalentInformation": 
                    case "CargoInformation": 
                    case "other": {
                        if (checkbox.contains(cm.getText())) {
                            contentCategory.setComponent("RCheckbox");
                            break;
                        }
                        contentCategory.setComponent("RSelect");
                        ArrayList subTags = Lists.newArrayList();
                        List<Map<String, List<DictModel>>> subList = this.dictService.queryDictItemsByCodeList(cm.getValue(), "100000");
                        for (DictModel cmm : subList.get(0).get(cm.getValue())) {
                            KuaiShouTopManCategory.SubTags subTags1 = new KuaiShouTopManCategory.SubTags();
                            subTags1.setStarTagName(cmm.getText());
                            subTags1.setStarTagValue((Object)cmm.getValue());
                            subTags.add(subTags1);
                        }
                        contentCategory.setSubTags((List)subTags);
                    }
                }
                children.add(contentCategory);
            }
            category.setChildren((List)children);
            data.add(category);
        }
        return Result.ok((Object)data);
    }

    @RequestMapping(value={"/cleanCache"}, method={RequestMethod.POST})
    public Result<?> cleanCache(@RequestBody DictPage dictPage) {
        log.info("\u6e05\u9664\u591a\u4e2a\u5b57\u5178code\u7f13\u5b58");
        String elsAccount = StrUtil.isEmpty((CharSequence)dictPage.getBusAccount()) ? TenantContext.getTenant() : dictPage.getBusAccount();
        String dictCode = dictPage.getDictCode();
        this.dictService.cleanCache(dictCode, elsAccount);
        return Result.ok();
    }
}

