/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.system.vo.DictModel;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.mapper.DictMapper;
import com.els.modules.system.service.DictExtendService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictExtendServiceImpl
extends ServiceImpl<DictMapper, Dict>
implements DictExtendService {
    private static final Logger log = LoggerFactory.getLogger(DictExtendServiceImpl.class);
    @Resource
    private DictMapper dictMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "sys:cache:dict";
    private static final String COLON = ":";

    @Override
    public List<Map<String, List<DictModel>>> queryDictItemsByCodeList(String code, String elsAccount) {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(code).append(COLON).append(language);
        ArrayList<Map<String, List<DictModel>>> list = (ArrayList<Map<String, List<DictModel>>>)this.redisUtil.get(redisKey.toString());
        if (code.toLowerCase().equals("materialgroup")) {
            log.info("elsAccount: " + elsAccount + " redis\u503c: " + (list != null ? ((Object)list).toString() : null));
        }
        log.info("\u65e0\u7f13\u5b58dictCache\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
        HashMap mapDict = new HashMap();
        list = new ArrayList<Map<String, List<DictModel>>>();
        String[] split = code.split(";");
        for (String item2 : split) {
            List itemList = new ArrayList();
            itemList = this.dictMapper.queryDictItemsByCode(item2, elsAccount);
            if (CollectionUtil.isEmpty(itemList)) {
                itemList = this.dictMapper.queryDictItemsByCode(item2, "100000");
            }
            mapDict.put(item2, itemList);
        }
        list.add(mapDict);
        if (!CollectionUtils.isEmpty(list)) {
            for (List value : ((Map)list.get(0)).values()) {
                value.forEach(item -> item.setText(I18nUtil.translate((String)item.getTextI18nKey(), (String)item.getText())));
            }
            this.redisUtil.set(redisKey.toString(), list, 7200L);
        }
        return list;
    }

    @Override
    public void cleanCache(String code, String elsAccount) {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKey = new StringBuilder(CATALOGUE).append(elsAccount).append(COLON).append(code).append(COLON).append(language);
        this.redisUtil.del(new String[]{redisKey.toString()});
    }
}

