/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.LicenseUtil;
import com.els.common.util.MD5Util;
import com.els.common.util.MqUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.MemberContext;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.member.service.MemberService;
import com.els.modules.member.service.MemberTrialPermissionService;
import com.els.modules.member.vo.CurrentMemberVo;
import com.els.modules.member.vo.LoginModelExtent;
import com.els.modules.sms.api.dto.SmsDto;
import com.els.modules.sms.api.dto.SmsResult;
import com.els.modules.sms.api.service.SmsRpcService;
import com.els.modules.system.config.PermissionI18LocalCacheInit;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.SubaccountOrg;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.model.LoginModel;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.rpc.service.SystemInvokeOrganizationInfoRpcService;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.SubaccountOrgService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.modules.system.vo.ForgetPasswordVO;
import com.els.modules.system.vo.PermissionVO;
import com.els.shiro.authc.JwtToken;
import com.j256.twofactorauth.TimeBasedOneTimePasswordUtil;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/loginExtent"})
public class LoginExtentController {
    private static final Logger log = LoggerFactory.getLogger(LoginExtentController.class);
    @Autowired
    private MemberService memberService;
    @Autowired
    private SmsRpcService smsRpcService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private ElsTenantService elsTenantService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private ElsPasswordSecurityService pwSecurityService;
    @Autowired
    private MemberTrialPermissionService memberTrialPermissionService;
    @Autowired
    private SubaccountOrgService subaccountOrgService;
    @Resource
    private SystemInvokeOrganizationInfoRpcService systemInvokeOrganizationInfoRpcService;
    private String version = this.getClass().getPackage().getImplementationVersion();
    private static final String TEMP_TOKEN = "sys:login:tempToken:";
    @Autowired
    private PermissionService permissionService;

    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public Result<?> login(@RequestBody LoginModelExtent loginModel) {
        log.info(":::doLogin:{}", (Object)loginModel);
        Result<?> result = this.checkUser(loginModel);
        return result;
    }

    private Result<?> checkUser(LoginModelExtent loginModel) {
        Result result = new Result();
        String password = loginModel.getPassword();
        String tempToken = loginModel.getTempToken();
        String loginType = loginModel.getLoginType();
        if (StrUtil.isBlank((CharSequence)loginType)) {
            loginType = "account";
        }
        ElsSubAccount user = null;
        if ("account".equals(loginType)) {
            user = this.elsSubAccountService.getUserByAccount(loginModel.getElsAccount().trim() + "_" + loginModel.getSubAccount().trim());
        } else if ("phone".equals(loginType) || "captcha".equals(loginType)) {
            if (StrUtil.isNotBlank((CharSequence)loginModel.getAccountId())) {
                user = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)loginModel.getAccountId()));
            } else {
                List accountList = this.elsSubAccountService.getUserListByPhone(loginModel.getPhone().trim());
                if (accountList.size() == 1) {
                    user = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)((ElsSubAccountVO)accountList.get(0)).getId()));
                } else if (accountList.size() > 1) {
                    JSONObject obj = new JSONObject();
                    obj.put("returnType", (Object)"selectAccount");
                    JSONArray array = new JSONArray();
                    for (ElsSubAccountVO vo : accountList) {
                        JSONObject item = new JSONObject();
                        item.put("accountId", (Object)vo.getId());
                        item.put("elsAccount", (Object)vo.getElsAccount());
                        item.put("subAccount", (Object)vo.getSubAccount());
                        item.put("realname", (Object)vo.getRealname());
                        item.put("enterpriseName", (Object)vo.getEnterpriseName());
                        array.add((Object)item);
                    }
                    obj.put("accountList", (Object)array);
                    return Result.ok((Object)obj);
                }
            }
        }
        if (user == null) {
            result.error500(I18nUtil.translate((String)"i18n_alert_rjDxMKWVdi_533e2538", (String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u6ce8\u518c"));
            return result;
        }
        if (CommonConstant.DEL_FLAG_1.equals(user.getDeleted())) {
            result.error500(I18nUtil.translate((String)"i18n_alert_rjDIdXW_d3c8a06b", (String)"\u8be5\u7528\u6237\u5df2\u6ce8\u9500"));
            return result;
        }
        if (CommonConstant.USER_FREEZE.equals(user.getStatus())) {
            result.error500(I18nUtil.translate((String)"i18n_alert_rjDIOyW_d35fed0b", (String)"\u8be5\u7528\u6237\u5df2\u51bb\u7ed3"));
            return result;
        }
        result = this.elsSubAccountService.checkUserIsEffective(user);
        if (null != user.getAccountValidityDate()) {
            Date accountValidityDate = user.getAccountValidityDate();
            Date timeDate = new Date();
            if (timeDate.getTime() > accountValidityDate.getTime()) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LjeDIRjXAWWdVVKHRvjW_2e44c8f3", (String)"\u60a8\u7684\u8d26\u6237\u5df2\u8fc7\u6709\u6548\u671f\u9650\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
            }
        }
        if (!result.isSuccess()) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)result.getMessage()));
        }
        TenantContext.setTenant((String)user.getElsAccount());
        CurrentMemberVo memberMsg = this.memberService.checkMember(user.getSubAccount(), user.getElsAccount());
        MemberContext.setMember(memberMsg);
        if (StrUtil.isNotBlank((CharSequence)tempToken)) {
            if (!this.redisUtil.hasKey(this.getRedisKey(user.getElsAccount(), user.getSubAccount(), tempToken))) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e34\u65f6Token\u5df2\u5931\u6548\uff0c\u8bf7\u8fd4\u56de\u767b\u5f55\u9875\u91cd\u65b0\u8fdb\u884c\u767b\u5f55\u64cd\u4f5c\uff01"));
            }
            this.checkMfa(loginModel, user);
        } else if ("captcha".equals(loginType)) {
            Object obj = this.redisUtil.get(loginModel.getPhone());
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)obj), (String)I18nUtil.translate((String)"i18n_alert_OioIKXWVVVSMW_feeecd17", (String)"\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01"), (Object[])new Object[0]);
            Assert.isTrue((boolean)obj.toString().equals(loginModel.getCaptcha()), (String)I18nUtil.translate((String)"i18n_alert_OioNSWVVVSMW_4d0356d2", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01"), (Object[])new Object[0]);
        } else {
            this.pwSecurityService.verifyErrorLock(user.getElsAccount(), user.getSubAccount());
            if (!"100000".equals(user.getElsAccount()) && !(result = this.elsTenantService.checkTenantIsEffective(user.getElsAccount())).isSuccess()) {
                throw new ELSBootException(result.getMessage());
            }
            String userpassword = PasswordUtil.encrypt((String)(user.getElsAccount() + "_" + user.getSubAccount()), (String)password, (String)user.getSalt());
            String syspassword = user.getPassword();
            if (!syspassword.equals(userpassword)) {
                this.pwSecurityService.setUpLoginErrorNum(user.getElsAccount(), user.getSubAccount());
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDRSwoNSW_d7a449f8", (String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"));
            }
            StaticConfig config = (StaticConfig)SpringContextUtils.getBean(StaticConfig.class);
            String mfaSwitch = (String)config.getConfig().get("mfaSwitch");
            if ("1".equals(mfaSwitch)) {
                JSONObject obj = new JSONObject();
                obj.put("returnType", (Object)"mfaCheck");
                if (StrUtil.isBlank((CharSequence)user.getPhone())) {
                    obj.put("sms", (Object)"0");
                } else {
                    obj.put("sms", (Object)"1");
                    obj.put("phone", (Object)this.encrypt(user.getPhone()));
                }
                if (StrUtil.isBlank((CharSequence)user.getSecret())) {
                    obj.put("otp", (Object)"0");
                } else {
                    obj.put("otp", (Object)"1");
                }
                tempToken = IdWorker.get32UUID();
                obj.put("tempToken", (Object)tempToken);
                this.redisUtil.set(this.getRedisKey(user.getElsAccount(), user.getSubAccount(), tempToken), (Object)user.getPhone(), 600L);
                if (StrUtil.isBlank((CharSequence)user.getPhone()) && StrUtil.isBlank((CharSequence)user.getSecret())) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8be5\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\u4e14\u672a\u8bbe\u7f6eOTP\u5bc6\u94a5\uff0c\u4e8c\u6b21\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
                }
                return Result.ok((Object)obj);
            }
        }
        this.pwSecurityService.setRepeatLoginToken(user.getElsAccount(), user.getSubAccount());
        this.userInfo(user, (Result<JSONObject>)result, memberMsg);
        if (StrUtil.isNotBlank((CharSequence)loginModel.getThirdUserUuid())) {
            this.bindUserId(user.getId(), user.getElsAccount(), loginModel.getThirdUserUuid());
        }
        MqUtil.sendLogMsg((String)user.getElsAccount(), (String)("\u8d26\u53f7: " + user.getElsAccount() + "_" + user.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date())), (Integer)1, null);
        this.redisUtil.del(new String[]{"shiro:cache:com.els.shiro.authc.ShiroRealm.authorizationCache:" + SysUtil.getLoginUser().getId()});
        return result;
    }

    private String encrypt(String terget) {
        if (StrUtil.isBlank((CharSequence)terget)) {
            return "";
        }
        return terget.replaceAll("(?<=\\S{3})\\S(?=\\S{4})", "*");
    }

    private void checkMfa(LoginModel loginModel, ElsSubAccount elsSubAccount) {
        String mfaType = loginModel.getMfaType();
        String captcha = loginModel.getCaptcha();
        if (StrUtil.isBlank((CharSequence)mfaType)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e8c\u6b21\u6821\u9a8c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        if ("sms".equals(mfaType)) {
            if (!captcha.equals(this.redisUtil.get(elsSubAccount.getPhone()))) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u7ecf\u5931\u6548\uff01"));
            }
        } else {
            try {
                String code = TimeBasedOneTimePasswordUtil.generateCurrentNumberString((String)elsSubAccount.getSecret());
                if (!captcha.equals(code)) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5df2\u7ecf\u5931\u6548\uff01"));
                }
            }
            catch (GeneralSecurityException e) {
                log.error("TimeBasedOneTimePasswordUtil_generateCurrentNumberString_failed:", (Throwable)e);
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"OTP\u9a8c\u8bc1\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01"));
            }
        }
    }

    private void bindUserId(String userId, String elsAccount, String thirdUserUuid) {
        ThirdAccount thirdAccount = (ThirdAccount)this.thirdAccountService.getById((Serializable)((Object)thirdUserUuid));
        if (null == thirdAccount) {
            return;
        }
        thirdAccount.setUserId(userId);
        thirdAccount.setElsAccount(elsAccount);
        this.thirdAccountService.updateById((Object)thirdAccount);
    }

    private void buildCompanySet(List<ElsCompanySetDTO> list, String logo, String name) {
        ElsCompanySetDTO elsCompanySetDTO1 = new ElsCompanySetDTO();
        elsCompanySetDTO1.setItemCode("companyShortName");
        elsCompanySetDTO1.setDefaultValue(name != null ? name : "");
        list.add(elsCompanySetDTO1);
        ElsCompanySetDTO elsCompanySetDTO2 = new ElsCompanySetDTO();
        elsCompanySetDTO2.setItemCode("companyLogo");
        elsCompanySetDTO2.setDefaultValue(logo != null ? logo : "");
        list.add(elsCompanySetDTO2);
    }

    private void buildCompanySet(List<ElsCompanySetDTO> list, String logo, String fullName, String shortName) {
        ElsCompanySetDTO elsCompanySetDTO1 = new ElsCompanySetDTO();
        elsCompanySetDTO1.setItemCode("companyShortName");
        elsCompanySetDTO1.setDefaultValue(shortName != null ? shortName : "");
        list.add(elsCompanySetDTO1);
        ElsCompanySetDTO elsCompanySetDTO2 = new ElsCompanySetDTO();
        elsCompanySetDTO2.setItemCode("companyLogo");
        elsCompanySetDTO2.setDefaultValue(logo != null ? logo : "");
        list.add(elsCompanySetDTO2);
        ElsCompanySetDTO elsCompanySetDTO3 = new ElsCompanySetDTO();
        elsCompanySetDTO3.setItemCode("companyName");
        elsCompanySetDTO3.setDefaultValue(fullName != null ? fullName : "");
        list.add(elsCompanySetDTO3);
    }

    private void setLogo(List<ElsCompanySetDTO> list, String elsAccount) {
        if ("cloud".equals(SysUtil.getDeployWay())) {
            ElsTenant byElsAccount = this.elsTenantService.findByElsAccount(elsAccount);
            if (byElsAccount != null && StrUtil.isNotBlank((CharSequence)byElsAccount.getCompanyLogo())) {
                this.buildCompanySet(list, byElsAccount.getCompanyLogo(), byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
            } else {
                byElsAccount = this.elsTenantService.findByElsAccount("100000");
                if (byElsAccount != null) {
                    this.buildCompanySet(list, byElsAccount.getCompanyLogo(), byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
                } else {
                    this.buildCompanySet(list, null, null);
                }
            }
        } else {
            Map map = this.elsSubAccountService.getLogoSetByElsAccount(SysUtil.getPurchaseAccount());
            if (map != null) {
                this.buildCompanySet(list, (String)map.get("enterprise_logo"), (String)map.get("alias"));
            } else {
                this.buildCompanySet(list, null, null);
            }
        }
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result, CurrentMemberVo currentMemberVo) {
        ((LicenseUtil)SpringContextUtils.getBean(LicenseUtil.class)).check();
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign((String)(elsAccount + "_" + subAccount), (String)syspassword);
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 3600L);
        this.redisUtil.set("sys:token:" + elsAccount + "_" + subAccount, (Object)token);
        this.redisUtil.expire("sys:token:" + elsAccount + "_" + subAccount, 3600L);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, (Object)adminFlag, 172800L);
        List list = this.baseRpcService.getCompanySetList(elsAccount);
        this.setLogo(list, elsAccount);
        JSONObject companySetObj = this.getObjBySet(list);
        ElsSubAccountVO elsSubAccountVO = new ElsSubAccountVO();
        BeanUtils.copyProperties((Object)sysUser, (Object)elsSubAccountVO);
        String orgCode = elsSubAccountVO.getOrgCode();
        if (StringUtils.isNotBlank((CharSequence)orgCode)) {
            List<String> orgCodeList = Arrays.asList(orgCode.split(","));
            Map orgMap = this.systemInvokeOrganizationInfoRpcService.listDeptOrganization(orgCodeList);
            String org = orgCodeList.stream().filter(orgMap::containsKey).map(orgMap::get).collect(Collectors.joining(","));
            elsSubAccountVO.setOrgCode_dictText(org);
        }
        List subaccountOrgList = this.subaccountOrgService.selectByMainId(sysUser.getId());
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        elsSubAccountVO.setSerivceUrl((String)config.get("service.address"));
        elsSubAccountVO.setPassword(null);
        elsSubAccountVO.setSalt(null);
        elsSubAccountVO.setSecret(null);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)elsSubAccountVO);
        obj.put("companySet", (Object)companySetObj);
        obj.put("srmVersion", (Object)this.version);
        obj.put("userOrg", (Object)this.getUserOrg(subaccountOrgList));
        result.setResult((Object)obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        this.redisUtil.del(new String[]{"shiro:cache:com.els.shiro.authc.ShiroRealm.authorizationCache:" + sysUser.getId()});
        return result;
    }

    private JSONObject getUserOrg(List<SubaccountOrg> subaccountOrgList) {
        JSONObject object = new JSONObject();
        if (subaccountOrgList.isEmpty()) {
            return object;
        }
        Map<String, List<SubaccountOrg>> orgMap = subaccountOrgList.stream().collect(Collectors.groupingBy(SubaccountOrg::getOrgCategoryCode));
        for (String orgCategoryCode : orgMap.keySet()) {
            JSONArray orgCodeArray = new JSONArray();
            List<SubaccountOrg> list = orgMap.get(orgCategoryCode);
            object.put(orgCategoryCode, (Object)list.get(0).getOrgCode());
            for (SubaccountOrg org : list) {
                orgCodeArray.add((Object)org.getOrgCode());
            }
            object.put(orgCategoryCode + "List", (Object)orgCodeArray);
        }
        return object;
    }

    private String getRedisKey(String elsAccount, String subAccount, String tempToken) {
        StringBuilder builder = new StringBuilder(TEMP_TOKEN);
        builder.append(elsAccount).append(":").append(subAccount).append(":").append(tempToken);
        return builder.toString();
    }

    private JSONObject getObjBySet(List<ElsCompanySetDTO> list) {
        JSONObject result = new JSONObject();
        if (list != null) {
            for (ElsCompanySetDTO set : list) {
                result.put(set.getItemCode(), (Object)set.getDefaultValue());
            }
        }
        return result;
    }

    @AutoLog(value="\u53d1\u77ed\u4fe1\u77ed\u4fe1\u63a5\u53e3", logType=1)
    @PostMapping(value={"/sms"})
    public Result<?> sms(@RequestBody ForgetPasswordVO forgetPasswordVO) {
        if (null == forgetPasswordVO.getPhone()) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ltyoxOLVWVVVWNW_263247f8", (String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        SmsDto smsDto = new SmsDto();
        smsDto.setMobile(forgetPasswordVO.getPhone());
        smsDto.setSmsmode("0");
        smsDto.setSourceType("0");
        smsDto.setCaptcha(captcha);
        SmsResult smsResult = this.smsRpcService.sendSms(smsDto);
        if (!smsResult.isSuccess()) {
            throw new ELSBootException(smsResult.getMessage());
        }
        this.redisUtil.set(forgetPasswordVO.getPhone(), (Object)captcha, 600L);
        return Result.ok((Object)forgetPasswordVO);
    }

    private void getAuthJsonArray(JSONArray jsonArray, List<PermissionVO> metaList, List<Permission> allAuthList) {
        for (Permission permission : metaList) {
            JSONObject json;
            if (permission.getMenuType() == null || StrUtil.isBlank((CharSequence)permission.getPerms()) || !"1".equals(permission.getStatus())) continue;
            if (permission.getPerms().contains(";")) {
                for (String str : permission.getPerms().split(";")) {
                    json = new JSONObject();
                    json.put("action", (Object)str);
                    json.put("type", (Object)permission.getPermsType());
                    json.put("describe", (Object)permission.getName());
                    jsonArray.add((Object)json);
                }
                continue;
            }
            json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("type", (Object)permission.getPermsType());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private JSONObject getPermissionJsonObject(Permission permission, Pair<Boolean, Set<String>> pair) {
        JSONObject json = new JSONObject();
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
            return null;
        }
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_0) || permission.getMenuType().equals(CommonConstant.MENU_TYPE_1)) {
            json.put("id", (Object)permission.getId());
            json.put("canClick", (Object)((Boolean)pair.getKey() != false ? ((Set)pair.getValue()).contains(permission.getId()) : true));
            if (permission.isRoute()) {
                json.put("route", (Object)"1");
            } else {
                json.put("route", (Object)"0");
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                json.put("path", (Object)MD5Util.md5Encode((String)permission.getUrl(), (String)"utf-8"));
            } else {
                json.put("path", (Object)permission.getUrl());
            }
            json.put("mobile", (Object)permission.isMobile());
            if (ConvertUtils.isNotEmpty((Object)permission.getComponentName())) {
                json.put("name", (Object)permission.getComponentName());
            } else {
                json.put("name", (Object)this.urlToRouteName(permission.getUrl()));
            }
            if (permission.isHidden()) {
                json.put("hidden", (Object)true);
            }
            if (permission.isAlwaysShow()) {
                json.put("alwaysShow", (Object)true);
            }
            json.put("component", (Object)permission.getComponent());
            JSONObject meta = new JSONObject();
            if (permission.isKeepAlive()) {
                meta.put("keepAlive", (Object)true);
            } else {
                meta.put("keepAlive", (Object)false);
            }
            if (permission.isInternalOrExternal()) {
                meta.put("internalOrExternal", (Object)true);
            } else {
                meta.put("internalOrExternal", (Object)false);
            }
            meta.put("title", (Object)permission.getName());
            if (ConvertUtils.isEmpty((Object)permission.getParentId())) {
                json.put("redirect", (Object)permission.getRedirect());
                if (ConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty((Object)permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            } else {
                if (ConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty((Object)permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                meta.put("url", (Object)permission.getUrl());
            }
            if (StrUtil.isNotBlank((CharSequence)permission.getHelpDocUrl())) {
                meta.put("helpDocUrl", (Object)permission.getHelpDocUrl());
            }
            json.put("meta", (Object)meta);
        }
        return json;
    }

    private String urlToRouteName(String url) {
        if (ConvertUtils.isNotEmpty((Object)url)) {
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = url.replace("/", "-");
            url = url.replace(":", "@");
            return url;
        }
        return null;
    }

    private boolean isWWWHttpUrl(String url) {
        return url != null && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("{{"));
    }

    private void getPermissionJsonArray(JSONArray jsonArray, List<PermissionVO> metaList, JSONObject parentJson, Pair<Boolean, Set<String>> pair) {
        for (Permission permission : metaList) {
            if (permission.getMenuType() == null) continue;
            String tempPid = permission.getParentId();
            permission.setName(PermissionI18LocalCacheInit.translate((String)permission.getNameI18nKey(), (String)permission.getName()));
            JSONObject json = this.getPermissionJsonObject(permission, pair);
            if (json == null) continue;
            if (parentJson == null && ConvertUtils.isEmpty((Object)tempPid)) {
                jsonArray.add((Object)json);
                if (permission.isLeaf()) continue;
                this.getPermissionJsonArray(jsonArray, metaList, json, pair);
                continue;
            }
            if (parentJson == null || !ConvertUtils.isNotEmpty((Object)tempPid) || !tempPid.equals(parentJson.getString("id"))) continue;
            if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
                JSONObject metaJson = parentJson.getJSONObject("meta");
                if (metaJson.containsKey((Object)"permissionList")) {
                    metaJson.getJSONArray("permissionList").add((Object)json);
                    continue;
                }
                JSONArray permissionList = new JSONArray();
                permissionList.add((Object)json);
                metaJson.put("permissionList", (Object)permissionList);
                continue;
            }
            if (!permission.getMenuType().equals(CommonConstant.MENU_TYPE_1) && !permission.getMenuType().equals(CommonConstant.MENU_TYPE_0)) continue;
            if (parentJson.containsKey((Object)"children")) {
                parentJson.getJSONArray("children").add((Object)json);
            } else {
                JSONArray children = new JSONArray();
                children.add((Object)json);
                parentJson.put("children", (Object)children);
            }
            if (permission.isLeaf()) continue;
            this.getPermissionJsonArray(jsonArray, metaList, json, pair);
        }
    }

    @RequestMapping(value={"/getUserPermissionByToken"}, method={RequestMethod.GET})
    public Result<?> getUserPermissionByToken(@RequestParam(name="token") String token) {
        Result result = new Result();
        try {
            if (ConvertUtils.isEmpty((Object)token)) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_WWWWWxiTLV_923e09ab", (String)"TOKEN\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"));
            }
            log.info(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u62e5\u6709\u7684\u8bbf\u95ee\u83dc\u5355 ---- TOKEN ------ " + token);
            String account = JwtUtil.getAccount((String)token);
            log.info("account is {}", (Object)account);
            String adminFlag = AdminFlagUtil.getAdminFlag();
            if (StrUtil.isBlank((CharSequence)adminFlag)) {
                String redisAdminFlag = (String)this.redisUtil.get("sys:token:role:" + token);
                AdminFlagUtil.setAdminFlag((String)redisAdminFlag);
            }
            log.info("adminFlag is {}", (Object)AdminFlagUtil.getAdminFlag());
            String deployWay = SysUtil.getDeployWay();
            log.info("deployWay is {}", (Object)deployWay);
            List metaList = this.permissionService.queryByAccount(account.split("_")[0], account.split("_")[1], Integer.valueOf(0));
            log.info("metaList size is {}", (Object)metaList.size());
            log.info("metaList is {}", (Object)JSON.toJSONString((Object)metaList));
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            List allAuthList = this.permissionService.list((Wrapper)query);
            JSONObject json = new JSONObject();
            JSONArray menujsonArray = new JSONArray();
            this.getPermissionJsonArray(menujsonArray, metaList, null, (Pair<Boolean, Set<String>>)new Pair((Object)this.memberService.isTrial(account.split("_")[0], account.split("_")[1]), this.memberTrialPermissionService.getTrialByElsAccount(account.split("_")[0])));
            JSONArray authjsonArray = new JSONArray();
            this.getAuthJsonArray(authjsonArray, metaList, allAuthList);
            JSONArray docArray = new JSONArray();
            this.getDocArray(docArray, metaList);
            JSONArray allauthjsonArray = new JSONArray();
            this.getAllAuthJsonArray(allauthjsonArray, allAuthList);
            json.put("menu", (Object)menujsonArray);
            json.put("auth", (Object)authjsonArray);
            json.put("allAuth", (Object)allauthjsonArray);
            json.put("doc", (Object)docArray);
            result.setResult((Object)json);
            result.success("\u67e5\u8be2\u6210\u529f");
            AdminFlagUtil.clear();
        }
        catch (Exception e) {
            result.error500("\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            AdminFlagUtil.clear();
        }
        return result;
    }

    private void getAllAuthJsonArray(JSONArray jsonArray, List<Permission> allList) {
        for (Permission permission : allList) {
            if (StrUtil.isBlank((CharSequence)permission.getPerms())) continue;
            JSONObject json = new JSONObject();
            if (!"1".equals(permission.getStatus())) continue;
            if (permission.getPerms().contains(";")) {
                for (String str : permission.getPerms().split(";")) {
                    json = new JSONObject();
                    json.put("action", (Object)str);
                    json.put("type", (Object)permission.getPermsType());
                    json.put("status", (Object)permission.getStatus());
                    json.put("describe", (Object)permission.getName());
                    jsonArray.add((Object)json);
                }
                continue;
            }
            json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("type", (Object)permission.getPermsType());
            json.put("status", (Object)permission.getStatus());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    JSONArray getDocArray(JSONArray docArray, List<PermissionVO> metaList) {
        for (PermissionVO vo : metaList) {
            if (StrUtil.isBlank((CharSequence)vo.getUrl())) continue;
            JSONObject object = new JSONObject();
            object.put("path", (Object)vo.getUrl());
            if (StrUtil.isBlank((CharSequence)vo.getHelpDesc())) {
                object.put("hasDoc", (Object)"0");
            } else {
                object.put("hasDoc", (Object)"1");
            }
            docArray.add((Object)object);
        }
        return docArray;
    }
}

