/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.member.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.service.SrmToIPaasService;
import com.els.modules.member.entity.MemberMeal;
import com.els.modules.member.entity.MemberOrder;
import com.els.modules.member.enumerate.MealTypeEnum;
import com.els.modules.member.enumerate.OrderStatusEnum;
import com.els.modules.member.enumerate.PayStatusEnum;
import com.els.modules.member.mapper.MemberOrderMapper;
import com.els.modules.member.service.MemberMealService;
import com.els.modules.member.service.MemberOrderService;
import com.els.modules.member.vo.OrderPayResultVo;
import com.els.modules.system.service.CodeGeneratorService;
import com.els.modules.touch.util.EncryptAesUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MemberOrderServiceImpl
extends BaseServiceImpl<MemberOrderMapper, MemberOrder>
implements MemberOrderService {
    private static final Logger log = LoggerFactory.getLogger(MemberOrderServiceImpl.class);
    @Autowired
    private CodeGeneratorService codeGeneratorService;
    @Autowired
    private StaticConfig staticConfig;
    @Autowired
    private SrmToIPaasService srmToIPaasService;
    @Autowired
    @Lazy
    private MemberMealService memberMealService;
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();

    @Override
    public void add(MemberOrder memberOrder) {
        ((MemberOrderMapper)this.baseMapper).insert((Object)memberOrder);
    }

    @Override
    public void edit(MemberOrder memberOrder) {
        int count = ((MemberOrderMapper)this.baseMapper).updateById((Object)memberOrder);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((MemberOrderMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((MemberOrderMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public OrderPayResultVo createOrder(MemberOrder memberOrder) {
        MemberMeal meal = (MemberMeal)((Object)this.memberMealService.getById((Serializable)((Object)memberOrder.getMealId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)meal)), (String)"\u5957\u9910\u5f02\u5e38");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)memberOrder.getMealType()), (String)"\u5957\u9910\u7c7b\u578b\u5f02\u5e38");
        String mealTypeDesc = MealTypeEnum.getDescByCode(memberOrder.getMealType());
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)mealTypeDesc), (String)"\u5957\u9910\u7c7b\u578b\u5f02\u5e38");
        if (memberOrder.getMealType().equals(MealTypeEnum.MEMBER_UPGRADE_RENEWAL.getCode())) {
            memberOrder.setProductName(String.valueOf(meal.getProductName()) + "_" + "_1\u5e74");
            this.checkDedAmt(memberOrder.getDedAmt(), meal, memberOrder);
            BigDecimal dedAmt = Optional.ofNullable(memberOrder.getDedAmt()).orElse(BigDecimal.ZERO);
            if (ObjectUtil.isNotEmpty((Object)meal.getDiscount())) {
                String s = "0." + meal.getDiscount();
                double ds = Double.valueOf(s);
                memberOrder.setPayAmt(meal.getProductAmt().multiply(BigDecimal.valueOf(ds)).subtract(dedAmt).setScale(0, 4));
            } else {
                memberOrder.setPayAmt(meal.getProductAmt().subtract(memberOrder.getDedAmt()).setScale(0, 4));
            }
            memberOrder.setProductAmt(meal.getProductAmt());
        } else {
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)memberOrder.getOrderNum()), (String)"\u5957\u9910\u6570\u91cf\u5f02\u5e38");
            memberOrder.setProductName(String.valueOf(mealTypeDesc) + "_" + memberOrder.getOrderNum() + "\u4e2a");
            BigDecimal amt = BigDecimal.ZERO;
            if (memberOrder.getMealType().equals(MealTypeEnum.ADD_SHOPS.getCode())) {
                amt = meal.getAddShopAmt().multiply(new BigDecimal(memberOrder.getOrderNum())).stripTrailingZeros();
            }
            if (memberOrder.getMealType().equals(MealTypeEnum.ADD_SUB_ACCOUNT.getCode())) {
                amt = meal.getAddAccountAmt().multiply(new BigDecimal(memberOrder.getOrderNum())).stripTrailingZeros();
            }
            memberOrder.setProductAmt(amt);
            memberOrder.setPayAmt(amt);
        }
        String elsAccount = TenantContext.getTenant();
        memberOrder.setToElsAccount(elsAccount);
        memberOrder.setToElsAccountName(((MemberOrderMapper)this.baseMapper).getCompanyNameByElsAccount(elsAccount));
        memberOrder.setOrderNo(this.codeGeneratorService.getNextCode("MemberOrderNo", (Object)memberOrder));
        memberOrder.setOrderStatus(OrderStatusEnum.NEWLY_BUILD.getCode());
        memberOrder.setExpirTime((Date)DateUtil.offsetMinute((Date)new Date(), (int)10));
        memberOrder.setIsDed("0");
        memberOrder.setPayStatus(PayStatusEnum.TO_BE_PAID.getCode());
        this.save((Object)memberOrder);
        return new OrderPayResultVo(memberOrder.getId(), this.callIpassPay(memberOrder));
    }

    private void checkDedAmt(BigDecimal dedAmt, MemberMeal meal, MemberOrder memberOrder) {
        List orders = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MemberOrder::getToElsAccount, (Object)TenantContext.getTenant())).eq(MemberOrder::getOrderStatus, (Object)OrderStatusEnum.COMPLETED.getCode())).eq(MemberOrder::getMealType, (Object)MealTypeEnum.MEMBER_UPGRADE_RENEWAL.getCode())).eq(MemberOrder::getIsDed, (Object)"0"));
        if (CollUtil.isEmpty((Collection)orders)) {
            memberOrder.setMealExpireTime((Date)DateUtil.offsetMonth((Date)new Date(), (int)12));
            return;
        }
        MemberOrder nowOrder = orders.stream().sorted(Comparator.comparing(MemberOrder::getExpirTime).reversed()).findFirst().get();
        if (ObjectUtil.isNotEmpty((Object)nowOrder.getMealExpireTime())) {
            if (nowOrder.getMealId().equals(meal.getId())) {
                memberOrder.setMealExpireTime((Date)DateUtil.offsetMonth((Date)nowOrder.getMealExpireTime(), (int)12));
            } else {
                memberOrder.setMealExpireTime((Date)DateUtil.offsetMonth((Date)new Date(), (int)12));
                long day = DateUtil.between((Date)nowOrder.getMealExpireTime(), (Date)new Date(), (DateUnit)DateUnit.DAY);
                double oldSumAmt = orders.stream().mapToDouble(x -> x.getPayAmt().doubleValue()).sum();
                BigDecimal dbDedAmt = new BigDecimal(oldSumAmt).divide(new BigDecimal(365), 2, RoundingMode.DOWN).multiply(new BigDecimal(day));
                Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)dedAmt), (String)"\u62b5\u6263\u91d1\u989d\u5f02\u5e38");
                Assert.isTrue((boolean)dbDedAmt.equals(dedAmt), (String)"\u62b5\u6263\u91d1\u989d\u5f02\u5e38");
            }
        }
    }

    @Override
    public List<MemberOrder> getOrderByElsAccount(String elsAccount) {
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MemberOrder::getToElsAccount, (Object)elsAccount)).eq(MemberOrder::getOrderStatus, (Object)OrderStatusEnum.COMPLETED.getCode()));
    }

    @Override
    public List<MemberOrder> getOverDueOrder() {
        return ((MemberOrderMapper)this.baseMapper).getOverDueOrder();
    }

    private String callIpassPay(MemberOrder memberOrder) {
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        JSONObject data = new JSONObject();
        data.put("rechargeType", (Object)memberOrder.getPayType());
        data.put("businessTag", (Object)"MCN");
        data.put("orderId", (Object)memberOrder.getId());
        data.put("orderAmt", (Object)memberOrder.getPayAmt());
        data.put("orderDate", (Object)DateUtil.format((Date)memberOrder.getCreateTime(), (String)"yyyyMMdd"));
        data.put("goodsName", (Object)memberOrder.getProductName());
        data.put("payType", (Object)"B2C");
        data.put("responseType", (Object)"HTML");
        data.put("pageNotifyUrl", (Object)(String.valueOf(serviceAddress) + "/srm/member/equity/indexPage"));
        data.put("backNotifyUrl", (Object)(String.valueOf(serviceAddress) + "/els/openApi/invokeSrm"));
        log.info("\u8c03\u7528ipass\u652f\u4ed8\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)data));
        JSONObject jsonObject = this.callIPaasInterface(data, "commonPayService", null);
        log.info("\u8c03\u7528ipass\u652f\u4ed8\u54cd\u5e94:{}", (Object)jsonObject.toJSONString());
        Assert.isTrue((boolean)jsonObject.getInteger("code").equals(200), (String)jsonObject.getString("message"));
        String decodeHtml = HtmlUtil.unescape((String)jsonObject.getJSONObject("data").getString("data"));
        log.info("decodeHtml\u54cd\u5e94:{}", (Object)decodeHtml);
        return decodeHtml;
    }

    public JSONObject callIPaasInterface(JSONObject data, String service, String interfaceCode) {
        String url = this.configMap.get("url");
        String elsAccount = this.configMap.get("elsAccount");
        String subAccount = this.configMap.get("subAccount");
        String pwd = this.configMap.get("pwd");
        String[] currentAccountServices = new String[]{"createOrder", "orderList", "confirmOrder", "cancelOrder", "orderDetail", "qualificationList", "expensesList", "getAmount", "commonPayService", "orderPayment", "commonPaySearch"};
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("elsAccount", elsAccount);
        header.put("subAccount", subAccount);
        header.put("pwd", pwd);
        JSONObject body = new JSONObject();
        String currentAccount = data.getString("currentAccount");
        if (StrUtil.isBlank((CharSequence)currentAccount)) {
            currentAccount = TenantContext.getTenant();
        }
        if (Arrays.asList(currentAccountServices).contains(service)) {
            currentAccount = TenantContext.getTenant();
        }
        body.put("elsAccount", (Object)currentAccount);
        body.put("businessString", (Object)EncryptAesUtil.aesEncrypt((String)"mcn-order-pay"));
        body.put("data", (Object)data);
        body.put("service", (Object)service);
        if (StrUtil.isNotBlank((CharSequence)interfaceCode)) {
            body.put("interfaceCode", (Object)interfaceCode);
        }
        try {
            log.info("callIPaasInterface_body:" + body.toJSONString());
            String response = ((HttpRequest)HttpRequest.post((String)url).addHeaders(header)).body(body.toString()).execute().body();
            log.info("callIPaasInterface_result:" + response);
            JSONObject responseObj = JSONObject.parseObject((String)response);
            if (!responseObj.getBoolean("success").booleanValue()) {
                return this.getErrorObj(responseObj.getString("message"));
            }
            String message = responseObj.getString("message");
            JSONObject returnData = responseObj.getJSONObject("result");
            return returnData == null ? this.getOkObj(message) : this.getOkObj(returnData);
        }
        catch (Exception var11) {
            log.error("iPaas\u63a5\u53e3\u8c03\u7528\u5931\u8d25:", (Throwable)var11);
            return this.getErrorObj(var11.getMessage());
        }
    }

    private JSONObject getErrorObj(String message) {
        JSONObject result = new JSONObject();
        result.put("success", (Object)false);
        result.put("code", (Object)CommonConstant.SC_INTERNAL_SERVER_ERROR_500);
        result.put("message", (Object)message);
        return result;
    }

    private JSONObject getOkObj(String message) {
        JSONObject result = new JSONObject();
        result.put("success", (Object)true);
        result.put("code", (Object)CommonConstant.SC_OK_200);
        result.put("message", (Object)message);
        return result;
    }

    private JSONObject getOkObj(JSONObject data) {
        JSONObject result = new JSONObject();
        result.put("success", (Object)true);
        result.put("code", (Object)CommonConstant.SC_OK_200);
        result.put("data", (Object)data);
        return result;
    }
}

