/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.supplier.mapper.MyScheduleExtendMapper;
import com.els.modules.supplier.service.MyScheduleExtendService;
import com.els.modules.supplier.vo.CustomScheduleVO;
import com.els.modules.supplier.vo.MySchedule;
import com.els.modules.supplier.vo.MyScheduleQueryVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class MyScheduleExtendServiceImpl
extends BaseServiceImpl<MyScheduleExtendMapper, MySchedule>
implements MyScheduleExtendService {
    private int getMonthDays(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, 1);
        cal.roll(5, -1);
        return cal.getActualMaximum(5);
    }

    private String addZeroForNum(String str, int strLength) {
        int strLen = str.length();
        StringBuffer sb = null;
        while (strLen < strLength) {
            sb = new StringBuffer();
            sb.append("0").append(str);
            str = sb.toString();
            strLen = str.length();
        }
        return str;
    }

    @Override
    public void add(MySchedule mySchedule) {
        if (ObjectUtils.isEmpty((Object)mySchedule.getBeginTime())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_vKKIxiTLVW_9cc437a6", (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01"));
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        String beginDate = dateFormat.format(mySchedule.getBeginTime());
        mySchedule.setScheduleYear(beginDate.substring(0, 4));
        mySchedule.setScheduleMonth(beginDate.substring(4, 6));
        mySchedule.setScheduleDay(beginDate.substring(6, 8));
        ((MyScheduleExtendMapper)this.baseMapper).insert((Object)mySchedule);
    }

    @Override
    public void edit(MySchedule mySchedule) {
        int count = ((MyScheduleExtendMapper)this.baseMapper).updateById((Object)mySchedule);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((MyScheduleExtendMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((MyScheduleExtendMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Map<String, List> queryMySchedule(MyScheduleQueryVO queryVO) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMM");
        String currentYear = null;
        String currentMonth = null;
        if (queryVO.getQueryDate() == null) {
            Date nowDate = new Date();
            currentYear = dateFormat.format(nowDate).substring(0, 4);
            currentMonth = dateFormat.format(nowDate).substring(4, 6);
        } else {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                Date parseDate = simpleDateFormat.parse(queryVO.getQueryDate());
                currentYear = dateFormat.format(parseDate).substring(0, 4);
                currentMonth = dateFormat.format(parseDate).substring(4, 6);
            }
            catch (ParseException simpleDateFormat) {
                // empty catch block
            }
        }
        HashMap<String, List> returnMap = new HashMap<String, List>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"schedule_year", (Object)currentYear);
        queryWrapper.eq((Object)"schedule_month", (Object)currentMonth);
        queryWrapper.eq((Object)"sub_account", (Object)SysUtil.getLoginUser().getSubAccount());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        List<MySchedule> myScheduleList = Objects.equals(TenantContext.getTenant(), queryVO.getElsAccount()) ? ((MyScheduleExtendMapper)this.baseMapper).selectList((Wrapper)queryWrapper) : ((MyScheduleExtendMapper)this.baseMapper).selectWithoutElsAccountList(queryVO.getElsAccount(), queryVO.getSubAccount(), currentYear, currentMonth);
        int monthDays = this.getMonthDays(Integer.valueOf(currentYear), Integer.valueOf(currentMonth.replaceAll("^(0+)", "")));
        int i = 1;
        while (i <= monthDays) {
            ArrayList returnList = new ArrayList();
            String tmpDay = this.addZeroForNum(String.valueOf(i), 2);
            List tmpList = myScheduleList.stream().filter(o -> o.getScheduleDay().equals(tmpDay)).collect(Collectors.toList());
            tmpList = tmpList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MySchedule>(Comparator.comparing(c -> String.valueOf(c.getElsAccount()) + ":" + c.getSubAccount() + ":" + c.getSourceNumber() + ":" + c.getBeginTime() + ":" + c.getEndTime()))), ArrayList::new));
            for (MySchedule mySchedule : tmpList) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                String type = Objects.equals(mySchedule.getScheduleType(), "custom") ? "processing" : "warning";
                tmpMap.put("type", type);
                tmpMap.put("content", mySchedule.getContent());
                tmpMap.put("id", mySchedule.getId());
                tmpMap.put("fbk1", mySchedule.getFbk1());
                returnList.add(tmpMap);
            }
            returnMap.put(String.valueOf(i), returnList);
            ++i;
        }
        return returnMap;
    }

    @Override
    @SrmTransaction
    public void addCustomSchedule(CustomScheduleVO customScheduleVO) {
        LocalDateTime now = LocalDateTimeUtil.now();
        LocalDateTime startDateTime = LocalDateTimeUtil.of((Date)customScheduleVO.getStartTime());
        LocalDateTime endDateTime = LocalDateTimeUtil.of((Date)customScheduleVO.getEndTime());
        String startTimeStr = LocalDateTimeUtil.format((LocalDateTime)startDateTime, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        String endTimeStr = LocalDateTimeUtil.format((LocalDateTime)endDateTime, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        Assert.isTrue((boolean)Objects.equals(customScheduleVO.getCurrentDate(), startTimeStr), (String)I18nUtil.translate((String)"i18n_alert_BLvKKIBAUGRBAxIR_24f3742f", (String)"\u65e5\u7a0b\u5f00\u59cb\u65f6\u95f4\u65e5\u671f\u4e0e\u8bbe\u7f6e\u65e5\u671f\u4e0d\u4e00\u81f4\uff01"));
        Assert.isTrue((boolean)Objects.equals(customScheduleVO.getCurrentDate(), endTimeStr), (String)I18nUtil.translate((String)"i18n_alert_BLyWKIBAUGRBAxIR_9e1f89ae", (String)"\u65e5\u7a0b\u7ed3\u675f\u65f6\u95f4\u65e5\u671f\u4e0e\u8bbe\u7f6e\u65e5\u671f\u4e0d\u4e00\u81f4\uff01"));
        Assert.isTrue((boolean)startDateTime.toLocalDate().isAfter(now.toLocalDate()), (String)I18nUtil.translate((String)"i18n_alert_BLGRBAdfUAPBA_1b6cf0e2", (String)"\u65e5\u7a0b\u8bbe\u7f6e\u65e5\u671f\u5e94\u5927\u4e8e\u5f53\u524d\u65e5\u671f\uff01"));
        Assert.isTrue((boolean)endDateTime.isAfter(startDateTime), (String)I18nUtil.translate((String)"i18n_alert_BLyWKIdfUBLvKKI_6b5a8887", (String)"\u65e5\u7a0b\u7ed3\u675f\u65f6\u95f4\u5e94\u5927\u4e8e\u65e5\u7a0b\u5f00\u59cb\u65f6\u95f4\uff01"));
        LoginUser loginUser = SysUtil.getLoginUser();
        int count = ((MyScheduleExtendMapper)this.baseMapper).selectWithoutElsAccountConflict(TenantContext.getTenant(), loginUser.getSubAccount(), customScheduleVO.getStartTime(), customScheduleVO.getEndTime());
        Assert.isTrue((count <= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APIIjBLjVPsMKm_5dbd60fd", (String)"\u5f53\u524d\u5b9a\u4e49\u7684\u65e5\u7a0b\u6709\u51b2\u7a81\uff0c\u4fdd\u5b58\u5931\u8d25\uff01"));
        MySchedule mySchedule = new MySchedule();
        mySchedule.setElsAccount(TenantContext.getTenant());
        mySchedule.setSubAccount(loginUser.getSubAccount());
        mySchedule.setBeginTime(customScheduleVO.getStartTime());
        mySchedule.setEndTime(customScheduleVO.getEndTime());
        String content = String.format("%s\uff0c\u65e5\u7a0b\u65f6\u95f4\uff1a%s-%s", customScheduleVO.getScheduleName(), LocalDateTimeUtil.format((LocalDateTime)startDateTime, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), LocalDateTimeUtil.format((LocalDateTime)endDateTime, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        mySchedule.setContent(content);
        mySchedule.setScheduleYear(String.valueOf(startDateTime.getYear()));
        String month = startDateTime.getMonthValue() < 10 ? "0" + startDateTime.getMonthValue() : String.valueOf(startDateTime.getMonthValue());
        mySchedule.setScheduleMonth(month);
        String day = startDateTime.getDayOfMonth() < 10 ? "0" + startDateTime.getDayOfMonth() : String.valueOf(startDateTime.getDayOfMonth());
        mySchedule.setScheduleDay(day);
        mySchedule.setScheduleName(customScheduleVO.getScheduleName());
        mySchedule.setScheduleType("custom");
        mySchedule.setCreateById(loginUser.getId());
        mySchedule.setUpdateById(loginUser.getId());
        ((MyScheduleExtendMapper)this.baseMapper).insert((Object)mySchedule);
    }

    @Override
    @SrmTransaction
    public void delCustomSchedule(String currentDate) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)currentDate), (String)I18nUtil.translate((String)"i18n_alert_ViFTQGJIIBLjBA_76c4e4b5", (String)"\u8bf7\u9009\u62e9\u9700\u5220\u9664\u81ea\u5b9a\u4e49\u65e5\u7a0b\u7684\u65e5\u671f\uff01"));
        LocalDateTime delCustomDate = LocalDateTimeUtil.parse((CharSequence)currentDate, (String)"yyyyMMdd");
        LocalDateTime now = LocalDateTimeUtil.now();
        Assert.isTrue((boolean)delCustomDate.toLocalDate().isAfter(now.toLocalDate()), (String)I18nUtil.translate((String)"i18n_alert_RqQGfUAPBAjJIIBL_e457a502", (String)"\u53ea\u53ef\u5220\u9664\u5927\u4e8e\u5f53\u524d\u65e5\u671f\u7684\u81ea\u5b9a\u4e49\u65e5\u7a0b\uff01"));
        LoginUser loginUser = SysUtil.getLoginUser();
        ((MyScheduleExtendMapper)this.baseMapper).delCustomSchedule(TenantContext.getTenant(), loginUser.getSubAccount(), currentDate);
    }
}

