/*
 * Decompiled with CFR 0.152.
 */
package com.els.aspect;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.annotation.ApiCallCount;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.amateur.api.service.ApiCallCountRpcService;
import com.els.modules.apirecord.enumerate.ApiTypeEnum;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Aspect
@Component
@EnableAspectJAutoProxy
public class ApiCallCountAspect {
    @Resource
    private ApiCallCountRpcService apiCallCountRpcService;
    public static final ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor(){
        {
            this.setCorePoolSize(3);
            this.setMaxPoolSize(5);
            this.setKeepAliveSeconds(60);
            this.initialize();
        }
    };

    @Pointcut(value="@annotation(com.els.common.annotation.ApiCallCount)")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void before(JoinPoint point) {
        if (point.getArgs() == null || point.getArgs().length <= 0) {
            return;
        }
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        ApiCallCount apiCallCount = method.getAnnotation(ApiCallCount.class);
        this.apiCallCountRpcService.checkApiLimit(apiCallCount.apiCode());
    }

    @After(value="pointcut()")
    public void after(JoinPoint point) {
        boolean pageFlag;
        if (point.getArgs() == null || point.getArgs().length <= 0) {
            return;
        }
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        ApiCallCount apiCallCount = method.getAnnotation(ApiCallCount.class);
        Object[] args = point.getArgs();
        ApiTypeEnum apiTypeEnum = ApiTypeEnum.getApiTypeEnumByCode((String)apiCallCount.apiCode());
        if (apiTypeEnum == null) {
            return;
        }
        boolean bl = pageFlag = args.length > 2 && ObjectUtil.isNotNull((Object)args[1]) && !args[1].equals(1);
        if (ObjectUtil.isNotNull((Object)args) && ObjectUtil.isNotNull((Object)args[0]) && args[0] instanceof SimplePostRequestParam) {
            SimplePostRequestParam param = (SimplePostRequestParam)args[0];
            pageFlag = !param.getPageNo().equals(1);
        }
        if (ApiTypeEnum.isListLimit((ApiTypeEnum)apiTypeEnum) && pageFlag) {
            return;
        }
        String id = this.handelReqId(args);
        String elsAccount = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        if (StrUtil.isBlank((CharSequence)elsAccount) || ObjectUtil.isEmpty((Object)loginUser) || StrUtil.isBlank((CharSequence)loginUser.getSubAccount())) {
            return;
        }
        taskExecutor.execute((Runnable)new Thread(() -> this.apiCallCountRpcService.saveApiCallRecord(apiCallCount.apiCode(), id, elsAccount, loginUser.getSubAccount())));
    }

    private String handelReqId(Object[] args) {
        if (ObjectUtil.isNotEmpty((Object)args) && args.length == 1) {
            return args[0].toString();
        }
        return null;
    }
}

