/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.organ.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.DictModel;
import com.els.config.mybatis.TenantContext;
import com.els.modules.organ.mapper.PurchaserOrganIndustryReleaseItemMapper;
import com.els.modules.organ.responsevo.PurchaserOrganCategoryData;
import com.els.modules.organ.service.PurchaserOrganHeadCategoryService;
import com.els.modules.system.service.DictExtendService;
import com.mongodb.client.MongoCursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class PurchaserOrganHeadCategoryServiceImpl
implements PurchaserOrganHeadCategoryService {
    @Autowired
    PurchaserOrganIndustryReleaseItemMapper industryReleaseItemMapper;
    @Autowired
    private DictExtendService dictService;
    @Resource
    private MongoTemplate mongoTemplate;
    private final String MCN_CATGORY_DETAIL_COLLECTION_NAME = "tb_kuaifenxiao_invite_category";

    @Override
    public List<PurchaserOrganCategoryData> getXhsCategory() {
        LinkedList<PurchaserOrganCategoryData> resultData = new LinkedList<PurchaserOrganCategoryData>();
        PurchaserOrganCategoryData contentCategory = new PurchaserOrganCategoryData();
        contentCategory.setTitle("\u673a\u6784\u5206\u7c7b");
        contentCategory.setSort(1);
        contentCategory.setFieldName("contentType");
        List xhsCategoryByPlatform = this.industryReleaseItemMapper.getXhsCategoryByPlatform();
        contentCategory.setChildren(xhsCategoryByPlatform);
        resultData.add(contentCategory);
        String code = "signerNum;noteNum;liveNum;fanNum";
        resultData.add(this.getResultData(code, 2, "\u6570\u636e\u7b5b\u9009", "dataFiltering"));
        return resultData;
    }

    @Override
    public List<PurchaserOrganCategoryData> getKsCategory() {
        LinkedList<PurchaserOrganCategoryData> resultData = new LinkedList<PurchaserOrganCategoryData>();
        this.getCategoryData(resultData);
        String code = "activityNum;singleQuantityAvg;singleGoodsNum;singleStoreNum;customerPrice;linkInformation";
        resultData.add(this.getResultData(code, 2, "\u6761\u4ef6\u7b5b\u9009", "conditional"));
        return resultData;
    }

    private PurchaserOrganCategoryData getResultData(String code, int sort, String title, String fieldName) {
        List<Map<String, List<DictModel>>> maps = this.dictService.queryDictItemsByCodeList(code, TenantContext.getTenant());
        PurchaserOrganCategoryData ksPurchaserOrganCategoryData = new PurchaserOrganCategoryData();
        if (CollectionUtils.isNotEmpty(maps)) {
            String[] split;
            ksPurchaserOrganCategoryData.setSort(sort);
            ksPurchaserOrganCategoryData.setTitle(title);
            ksPurchaserOrganCategoryData.setFieldName(fieldName);
            ArrayList<PurchaserOrganCategoryData.Children> paramList = new ArrayList<PurchaserOrganCategoryData.Children>();
            Map<String, List<DictModel>> map = maps.get(0);
            for (String str : split = code.split(";")) {
                this.getCategoryDataByDict(paramList, str, map);
            }
            ksPurchaserOrganCategoryData.setChildren(paramList);
        }
        return ksPurchaserOrganCategoryData;
    }

    public void getCategoryData(List<PurchaserOrganCategoryData> resultData) {
        PurchaserOrganCategoryData ksPurchaserOrganCategoryData = new PurchaserOrganCategoryData();
        ksPurchaserOrganCategoryData.setSort(1);
        ksPurchaserOrganCategoryData.setTitle("\u5185\u5bb9\u5206\u7c7b");
        ksPurchaserOrganCategoryData.setFieldName("contentType");
        ArrayList<PurchaserOrganCategoryData.Children> ksCategory = new ArrayList<PurchaserOrganCategoryData.Children>();
        MongoCursor attractCursor = this.mongoTemplate.getCollection("tb_kuaifenxiao_invite_category").find().noCursorTimeout(true).cursor();
        Document attract = null;
        while (attractCursor.hasNext()) {
            try {
                attract = (Document)attractCursor.next();
                if ("\u9996\u9875".equals(attract.getString((Object)"category"))) continue;
                PurchaserOrganCategoryData.Children purchaserOrganCategoryData = new PurchaserOrganCategoryData.Children();
                purchaserOrganCategoryData.setStarTagId(String.valueOf(attract.getInteger((Object)"category_id")));
                purchaserOrganCategoryData.setComponent("RButton");
                purchaserOrganCategoryData.setStarTagValue("category");
                purchaserOrganCategoryData.setStarTagName(attract.getString((Object)"category"));
                ksCategory.add(purchaserOrganCategoryData);
            }
            catch (Exception e) {
                new ELSBootException((Throwable)e);
            }
        }
        ksPurchaserOrganCategoryData.setChildren(ksCategory);
        resultData.add(ksPurchaserOrganCategoryData);
    }

    private void getCategoryDataByDict(List<PurchaserOrganCategoryData.Children> paramList, String name, Map<String, List<DictModel>> map) {
        for (String key : map.keySet()) {
            if (!name.equals(key)) continue;
            PurchaserOrganCategoryData.Children ksPurchaserOrganCategoryData = new PurchaserOrganCategoryData.Children();
            String value = "linkInformation".equals(this.getString(name).get("value")) ? "RCheckbox" : "RCustomSelect";
            ksPurchaserOrganCategoryData.setComponent(value);
            ksPurchaserOrganCategoryData.setStarTagName(this.getString(name).get("name"));
            ksPurchaserOrganCategoryData.setStarTagValue(this.getString(name).get("value"));
            ArrayList subTagsList = new ArrayList();
            List<DictModel> dictModels = map.get(key);
            dictModels.forEach(a -> {
                PurchaserOrganCategoryData.SubTags subTags = new PurchaserOrganCategoryData.SubTags();
                subTags.setStarTagName(a.getText());
                subTags.setStarTagValue(a.getValue());
                subTagsList.add(subTags);
            });
            ksPurchaserOrganCategoryData.setSubTags(subTagsList);
            paramList.add(ksPurchaserOrganCategoryData);
        }
    }

    private Map<String, String> getString(String text) {
        HashMap<String, String> map = new HashMap<String, String>();
        String str = null;
        String value = null;
        switch (text) {
            case "activityNum": {
                str = "\u62db\u5546\u6d3b\u52a8\u6570";
                value = "activityNum";
                map.put("name", str);
                map.put("value", value);
                break;
            }
            case "singleQuantityAvg": {
                str = "\u5355\u54c1\u5e73\u5747\u6210\u4ea4\u91cf";
                value = "singleQuantityAvg";
                map.put("name", str);
                map.put("value", value);
                break;
            }
            case "singleGoodsNum": {
                str = "\u51fa\u5355\u5546\u54c1\u6570";
                value = "singleGoodsNum";
                map.put("name", str);
                map.put("value", value);
                break;
            }
            case "singleStoreNum": {
                str = "\u51fa\u5355\u5546\u5bb6\u6570";
                value = "singleStoreNum";
                map.put("name", str);
                map.put("value", value);
                break;
            }
            case "customerPrice": {
                str = "\u5ba2\u5355\u4ef7";
                value = "customerPrice";
                map.put("name", str);
                map.put("value", value);
                break;
            }
            case "linkInformation": {
                str = "\u6709\u8054\u7cfb\u65b9\u5f0f";
                value = "linkInformation";
                map.put("name", str);
                map.put("value", value);
                break;
            }
            case "signerNum": {
                str = "\u7b7e\u7ea6\u8fbe\u4eba\u6570";
                value = "signerNum";
                map.put("name", str);
                map.put("value", value);
                break;
            }
            case "noteNum": {
                str = "\u7b14\u8bb0\u8fbe\u4eba\u6570";
                value = "noteNum";
                map.put("name", str);
                map.put("value", value);
                break;
            }
            case "liveNum": {
                str = "\u76f4\u64ad\u8fbe\u4eba\u6570";
                value = "liveNum";
                map.put("name", str);
                map.put("value", value);
                break;
            }
            case "fanNum": {
                str = "\u8fbe\u4eba\u7c89\u4e1d\u603b\u6570";
                value = "fanNum";
                map.put("name", str);
                map.put("value", value);
                break;
            }
        }
        return map;
    }
}

