/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.ApiLimitErrorEnum;
import com.els.common.enumerate.TenantControlModeEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.ApiCallCountRpcService;
import com.els.modules.apirecord.enumerate.ApiTypeEnum;
import com.els.modules.apirecord.service.ApiCallRecordService;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.enterpriseorgan.service.ElsTopManEnterpriseOrganHeadService;
import com.els.modules.enterpriseresource.entity.TopManAddElsRecordEntity;
import com.els.modules.enterpriseresource.enumerate.DecideStatusEnum;
import com.els.modules.enterpriseresource.service.TopManAddElsRecordService;
import com.els.modules.industryInfo.api.service.IndustryInforRpcService;
import com.els.modules.system.entity.McnTenantParamConfig;
import com.els.modules.system.mapper.McnTenantParamConfigMapper;
import com.els.modules.system.service.McnTenantParamConfigService;
import com.els.modules.system.vo.TenantParamConfigVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class McnTenantParamConfigServiceImpl
extends BaseServiceImpl<McnTenantParamConfigMapper, McnTenantParamConfig>
implements McnTenantParamConfigService {
    private static final String REDIS_KEY = "sys:tenant:config:";
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private AccountRpcService accountRpcService;
    @Resource
    private CompanyStoreHeadService companyStoreHeadService;
    @Resource
    private TopManAddElsRecordService topManAddElsRecordService;
    @Resource
    private IndustryInforRpcService industryInforRpcService;
    @Resource
    private ElsTopManEnterpriseOrganHeadService elsTopManEnterpriseOrganHeadService;
    @Resource
    @Lazy
    private ApiCallCountRpcService apiCallCountRpcService;
    @Resource
    @Lazy
    private ApiCallRecordService apiCallRecordService;

    private String getRedisKey(String elsAccount, String configCode) {
        StringBuilder redisKey = new StringBuilder(REDIS_KEY);
        redisKey.append(elsAccount);
        redisKey.append(configCode);
        return redisKey.toString();
    }

    @Override
    public void add(McnTenantParamConfig tenantParamConfig) {
        ((McnTenantParamConfigMapper)this.baseMapper).insert((Object)tenantParamConfig);
    }

    @Override
    public void edit(McnTenantParamConfig tenantParamConfig) {
        ((McnTenantParamConfigMapper)this.baseMapper).updateById((Object)tenantParamConfig);
        List configs = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(McnTenantParamConfig::getConfigCode, (Object)tenantParamConfig.getConfigCode())).ne(BaseEntity::getElsAccount, (Object)"100000")).eq(McnTenantParamConfig::getDeleted, (Object)"0"));
        if (CollUtil.isNotEmpty((Collection)configs)) {
            configs.forEach(x -> x.setControlMode(tenantParamConfig.getControlMode()));
            this.updateBatchById(configs);
        }
    }

    @Override
    public void delete(String id) {
        ((McnTenantParamConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public List<McnTenantParamConfig> findList(String elsAccount) {
        return ((McnTenantParamConfigMapper)this.baseMapper).findList(elsAccount, SysUtil.getPurchaseAccount());
    }

    @Override
    @Transactional
    public void saveTenantConfig(TenantParamConfigVO configVO) {
        List<McnTenantParamConfig> configList = configVO.getConfigList();
        ArrayList<McnTenantParamConfig> insertList = new ArrayList<McnTenantParamConfig>();
        ArrayList<McnTenantParamConfig> updateList = new ArrayList<McnTenantParamConfig>();
        for (McnTenantParamConfig config : configList) {
            if (StrUtil.isBlank((CharSequence)config.getCompanyId())) {
                McnTenantParamConfig tenantConfig = new McnTenantParamConfig();
                BeanUtils.copyProperties((Object)((Object)config), (Object)((Object)tenantConfig));
                tenantConfig.setId(null);
                tenantConfig.setElsAccount(configVO.getElsAccount());
                insertList.add(tenantConfig);
            } else {
                config.setId(config.getCompanyId());
                updateList.add(config);
            }
            this.redisUtil.del(new String[]{this.getRedisKey(configVO.getElsAccount(), config.getConfigCode())});
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList);
        }
        if (!updateList.isEmpty()) {
            this.updateBatchById(updateList);
        }
    }

    @Override
    public String getOneConfig(String elsAccount, String configCode) {
        String result = (String)this.redisUtil.get(this.getRedisKey(elsAccount, configCode));
        if (StrUtil.isNotBlank((CharSequence)result)) {
            return result;
        }
        McnTenantParamConfig config = ((McnTenantParamConfigMapper)this.baseMapper).getOneConfig(elsAccount, configCode);
        result = config == null || StrUtil.isBlank((CharSequence)config.getUnlimited()) || "1".equals(config.getUnlimited()) ? "Y" : config.getDefaultValue();
        this.redisUtil.set(this.getRedisKey(elsAccount, configCode), (Object)result);
        return result;
    }

    @Override
    public McnTenantParamConfig getOneConfigDb(String elsAccount, String configCode) {
        McnTenantParamConfig config = (McnTenantParamConfig)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(McnTenantParamConfig::getConfigCode, (Object)configCode)).eq(McnTenantParamConfig::getDeleted, (Object)"0")));
        return config;
    }

    @Override
    public void incr(Long count, String elsAccount, String configCode) {
        McnTenantParamConfig config = this.getOneConfigDb(elsAccount, configCode);
        this.updateById((Object)config);
    }

    @Override
    public void check(String configCode) {
        String result;
        ApiTypeEnum config = ApiTypeEnum.getApiTypeEnumByConfigCode(configCode);
        if (ObjectUtil.isEmpty((Object)((Object)config))) {
            return;
        }
        String elsAccount = TenantContext.getTenant();
        String selectCode = configCode;
        if (configCode.equals(ApiTypeEnum.SUB_ACCOUNT_NUM_THAW.getConfigCode())) {
            selectCode = ApiTypeEnum.SUB_ACCOUNT_NUM.getConfigCode();
        }
        if (ObjectUtil.isEmpty((Object)(result = this.getOneConfig(elsAccount, selectCode))) || "Y".equals(result)) {
            return;
        }
        McnTenantParamConfig tenantParamConfig = this.getOneConfigDb(elsAccount, configCode);
        if (ObjectUtil.isEmpty((Object)((Object)tenantParamConfig))) {
            return;
        }
        boolean isSubAccount = TenantControlModeEnum.SUB_ACCOUNT.value.equals(tenantParamConfig.getControlMode());
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        if (!"Y".equals(result)) {
            long num = Long.valueOf(result);
            switch (config) {
                case SUB_ACCOUNT_NUM: 
                case SUB_ACCOUNT_NUM_THAW: {
                    List accounts = this.accountRpcService.getAllByAccount(elsAccount);
                    long count = accounts.stream().filter(x -> x.getDeleted().equals(CommonConstant.STATUS_NO) && x.getStatus().equals(CommonConstant.STATUS_YES)).count();
                    AssertI18nUtil.isTrue((count >= num ? 1 : 0) != 0, (Enum)(config.equals((Object)ApiTypeEnum.SUB_ACCOUNT_NUM) ? ApiLimitErrorEnum.USER_NUM_LIMIT_MESSAGE : ApiLimitErrorEnum.NUM_LIMIT_MESSAGE));
                    break;
                }
                case SHOP_ADD_NUM: {
                    int count2 = this.companyStoreHeadService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)"0")).eq(isSubAccount, BaseEntity::getCreateBy, (Object)subAccount));
                    AssertI18nUtil.isTrue(((long)count2 >= num ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE);
                    break;
                }
                case INDUSTRY_TOP_MAIN_ADD_DATA: {
                    int count3 = this.topManAddElsRecordService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)"0")).in(TopManAddElsRecordEntity::getDecideStatus, Arrays.asList(DecideStatusEnum.CONFIRMED.getCode(), DecideStatusEnum.TO_BE_CONFIRMED.getCode()))).eq(isSubAccount, TopManAddElsRecordEntity::getSubAccount, (Object)subAccount));
                    AssertI18nUtil.isTrue(((long)count3 >= num ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE);
                    break;
                }
                case INDUSTRY_TOP_MAIN_COLLECT_DATA: {
                    long count4 = this.industryInforRpcService.countTopManByElsAccount(elsAccount, isSubAccount, subAccount);
                    AssertI18nUtil.isTrue((count4 >= num ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE);
                    break;
                }
                case INDUSTRY_GOODS_COLLECT_DATA: {
                    long count5 = this.industryInforRpcService.countGoodsCollectByElsAccount(elsAccount, isSubAccount, subAccount);
                    AssertI18nUtil.isTrue((count5 >= num ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE);
                    break;
                }
                case INDUSTRY_INSTITUTION_ADD_DATA: {
                    long count6 = this.elsTopManEnterpriseOrganHeadService.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)"0"));
                    AssertI18nUtil.isTrue((count6 >= num ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE);
                    break;
                }
                case INDUSTRY_SHOP_COLLECT_DATA: {
                    long count7 = this.industryInforRpcService.countShopCollectByElsAccount(elsAccount, isSubAccount, subAccount);
                    AssertI18nUtil.isTrue((count7 >= num ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE);
                    break;
                }
            }
        }
    }

    @Override
    public void resetCount(String configCode, String elsAccount) {
        ApiTypeEnum apiTypeEnum;
        List<String> subAccounts;
        McnTenantParamConfig config = this.getOneConfigDb(elsAccount, configCode);
        if (ObjectUtil.isNotNull((Object)((Object)config)) && CollUtil.isNotEmpty(subAccounts = this.apiCallRecordService.getAllSubAccount((apiTypeEnum = ApiTypeEnum.getApiTypeEnumByConfigCode(configCode)).getCode(), elsAccount))) {
            subAccounts.forEach(x -> this.apiCallCountRpcService.removeRedisCache(apiTypeEnum.getCode(), elsAccount, x));
        }
    }

    @Override
    public void checkDetail(String configCode) {
        String selectCode;
        ApiTypeEnum config = ApiTypeEnum.getApiTypeEnumByConfigCode(configCode);
        if (ObjectUtil.isEmpty((Object)((Object)config))) {
            return;
        }
        String elsAccount = TenantContext.getTenant();
        String num = this.getOneConfig(elsAccount, selectCode = configCode);
        if (!"Y".equals(num)) {
            Long limitNum = Long.valueOf(num);
            Long countNum = null;
            McnTenantParamConfig configDb = this.getOneConfigDb(elsAccount, configCode);
            String redisKey = "api:count:str:" + elsAccount + ":" + config.getCode();
            if (TenantControlModeEnum.SUB_ACCOUNT.value.equals(configDb.getControlMode())) {
                redisKey = "api:count:str:" + elsAccount + ":" + SysUtil.getLoginUser().getSubAccount() + ":" + config.getCode();
            }
            if (!this.redisUtil.hasKey(redisKey)) {
                return;
            }
            String numStr = (String)this.redisUtil.get(redisKey);
            countNum = Long.valueOf(numStr);
            AssertI18nUtil.isTrue((countNum >= limitNum ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE);
        }
    }

    @Override
    public List<McnTenantParamConfig> getTrialConfig(String elsAccount) {
        return ((McnTenantParamConfigMapper)this.baseMapper).getTrialConfig(elsAccount);
    }
}

