/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.member.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.DictModel;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsEmailConfigDTO;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.ipaas.entity.PayEnum;
import com.els.modules.ipaas.entity.PaymentCallBackEntity;
import com.els.modules.member.entity.Member;
import com.els.modules.member.entity.MemberMeal;
import com.els.modules.member.entity.MemberOrder;
import com.els.modules.member.enumerate.MealTypeEnum;
import com.els.modules.member.enumerate.OrderStatusEnum;
import com.els.modules.member.enumerate.PayStatusEnum;
import com.els.modules.member.service.MemberMealService;
import com.els.modules.member.service.MemberOrderService;
import com.els.modules.member.service.MemberService;
import com.els.modules.member.service.impl.MemberServiceImpl;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.McnTenantParamConfig;
import com.els.modules.system.entity.Role;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.McnTenantParamConfigService;
import com.els.modules.system.service.RoleService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Service;

@Service(value="mcnIPaaSCallbackServiceImpl")
public class McnIPaaSCallbackServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(McnIPaaSCallbackServiceImpl.class);
    @Autowired
    private MemberOrderService memberOrderService;
    @Autowired
    private MemberMealService memberMealService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private McnTenantParamConfigService mcnTenantParamConfigService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private DictService dictService;
    @Value(value="${els.env}")
    private String ENV_KEY;
    @Resource
    private ElsTenantService elsTenantService;

    private boolean checkOrderSuccess(PaymentCallBackEntity callBackEntity) {
        PayEnum payEnum = Arrays.stream(PayEnum.values()).filter(x -> x.getValue().equals(callBackEntity.getPayType())).findFirst().get();
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)payEnum), (String)I18nUtil.translate((String)"i18n_alert_WWWRBMTKmWSMxuRBAc_d975e0b7", (String)"SRM\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff0c\u83b7\u53d6\u4e0d\u5230\u652f\u4ed8\u7c7b\u578b"), (Object[])new Object[0]);
        boolean flag = false;
        switch (payEnum) {
            case ALIPAY: {
                if (!callBackEntity.isSignVerify() || !"TRADE_SUCCESS".equals(callBackEntity.getRespCode())) break;
                flag = true;
                break;
            }
            case WXPAY: {
                if (!callBackEntity.isSignVerify() || !"SUCCESS".equals(callBackEntity.getRespCode())) break;
                flag = true;
                break;
            }
            case FUIOUPAY: {
                if (!callBackEntity.isSignVerify() || !"0000".equals(callBackEntity.getRespCode()) || !"11".equals(callBackEntity.getOrderSt())) break;
                flag = true;
            }
        }
        Assert.isTrue((boolean)flag, (String)(I18nUtil.translate((String)"i18n_alert_WWWRBMTWBjRBddLKmWItWW_acb12ab", (String)"SRM\u652f\u4ed8\u56de\u8c03\uff0c\u5bcc\u53cb\u652f\u4ed8\u54cd\u5e94\u4e3a\u5931\u8d25,\u8ba2\u5355ID\u3010") + callBackEntity.getOrderId() + "\u3011"), (Object[])new Object[0]);
        return flag;
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public JSONObject invoke(JSONObject param) {
        log.info("\u63a5\u6536\u5230ipass\u652f\u4ed8\u56de\u8c03:{}", (Object)param.toJSONString());
        PaymentCallBackEntity callBackEntity = (PaymentCallBackEntity)JSONObject.toJavaObject((JSON)param, PaymentCallBackEntity.class);
        if (this.checkOrderSuccess(callBackEntity)) {
            MemberOrder memberOrder = (MemberOrder)((Object)this.memberOrderService.getById((Serializable)((Object)callBackEntity.getOrderId())));
            if (ObjectUtil.isEmpty((Object)((Object)memberOrder))) {
                log.error("ipass\u652f\u4ed8\u56de\u8c03\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u8bb0\u5f55,ipass\u53c2\u6570{}", (Object)param.toJSONString());
            }
            if (OrderStatusEnum.COMPLETED.getCode().equals(memberOrder.getOrderStatus())) {
                log.error("ipass\u652f\u4ed8\u56de\u8c03\u5bf9\u5e94\u7684\u8ba2\u5355[{}]\u5df2\u662f\u5b8c\u6210\u72b6\u6001", (Object)memberOrder.getOrderNo());
                return null;
            }
            memberOrder.setOrderStatus(OrderStatusEnum.COMPLETED.getCode());
            memberOrder.setPayStatus(OrderStatusEnum.COMPLETED.getCode());
            memberOrder.setPayTime(new Date());
            memberOrder.setPayStatus(PayStatusEnum.PAID.getCode());
            this.memberOrderService.updateById((Object)memberOrder);
            TenantContext.setTenant((String)memberOrder.getToElsAccount());
            this.handleMemberPermission(memberOrder);
            this.sendEmail(memberOrder);
        }
        return null;
    }

    private void sendEmail(MemberOrder memberOrder) {
        ElsEmailConfigDTO config = this.invokeBaseRpcService.getEmailConfig(TenantContext.getTenant());
        List dictModels = this.dictService.queryDictItemsByCode("mcnMemberAccountNotice", "100000");
        DictModel dictModel = dictModels.stream().filter(x -> "EmailAccount".equals(x.getText())).findFirst().get();
        String smsTemplate = "ELS\u8d26\u53f7\uff1a#{[elsAccount]}<br>\u4f01\u4e1a\u540d\u79f0\uff1a#{[companyName]}<br>\u7c7b\u578b\uff1a#{[type]}<br>\u4ed8\u8d39\u65f6\u95f4\uff1a#{[payTime]}<br>\u8bf7\u7ba1\u7406\u5458\u53ca\u65f6\u767b\u5f55\u8fbe\u4eba\u901a\u7cfb\u7edf(#{[env]})\u7ed9\u8be5\u79df\u6237\u914d\u7f6e\u4f1a\u5458\u6743\u9650";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("elsAccount", memberOrder.getToElsAccount());
        params.put("companyName", memberOrder.getToElsAccountName());
        params.put("type", "\u7531\u8bd5\u7528\u7248\u5347\u7ea7\u4e3a" + memberOrder.getProductName());
        params.put("payTime", DateUtil.format((Date)memberOrder.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        String env = Arrays.asList("dev", "sit").contains(this.ENV_KEY) ? "https://mcn-sit.51qqt.com" : "https://mcn-" + this.ENV_KEY + ".51qqt.com";
        params.put("env", env);
        SpelExpressionParser parser = new SpelExpressionParser();
        TemplateParserContext parserContext = new TemplateParserContext();
        String content = (String)parser.parseExpression(smsTemplate, (ParserContext)parserContext).getValue(params, String.class);
        MemberServiceImpl.sendEmail(config, dictModel.getValue().split(","), "\u8fbe\u4eba\u901a\u4f1a\u5458\u5347\u7ea7\u7eed\u8d39\u901a\u77e5", content, null, false);
    }

    private void handleMemberPermission(MemberOrder memberOrder) {
        String elsAccount;
        Member member;
        if (!MealTypeEnum.MEMBER_UPGRADE_RENEWAL.getCode().equals(memberOrder.getMealType())) {
            return;
        }
        String mealId = memberOrder.getMealId();
        if (!mealId.equals((member = this.memberService.getByElsAccount(elsAccount = memberOrder.getToElsAccount())).getMemberMealId())) {
            MemberMeal meal = (MemberMeal)((Object)this.memberMealService.getById((Serializable)((Object)memberOrder.getMealId())));
            Role role = (Role)this.roleService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Role::getElsAccount, (Object)elsAccount)).eq(Role::getRoleCode, (Object)"companyAdmin"));
            if (ObjectUtil.isNotEmpty((Object)role) && StrUtil.isNotBlank((CharSequence)role.getId())) {
                TenantContext.setTenant((String)elsAccount);
                this.memberService.deleteMemberPermission(elsAccount, role.getId());
                this.memberService.autoSetPermission(elsAccount, meal.getRuleCode(), memberOrder.getCreateBy(), memberOrder.getUpdateBy(), role.getId());
            }
            this.mcnTenantParamConfigService.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount));
            List<McnTenantParamConfig> tenantParamConfigs = this.mcnTenantParamConfigService.getControlConfig(elsAccount, meal.getMemberLev());
            if (CollUtil.isNotEmpty(tenantParamConfigs)) {
                this.mcnTenantParamConfigService.saveBatch(tenantParamConfigs);
            }
            member.setMemberLv(meal.getMemberLev());
            member.setMemberMealId(meal.getId());
            member.setExpireTime((Date)DateUtil.offsetMonth((Date)new Date(), (int)12));
            this.memberService.updateById((Object)member);
            ElsTenant elsTenant = (ElsTenant)this.elsTenantService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(BaseEntity::getDeleted, (Object)"0"), false);
            if (ObjectUtil.isNotEmpty((Object)elsTenant)) {
                elsTenant.setExpiryDate((Date)DateUtil.offsetMonth((Date)new Date(), (int)12));
                this.elsTenantService.updateById((Object)elsTenant);
            }
        }
    }
}

