/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sms.api.service.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.message.config.SmsConfig;
import com.els.modules.message.handle.SmsMsgService;
import com.els.modules.message.util.DySmsEnum;
import com.els.modules.message.util.DySmsHelper;
import com.els.modules.message.vo.SmsMsgVO;
import com.els.modules.sms.api.dto.SmsDto;
import com.els.modules.sms.api.dto.SmsMsgDTO;
import com.els.modules.sms.api.dto.SmsResult;
import com.els.modules.sms.api.service.SmsRpcService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsBeanServiceImpl
implements SmsRpcService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmsConfig smsConfig;
    @Resource
    private SmsMsgService smsMsgService;

    public SmsResult sendSms(SmsDto dto) {
        SmsResult result = new SmsResult();
        String mobile = dto.getMobile();
        String smsmode = dto.getSmsmode();
        Object object = this.redisUtil.get(mobile);
        if (object != null) {
            result.setMessage("\u9a8c\u8bc1\u780110\u5206\u949f\u5185\uff0c\u4ecd\u7136\u6709\u6548\uff01");
            result.setSuccess(false);
            return result;
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)captcha);
        try {
            boolean b = false;
            if ("1".equals(smsmode)) {
                b = DySmsHelper.sendTemplateSms((String)mobile, (JSONObject)obj, (String)this.smsConfig.getSignName(), (String)this.smsConfig.getVerificationTemplateCode());
            } else if ("0".equals(smsmode)) {
                b = DySmsHelper.sendSms((String)mobile, (JSONObject)obj, (DySmsEnum)DySmsEnum.LOGIN_TEMPLATE_CODE);
            } else if ("2".equals(smsmode)) {
                b = DySmsHelper.sendSms((String)mobile, (JSONObject)obj, (DySmsEnum)DySmsEnum.FORGET_PASSWORD_TEMPLATE_CODE);
            }
            if (!b) {
                result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                result.setSuccess(false);
                return result;
            }
            this.redisUtil.set(mobile, (Object)captcha, 600L);
            result.setSuccess(true);
            result.setMessage("\u53d1\u9001\u6210\u529f");
        }
        catch (ClientException e) {
            result.setMessage(" \u77ed\u4fe1\u63a5\u53e3\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            result.setSuccess(false);
            return result;
        }
        return result;
    }

    public void sendSMS(SmsMsgDTO msgDTO) {
        SmsMsgVO msgVO = (SmsMsgVO)SysUtil.copyProperties((Object)msgDTO, SmsMsgVO.class);
        this.smsMsgService.sendSms(msgVO);
    }
}

