/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sms.api.service.impl;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.modules.message.config.SmsConfig;
import com.els.modules.message.handle.SmsMsgService;
import com.els.modules.message.vo.SmsMsgVO;
import com.els.modules.sms.api.dto.SmsDto;
import com.els.modules.sms.api.dto.SmsMsgDTO;
import com.els.modules.sms.api.dto.SmsResult;
import com.els.modules.sms.api.service.SmsRpcService;
import com.els.modules.supplier.api.dto.SupplierInvitationCodeDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsBeanServiceImpl
implements SmsRpcService {
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");
    private static final Pattern CHINA_PATTERN = Pattern.compile("^((13[0-9])|(14[0,1,4-9])|(15[0-3,5-9])|(16[2,5,6,7])|(17[0-8])|(18[0-9])|(19[0-3,5-9]))\\d{8}$");
    private static final String SUCCESS = "200";
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmsConfig smsConfig;
    @Resource
    private SmsMsgService smsMsgService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public SmsResult sendSms(SmsDto dto) {
        SmsResult result = new SmsResult();
        String mobile = dto.getMobile();
        String smsmode = dto.getSmsmode();
        Object object = this.redisUtil.get("sys:sms:captcha:" + mobile);
        if (object != null) {
            result.setMessage("\u9a8c\u8bc1\u780110\u5206\u949f\u5185\uff0c\u4ecd\u7136\u6709\u6548\uff01");
            result.setSuccess(false);
            return result;
        }
        String captcha = StrUtil.isEmpty((CharSequence)dto.getCaptcha()) ? RandomUtil.randomNumbers((int)6) : dto.getCaptcha();
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)captcha);
        boolean matches = CHINA_PATTERN.matcher(mobile).matches();
        String srmCode = "sms-verification-code";
        if (matches || StringUtils.isBlank((CharSequence)dto.getSourceType())) {
            srmCode = "sms-verification-code";
        } else {
            if ("1".equals(smsmode)) {
                srmCode = "international-sms-verification-code";
            }
            if ("2".equals(smsmode)) {
                srmCode = "international-resetppassword-sms-verification-code";
            }
        }
        JSONObject requestJSON = new JSONObject();
        JSONObject content = new JSONObject();
        content.put("code", (Object)captcha);
        requestJSON.put("phone", (Object)mobile);
        requestJSON.put("currentAccount", (Object)(StringUtils.isNotBlank((CharSequence)this.configMap.get("elsAccount")) ? this.configMap.get("elsAccount") : "100000"));
        if ("1".equals(dto.getSourceType())) {
            if (StringUtils.isBlank((CharSequence)dto.getInvitationCode())) {
                result.setMessage("\u9080\u8bf7\u7801\u4e3a\u7a7a");
                result.setSuccess(false);
                return result;
            }
            SupplierInvitationCodeDTO supplierInvitationCodeDTO = this.invokeBaseRpcService.getSupplierInvitationCodeInfoByCode(dto.getInvitationCode());
            if (supplierInvitationCodeDTO == null || StringUtils.isBlank((CharSequence)supplierInvitationCodeDTO.getElsAccount())) {
                result.setMessage("\u9080\u8bf7\u7801\u4e0d\u5b58\u5728\uff01");
                result.setSuccess(false);
                return result;
            }
            requestJSON.put("currentAccount", (Object)supplierInvitationCodeDTO.getElsAccount());
        }
        requestJSON.put("content", (Object)content);
        JSONObject resObject = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode(srmCode));
        if (SUCCESS.equals(resObject.getString("code"))) {
            JSONObject jsonObject = JSONObject.parseObject((String)resObject.getString("data"));
            if (jsonObject.isEmpty() || !jsonObject.containsKey((Object)"status") || !jsonObject.getBoolean("status").booleanValue()) {
                result.setMessage(jsonObject.getString("msg"));
                result.setSuccess(false);
                return result;
            }
        } else {
            result.setMessage("ipass\u63a5\u53e3\u8fd4\u56de\uff1a" + resObject.getString("message"));
            result.setSuccess(false);
            return result;
        }
        this.redisUtil.set("sys:sms:captcha:" + mobile, (Object)captcha, 600L);
        result.setSuccess(true);
        result.setMessage("\u53d1\u9001\u6210\u529f");
        return result;
    }

    public void sendSMS(SmsMsgDTO msgDTO) {
        SmsMsgVO msgVO = (SmsMsgVO)SysUtil.copyProperties((Object)msgDTO, SmsMsgVO.class);
        this.smsMsgService.sendSms(msgVO);
    }
}

