/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.notice.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.BaseDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.notice.entity.SaleNotice;
import com.els.modules.notice.mapper.SaleNoticeMapper;
import com.els.modules.notice.service.SaleNoticeService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SaleNoticeServiceImpl
extends ServiceImpl<SaleNoticeMapper, SaleNotice>
implements SaleNoticeService {
    @Resource
    private SaleNoticeMapper saleNoticeMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleNotice saleNotice, List<SaleAttachmentDTO> saleAttachmentList) {
        this.saleNoticeMapper.insert((Object)saleNotice);
        this.insertData(saleNotice, saleAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleNotice saleNotice, List<SaleAttachmentDTO> saleAttachmentList) {
        this.saleNoticeMapper.updateById((Object)saleNotice);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(saleNotice.getId());
        this.insertData(saleNotice, saleAttachmentList);
    }

    private void insertData(SaleNotice saleNotice, List<SaleAttachmentDTO> saleAttachmentList) {
        for (SaleAttachmentDTO entity : saleAttachmentList) {
            entity.setHeadId(saleNotice.getId());
            SysUtil.setSysParam((BaseDTO)entity, (BaseEntity)saleNotice);
        }
        if (!saleAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        this.saleNoticeMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invokeBaseRpcService.deleteSaleAttachmentByMainId(serializable.toString());
            this.saleNoticeMapper.deleteById(serializable);
        }
    }
}

