/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.message.handle.SmsMsgService;
import com.els.modules.message.handle.enums.SmsSendTemplateTypeEnum;
import com.els.modules.message.util.DySmsEnum;
import com.els.modules.message.util.DySmsHelper;
import com.els.modules.message.vo.SmsMsgVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SmsMsgServiceImpl
implements SmsMsgService {
    @Override
    public void sendSms(SmsMsgVO msgVO) {
        ElsSubAccountDTO account = msgVO.getAccount();
        if (StringUtils.isNotBlank((CharSequence)msgVO.getType()) && account != null && StringUtils.isNotBlank((CharSequence)account.getPhone())) {
            this.send(msgVO, account);
        }
    }

    public void send(SmsMsgVO msgVO, ElsSubAccountDTO account) {
        if (!"1".equals(msgVO.getIsDefault())) {
            JSONObject obj = msgVO.getObject();
            try {
                DySmsHelper.sendTemplateSms(account.getPhone(), obj, msgVO.getSmsTitle(), msgVO.getSmsCode());
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
        } else {
            JSONObject obj = new JSONObject();
            obj.put("sendCompany", (Object)msgVO.getSendCompany());
            obj.put("receiveCompany", (Object)msgVO.getReceiveCompany());
            try {
                if (SmsSendTemplateTypeEnum.CHAT.getValue().equals(msgVO.getType()) || SmsSendTemplateTypeEnum.ORDER.getValue().equals(msgVO.getType())) {
                    DySmsHelper.sendSms(account.getPhone(), obj, DySmsEnum.CHAT_OR_ORDER_CODE);
                }
                if (SmsSendTemplateTypeEnum.SUPPLIER.getValue().equals(msgVO.getType())) {
                    DySmsHelper.sendSms(account.getPhone(), obj, DySmsEnum.SUPPLIER_CODE);
                }
                if (SmsSendTemplateTypeEnum.INQUIRY.getValue().equals(msgVO.getType())) {
                    DySmsHelper.sendSms(account.getPhone(), obj, DySmsEnum.INQUIRY_CODE);
                }
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
        }
    }
}

