/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.mapper.ElsMsgConfigHeadMapper;
import com.els.modules.message.mapper.ElsMsgConfigItemMapper;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ElsMsgConfigHeadServiceImpl
extends ServiceImpl<ElsMsgConfigHeadMapper, ElsMsgConfigHead>
implements ElsMsgConfigHeadService {
    @Resource
    private ElsMsgConfigHeadMapper elsMsgConfigHeadMapper;
    @Resource
    private ElsMsgConfigItemMapper elsMsgConfigItemMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        this.elsMsgConfigHeadMapper.insert((Object)elsMsgConfigHead);
        this.insertData(elsMsgConfigHead, elsMsgConfigItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        this.elsMsgConfigHeadMapper.updateById((Object)elsMsgConfigHead);
        this.elsMsgConfigItemMapper.deleteByMainId(elsMsgConfigHead.getId());
        this.insertData(elsMsgConfigHead, elsMsgConfigItemList);
    }

    private void insertData(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        for (ElsMsgConfigItem entity : elsMsgConfigItemList) {
            entity.setHeadId(elsMsgConfigHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsMsgConfigHead);
        }
        if (!elsMsgConfigItemList.isEmpty()) {
            this.elsMsgConfigItemMapper.insertBatchSomeColumn(elsMsgConfigItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsMsgConfigItemMapper.deleteByMainId(id);
        this.elsMsgConfigHeadMapper.PhysicalDeleteById(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsMsgConfigItemMapper.deleteByMainId(serializable.toString());
            this.elsMsgConfigHeadMapper.deleteById(serializable);
        }
    }
}

