/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.MailConfig;
import com.els.config.StaticConfig;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(EmailSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        ElsSubAccountDTO account = msg.getReceiveAccount();
        ElsMsgConfigItem item = msg.getElsMsgConfigItem();
        JavaMailSender mailSender = (JavaMailSender)SpringContextUtils.getBean((String)"mailSender");
        MimeMessage message = mailSender.createMimeMessage();
        log.error("\u5f00\u59cb\u5411:" + account.getEmail() + "\u53d1\u9001\u90ae\u4ef6");
        try {
            if (StrUtil.isEmpty((CharSequence)account.getEmail())) {
                log.error("::: \u6d88\u606f\u63a5\u6536\u65b9\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\uff0c\u65e0\u6cd5\u63a5\u6536\u90ae\u7bb1\u6d88\u606f,");
                return;
            }
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(((MailConfig)SpringContextUtils.getBean(MailConfig.class)).getUsername());
            helper.setTo(account.getEmail());
            if (!"exception".equals(item.getMsgType())) {
                String ccEmail = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("ccEmail");
                if (StrUtil.isNotBlank((CharSequence)ccEmail)) {
                    helper.setCc(ccEmail);
                } else {
                    helper.setCc(((MailConfig)SpringContextUtils.getBean(MailConfig.class)).getUsername());
                }
            }
            helper.setSubject(item.getMsgTitle());
            String msgContent = item.getMsgContent();
            if (StrUtil.isNotBlank((CharSequence)msgContent)) {
                if (msg.getParams() != null) {
                    JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                    if (StrUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                        object.put("audthUrl", (Object)this.getAuthUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), account));
                    }
                    msgContent = TemplateParseUtil.getTemplateText("", msgContent, (Map<String, Object>)object);
                }
                helper.setText(msgContent, true);
            }
            mailSender.send(message);
        }
        catch (MessagingException e) {
            log.error(e.getMessage());
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6d88\u606f\u7ec4\u4ef6\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
    }

    private String getAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword()));
        return url.toString();
    }

    public static void main(String[] args) {
        String url = "/srm/bidding/sale/SaleBiddingHeadList?templateNumber=TC2021051401&templateVersion=1&id=1404452506648141826&busAccount=307000";
        System.out.println(URLUtil.encodeAll((String)url));
    }
}

