/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.mapper.ElsMsgConfigHeadMapper;
import com.els.modules.message.mapper.ElsMsgConfigItemMapper;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ElsMsgConfigHeadServiceImpl
extends ServiceImpl<ElsMsgConfigHeadMapper, ElsMsgConfigHead>
implements ElsMsgConfigHeadService {
    @Resource
    private ElsMsgConfigHeadMapper elsMsgConfigHeadMapper;
    @Resource
    private ElsMsgConfigItemMapper elsMsgConfigItemMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        this.elsMsgConfigHeadMapper.insert((Object)elsMsgConfigHead);
        this.insertData(elsMsgConfigHead, elsMsgConfigItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        this.elsMsgConfigHeadMapper.updateById((Object)elsMsgConfigHead);
        this.elsMsgConfigItemMapper.deleteByMainId(elsMsgConfigHead.getId());
        this.insertData(elsMsgConfigHead, elsMsgConfigItemList);
    }

    private void insertData(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        for (ElsMsgConfigItem entity : elsMsgConfigItemList) {
            entity.setHeadId(elsMsgConfigHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsMsgConfigHead);
        }
        if (!elsMsgConfigItemList.isEmpty()) {
            this.elsMsgConfigItemMapper.insertBatchSomeColumn(elsMsgConfigItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsMsgConfigItemMapper.deleteByMainId(id);
        this.elsMsgConfigHeadMapper.PhysicalDeleteById(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsMsgConfigItemMapper.deleteByMainId(serializable.toString());
            this.elsMsgConfigHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addToEnterprise(String id) {
        List heads;
        ElsMsgConfigHead elsMsgConfigHead = (ElsMsgConfigHead)((Object)this.elsMsgConfigHeadMapper.selectById((Serializable)((Object)id)));
        List<ElsMsgConfigItem> items = this.elsMsgConfigItemMapper.selectByMainId(id);
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        String elsAccount = TenantContext.getTenant();
        String businessType = elsMsgConfigHead.getBusinessType();
        String operateType = elsMsgConfigHead.getOperateType();
        String jobFunction = elsMsgConfigHead.getJobFunction();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"business_type", (Object)businessType);
        if (StringUtils.isBlank((CharSequence)operateType)) {
            queryWrapper.eq((Object)"operate_type", (Object)operateType);
        }
        if (StringUtils.isBlank((CharSequence)jobFunction)) {
            queryWrapper.eq((Object)"job_function", (Object)jobFunction);
        }
        if (!(heads = this.elsMsgConfigHeadMapper.selectList((Wrapper)queryWrapper)).isEmpty()) {
            String oldId = ((ElsMsgConfigHead)((Object)heads.get(0))).getId();
            this.delMain(oldId);
        }
        elsMsgConfigHead.setId(null);
        elsMsgConfigHead.setElsAccount(elsAccount);
        elsMsgConfigHead.setCreateBy(subAccount);
        elsMsgConfigHead.setUpdateBy(subAccount);
        elsMsgConfigHead.setCreateTime(new Date());
        elsMsgConfigHead.setUpdateTime(new Date());
        this.elsMsgConfigHeadMapper.insert((Object)elsMsgConfigHead);
        for (ElsMsgConfigItem item : items) {
            item.setId(null);
            item.setHeadId(elsMsgConfigHead.getId());
            item.setElsAccount(elsAccount);
            item.setCreateBy(subAccount);
            item.setUpdateBy(subAccount);
            item.setCreateTime(new Date());
            item.setUpdateTime(new Date());
        }
        if (!items.isEmpty()) {
            this.elsMsgConfigItemMapper.insertBatchSomeColumn(items);
        }
    }
}

