/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.entity.ElsMsgRecord;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.service.ElsMsgRecordService;
import com.els.modules.message.service.impl.ElsMsgRecordServiceImpl;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstationMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(InstationMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        try {
            ElsMsgConfigItem item = msg.getElsMsgConfigItem();
            ElsSubAccountDTO account = msg.getReceiveAccount();
            ElsSubAccountDTO sendAccount = msg.getSendAccount();
            ElsMsgRecord record = new ElsMsgRecord();
            if (StrUtil.isEmpty((CharSequence)account.getId())) {
                return;
            }
            record.setBusinessType(msg.getBusinessType());
            record.setOperateType(msg.getOperateType());
            record.setElsAccount(account.getElsAccount());
            record.setSubAccount(account.getSubAccount());
            record.setReceiverId(account.getId());
            record.setReceiverName(account.getRealname());
            record.setSendElsAccount(sendAccount.getElsAccount());
            record.setSendSubAccount(sendAccount.getSubAccount());
            record.setSendId(sendAccount.getId());
            record.setSendName(sendAccount.getRealname());
            record.setMsgTitle(item.getMsgTitle());
            record.setSendTime(new Date());
            record.setCreateBy(sendAccount.getRealname());
            record.setCreateTime(new Date());
            record.setHandleFlag("0");
            String msgContent = item.getMsgContent();
            if (StrUtil.isNotBlank((CharSequence)msgContent)) {
                if (msg.getParams() != null) {
                    HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                    BeanUtil.copyProperties((Object)msg.getParams(), paramsMap, (String[])new String[0]);
                    msgContent = TemplateParseUtil.getTemplateText("", msgContent, paramsMap);
                }
                record.setMsgContent(msgContent);
            }
            if (StrUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                record.setLinkUrl(item.getLinkUrl().trim() + "?" + msg.getUrlParam());
            }
            ElsMsgRecordService msgRecordService = (ElsMsgRecordService)SpringContextUtils.getBean(ElsMsgRecordServiceImpl.class);
            msgRecordService.save((Object)record);
        }
        catch (Exception e) {
            log.error("InstationMsgImpl_doSendMsg_failed:", (Throwable)e);
        }
    }
}

