/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.JustAuthConfigDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.rpc.service.MessageInvokeAccountService;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingtalkSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(DingtalkSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("enter into DingtalkSendMsgImpl.doSendMsg");
        try {
            ElsMsgConfigItem item = msg.getElsMsgConfigItem();
            ElsSubAccountDTO account = msg.getReceiveAccount();
            MessageInvokeAccountService thirdAccountService = (MessageInvokeAccountService)SpringContextUtils.getBean(MessageInvokeAccountService.class);
            List<ThirdAccountDTO> list = thirdAccountService.getThirdAccount(account.getId(), "DINGTALK");
            if (list.isEmpty()) {
                log.error("receive not bind DINGTALK");
                return;
            }
            JustAuthConfigDTO config = this.getJustConfig(msg.getBusAccount(), "DINGTALK");
            if (StrUtil.isEmpty((CharSequence)config.getClientId())) {
                log.error("::: JustAuthConfig \u914d\u7f6e\u4e0d\u5b58\u5728");
                return;
            }
            String token = ThirdTokenUtil.getDingtalkToken((String)msg.getBusAccount(), (JustAuthConfigDTO)config);
            StringBuilder users = new StringBuilder();
            for (ThirdAccountDTO dto : list) {
                String unionId = dto.getThirdUserUuid();
                String userId = this.getUserIdByUnionId(unionId, token);
                if (!StrUtil.isNotBlank((CharSequence)userId)) continue;
                if (users.length() == 0) {
                    users.append(userId);
                    continue;
                }
                users.append(",").append(userId);
            }
            log.info("dingtalk_receive:" + users);
            String urlString = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2?access_token=" + token;
            JSONObject body = new JSONObject();
            body.put("agent_id", (Object)config.getAgentId());
            body.put("userid_list", (Object)users.toString());
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgtype", (Object)"action_card");
            JSONObject actionCard = new JSONObject();
            actionCard.put("title", (Object)item.getMsgTitle());
            actionCard.put("single_url", (Object)this.getUrl(item.getLinkUrl() + this.getConcat(item.getLinkUrl()) + msg.getUrlParam(), msg.getBusAccount()));
            actionCard.put("single_title", (Object)"\u8be6\u60c5");
            if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
                JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                String msgContent = TemplateParseUtil.getTemplateText("", item.getMsgContent(), (Map<String, Object>)object);
                String time = DateUtils.date2Str((Date)new Date(), (SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
                msgContent = msgContent + "<!--" + time + "-->";
                actionCard.put("markdown", (Object)msgContent);
            }
            msgObj.put("action_card", (Object)actionCard);
            body.put("msg", (Object)msgObj);
            log.info(":::DingtalkSendMsgImpl msgBody:{}", (Object)body.toString());
            String result = HttpUtil.post((String)urlString, (String)body.toString());
            log.info(":::DingtalkSendMsgImpl send message result:{}", (Object)result);
        }
        catch (Exception e) {
            log.error("DingtalkSendMsgImpl.doSendMsg failed:", (Throwable)e);
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/account/thirdLogin/render/%s/mobile/dingtalk_account";
    }

    private String getUserIdByUnionId(String unionId, String token) {
        String result = HttpUtil.post((String)("https://oapi.dingtalk.com/topapi/user/getbyunionid?access_token=" + token), (String)("{\"unionid\":\"" + unionId + "\"}"));
        JSONObject resultObj = JSONObject.parseObject((String)result);
        if (resultObj.containsKey((Object)"result")) {
            JSONObject obj = resultObj.getJSONObject("result");
            return obj.getString("userid");
        }
        return null;
    }
}

