/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.JustAuthConfigDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.rpc.service.MessageInvokeAccountService;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeiShuSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(FeiShuSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("enter into FeiShuSendMsgImpl.doSendMsg");
        try {
            ElsMsgConfigItem item = msg.getElsMsgConfigItem();
            ElsSubAccountDTO account = msg.getReceiveAccount();
            MessageInvokeAccountService thirdAccountService = (MessageInvokeAccountService)SpringContextUtils.getBean(MessageInvokeAccountService.class);
            List<ThirdAccountDTO> list = thirdAccountService.getThirdAccount(account.getId(), "feishu");
            if (list.isEmpty()) {
                log.error("receive not bind feishu");
                return;
            }
            JustAuthConfigDTO config = this.getJustConfig(msg.getBusAccount(), "FEISHU");
            if (StrUtil.isEmpty((CharSequence)config.getClientId())) {
                log.error("::: JustAuthConfig \u914d\u7f6e\u4e0d\u5b58\u5728");
                return;
            }
            String access_token = ThirdTokenUtil.getFeiShuToken((String)msg.getBusAccount(), (JustAuthConfigDTO)config);
            String titleCont = StringUtils.isNotBlank((CharSequence)item.getMsgTitle()) ? item.getMsgTitle() : "\u672a\u547d\u540d";
            String bodyCont = "";
            String detailUrl = this.getUrl(item.getLinkUrl() + this.getConcat(item.getLinkUrl()) + msg.getUrlParam(), msg.getBusAccount());
            String receiveId = "";
            if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
                JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                bodyCont = TemplateParseUtil.getTemplateText("", item.getMsgContent(), (Map<String, Object>)object);
            }
            JSONObject bodyJson = FeiShuSendMsgImpl.getFeiShuSmsObj(titleCont, bodyCont, detailUrl, receiveId);
            for (ThirdAccountDTO thirdAccount : list) {
                receiveId = thirdAccount.getThirdUserUuid();
                bodyJson.put("receive_id", (Object)receiveId);
                log.info(":::FeiShuSendMsgImpl msgBody:{}", (Object)bodyJson.toString());
                String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)"https://open.feishu.cn/open-apis/im/v1/messages?receive_id_type=union_id").header("Authorization", "Bearer " + access_token)).header("content-type", "application/json; charset=utf-8")).body(bodyJson.toJSONString()).execute().body();
                log.info(":::FeiShuSendMsgImpl send message result:{}", (Object)result);
            }
        }
        catch (Exception e) {
            log.error("FeiShuSendMsgImpl.doSendMsg failed:", (Throwable)e);
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/account/thirdLogin/render/%s/mobile/custom_feishu";
    }

    private static JSONObject getFeiShuSmsObj(String titleCont, String bodyCont, String detailUrl, String receiveId) {
        JSONObject json = new JSONObject();
        json.put("msg_type", (Object)"interactive");
        JSONObject content = new JSONObject();
        JSONObject config = new JSONObject();
        config.put("wide_screen_mode", (Object)true);
        JSONObject header = new JSONObject();
        HashMap<String, String> title = new HashMap<String, String>();
        title.put("tag", "plain_text");
        title.put("content", titleCont);
        header.put("template", (Object)"blue");
        header.put("title", title);
        ArrayList elements = new ArrayList();
        HashMap<String, Object> elementOne = new HashMap<String, Object>();
        HashMap<String, String> textOne = new HashMap<String, String>();
        textOne.put("content", bodyCont + "\n[\u8be6\u60c5](" + detailUrl + ")");
        textOne.put("tag", "lark_md");
        elementOne.put("tag", "div");
        elementOne.put("text", textOne);
        elements.add(elementOne);
        content.put("config", (Object)config);
        content.put("header", (Object)header);
        content.put("elements", elements);
        json.put("content", (Object)content.toJSONString());
        json.put("receive_id", (Object)receiveId);
        return json;
    }

    public static void main(String[] args) {
        JSONObject jsonObject = FeiShuSendMsgImpl.getFeiShuSmsObj("\u91c7\u8d2d\u901a\u77e5\u5355", "\u7269\u6599A-002\u5b58\u5728\u4e0d\u5408\u683c\u7684\u68c0\u6d4b\uff0c\u8bf7\u8d1f\u8d23\u4eba\u91cd\u65b0\u5b89\u6392\u4eba\u5458\u53bb\u5904\u7406\u8fd9\u4ef6\u4e8b\u3002", "https://www.feishu.cn", "on_af43c1dc2226c2c9e88deb604ff69980");
        String result = ((HttpRequest)((HttpRequest)HttpRequest.post((String)"https://open.feishu.cn/open-apis/im/v1/messages?receive_id_type=union_id").header("Authorization", "Bearer t-5ab1f6d33e6f1b3dc9b5db757a7ee091704315a7")).header("content-type", "application/json; charset=utf-8")).body(jsonObject.toJSONString()).execute().body();
        System.out.println(result);
    }
}

