/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.log.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.modules.log.entity.ElsLogStatistics;
import com.els.modules.log.mapper.ElsLogStatisticsMapper;
import com.els.modules.log.mapper.LogMapper;
import com.els.modules.log.service.ElsLogStatisticsService;
import com.els.modules.log.vo.LogVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsLogStatisticsServiceImpl
extends ServiceImpl<ElsLogStatisticsMapper, ElsLogStatistics>
implements ElsLogStatisticsService {
    @Autowired
    private LogMapper logMapper;

    @Override
    public void saveElsLogStatistics(ElsLogStatistics elsLogStatistics) {
        ((ElsLogStatisticsMapper)this.baseMapper).insert((Object)elsLogStatistics);
    }

    @Override
    public void updateElsLogStatistics(ElsLogStatistics elsLogStatistics) {
        ((ElsLogStatisticsMapper)this.baseMapper).updateById((Object)elsLogStatistics);
    }

    @Override
    public void delElsLogStatistics(String id) {
        ((ElsLogStatisticsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsLogStatistics(List<String> idList) {
        ((ElsLogStatisticsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction
    public void refreshLog() {
        String logMonth = DateUtil.format((Date)new Date(), (String)"yyyy-MM");
        ((ElsLogStatisticsMapper)this.baseMapper).deleteByLogMonth(logMonth);
        ArrayList<ElsLogStatistics> insertList = new ArrayList<ElsLogStatistics>();
        LogVO logVO = new LogVO();
        logVO.setLogMonth(logMonth);
        List<LogVO> sysList = this.logMapper.findSysStatisticsList(logVO);
        for (LogVO vo : sysList) {
            ElsLogStatistics statistics = new ElsLogStatistics();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)statistics));
            statistics.setElsAccount("100000");
            insertList.add(statistics);
        }
        List<LogVO> CompanyList = this.logMapper.findCompanyStatisticsList(logVO);
        for (LogVO vo : CompanyList) {
            ElsLogStatistics statistics = new ElsLogStatistics();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)statistics));
            insertList.add(statistics);
        }
        this.saveBatch(insertList, 200);
    }
}

