/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.survey.service.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.extra.qrcode.QrCodeUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.notice.api.enumerate.NoticeScopeEnum;
import com.els.modules.notice.entity.PurchaseNotice;
import com.els.modules.notice.service.PurchaseNoticeService;
import com.els.modules.survey.entity.PurchaseSurveyAnswer;
import com.els.modules.survey.entity.PurchaseSurveyAnswerLibrary;
import com.els.modules.survey.entity.PurchaseSurveyAnswerOption;
import com.els.modules.survey.entity.PurchaseSurveyHead;
import com.els.modules.survey.entity.PurchaseSurveyItem;
import com.els.modules.survey.entity.PurchaseSurveyLibrary;
import com.els.modules.survey.entity.PurchaseSurveyOption;
import com.els.modules.survey.enumerate.ServeyItemStatusEnum;
import com.els.modules.survey.enumerate.ServeyScopeEnum;
import com.els.modules.survey.enumerate.ServeyStatusEnum;
import com.els.modules.survey.mapper.PurchaseSurveyAnswerLibraryMapper;
import com.els.modules.survey.mapper.PurchaseSurveyAnswerMapper;
import com.els.modules.survey.mapper.PurchaseSurveyAnswerOptionMapper;
import com.els.modules.survey.mapper.PurchaseSurveyHeadMapper;
import com.els.modules.survey.mapper.PurchaseSurveyItemMapper;
import com.els.modules.survey.mapper.PurchaseSurveyLibraryMapper;
import com.els.modules.survey.mapper.PurchaseSurveyOptionMapper;
import com.els.modules.survey.service.PurchaseSurveyAnswerLibraryService;
import com.els.modules.survey.service.PurchaseSurveyAnswerOptionService;
import com.els.modules.survey.service.PurchaseSurveyAnswerService;
import com.els.modules.survey.service.PurchaseSurveyHeadService;
import com.els.modules.survey.service.PurchaseSurveyItemService;
import com.els.modules.survey.service.PurchaseSurveyLibraryService;
import com.els.modules.survey.service.PurchaseSurveyOptionService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseSurveyHeadServiceImpl
extends BaseServiceImpl<PurchaseSurveyHeadMapper, PurchaseSurveyHead>
implements PurchaseSurveyHeadService {
    @Resource
    private PurchaseSurveyHeadMapper purchaseSurveyHeadMapper;
    @Resource
    private PurchaseSurveyLibraryMapper purchaseSurveyLibraryMapper;
    @Resource
    private PurchaseSurveyOptionMapper purchaseSurveyOptionMapper;
    @Resource
    private PurchaseSurveyItemMapper purchaseSurveyItemMapper;
    @Resource
    private PurchaseSurveyAnswerMapper purchaseSurveyAnswerMapper;
    @Resource
    private PurchaseSurveyAnswerLibraryMapper purchaseSurveyAnswerLibraryMapper;
    @Resource
    private PurchaseSurveyAnswerOptionMapper purchaseSurveyAnswerOptionMapper;
    @Resource
    private PurchaseSurveyLibraryService purchaseSurveyLibraryService;
    @Resource
    private PurchaseSurveyOptionService purchaseSurveyOptionService;
    @Resource
    private PurchaseSurveyItemService purchaseSurveyItemService;
    @Resource
    private PurchaseSurveyAnswerService purchaseSurveyAnswerService;
    @Resource
    private PurchaseSurveyAnswerLibraryService purchaseSurveyAnswerLibraryService;
    @Resource
    private PurchaseSurveyAnswerOptionService purchaseSurveyAnswerOptionService;
    @Resource
    private PurchaseNoticeService purchaseNoticeRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private AccountRpcService accountRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyLibrary> purchaseSurveyLibraryList, List<PurchaseSurveyItem> purchaseSurveyItemList, List<PurchaseSurveyAnswer> purchaseSurveyAnswerList) {
        if (StringUtils.isBlank((CharSequence)purchaseSurveyHead.getSurveyNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSurveyNumber", (Object)purchaseSurveyHead);
            purchaseSurveyHead.setSurveyNumber(nextCode);
            LoginUser loginUser = SysUtil.getLoginUser();
            purchaseSurveyHead.setPurchaseName(loginUser.getEnterpriseName());
        }
        if ("1".equals(purchaseSurveyHead.getAudit())) {
            purchaseSurveyHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSurveyHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        purchaseSurveyHead.setSurveyStatus("0");
        this.purchaseSurveyHeadMapper.insert((Object)purchaseSurveyHead);
        if (purchaseSurveyHead.getSurveyScope().equals("inside")) {
            this.insertUsers(purchaseSurveyHead, purchaseSurveyAnswerList);
        }
        this.insertData(purchaseSurveyHead, purchaseSurveyLibraryList, purchaseSurveyItemList, purchaseSurveyAnswerList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyLibrary> purchaseSurveyLibraryList, List<PurchaseSurveyItem> purchaseSurveyItemList, List<PurchaseSurveyAnswer> purchaseSurveyAnswerList) {
        List<PurchaseSurveyLibrary> libraries;
        if (StringUtils.isBlank((CharSequence)purchaseSurveyHead.getSurveyNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSurveyNumber", (Object)purchaseSurveyHead);
            purchaseSurveyHead.setSurveyNumber(nextCode);
            LoginUser loginUser = SysUtil.getLoginUser();
            purchaseSurveyHead.setPurchaseName(loginUser.getEnterpriseName());
        }
        if ("1".equals(purchaseSurveyHead.getAudit())) {
            purchaseSurveyHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSurveyHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseSurveyHeadMapper.updateById((Object)purchaseSurveyHead);
        this.log.error("\u66f4\u65b0\u83b7\u53d6SurveyheadId:" + purchaseSurveyHead.getId());
        if (!CollectionUtils.isEmpty(purchaseSurveyLibraryList) && StringUtils.isNotBlank((CharSequence)purchaseSurveyHead.getId()) && (libraries = this.purchaseSurveyLibraryMapper.selectByMainId(purchaseSurveyHead.getId())).size() > 0) {
            ArrayList<String> ids = new ArrayList<String>();
            libraries.forEach(library -> ids.add(library.getId()));
            this.purchaseSurveyOptionMapper.deleteByMainIds(ids);
            this.purchaseSurveyLibraryMapper.deleteByMainId(purchaseSurveyHead.getId());
        }
        if ("0".equals(purchaseSurveyHead.getSurveyStatus()) && StringUtils.isNotBlank((CharSequence)purchaseSurveyHead.getId())) {
            this.purchaseSurveyAnswerMapper.deleteByMainId(purchaseSurveyHead.getId());
        }
        this.purchaseSurveyItemMapper.deleteByMainId(purchaseSurveyHead.getId());
        if (StringUtils.isNotBlank((CharSequence)purchaseSurveyHead.getSurveyScope()) && purchaseSurveyHead.getSurveyScope().equals("inside")) {
            this.insertUsers(purchaseSurveyHead, purchaseSurveyAnswerList);
        }
        this.insertData(purchaseSurveyHead, purchaseSurveyLibraryList, purchaseSurveyItemList, purchaseSurveyAnswerList);
    }

    private void insertData(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyLibrary> purchaseSurveyLibraryList, List<PurchaseSurveyItem> purchaseSurveyItemList, List<PurchaseSurveyAnswer> purchaseSurveyAnswerList) {
        if (!CollectionUtils.isEmpty(purchaseSurveyLibraryList)) {
            for (PurchaseSurveyLibrary purchaseSurveyLibrary : purchaseSurveyLibraryList) {
                purchaseSurveyLibrary.setHeadId(purchaseSurveyHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseSurveyLibrary, (BaseEntity)purchaseSurveyHead);
                purchaseSurveyLibrary.setId(IdWorker.getIdStr());
                purchaseSurveyLibrary.setElsAccount(purchaseSurveyHead.getElsAccount());
                List<PurchaseSurveyOption> purchaseSurveyOptionList = purchaseSurveyLibrary.getPurchaseSurveyOptionList();
                if (CollectionUtils.isEmpty(purchaseSurveyOptionList)) continue;
                purchaseSurveyOptionList.forEach(item -> {
                    item.setHeadId(purchaseSurveyLibrary.getId());
                    item.setElsAccount(purchaseSurveyLibrary.getElsAccount());
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                });
                this.purchaseSurveyOptionMapper.insertBatchSomeColumn(purchaseSurveyOptionList);
            }
            if (!purchaseSurveyLibraryList.isEmpty()) {
                this.purchaseSurveyLibraryMapper.insertBatchSomeColumn(purchaseSurveyLibraryList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseSurveyItemList)) {
            for (PurchaseSurveyItem purchaseSurveyItem : purchaseSurveyItemList) {
                purchaseSurveyItem.setHeadId(purchaseSurveyHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseSurveyItem, (BaseEntity)purchaseSurveyHead);
            }
            if (!purchaseSurveyItemList.isEmpty()) {
                this.purchaseSurveyItemMapper.insertBatchSomeColumn(purchaseSurveyItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseSurveyAnswerList)) {
            for (PurchaseSurveyAnswer purchaseSurveyAnswer : purchaseSurveyAnswerList) {
                purchaseSurveyAnswer.setHeadId(purchaseSurveyHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseSurveyAnswer, (BaseEntity)purchaseSurveyHead);
            }
            if (!purchaseSurveyAnswerList.isEmpty()) {
                this.purchaseSurveyAnswerMapper.insertBatchSomeColumn(purchaseSurveyAnswerList);
            }
        }
    }

    public void insertUsers(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyAnswer> purchaseSurveyAnswerList) {
        if (purchaseSurveyAnswerList.isEmpty()) {
            List elsSubAccountDTOList = this.accountRpcService.getAllByAccount(purchaseSurveyHead.getElsAccount());
            ArrayList<PurchaseSurveyAnswer> purchaseSurveyAnswers = new ArrayList<PurchaseSurveyAnswer>();
            for (ElsSubAccountDTO elsSubAccountDTO : elsSubAccountDTOList) {
                PurchaseSurveyAnswer purchaseSurveyAnswer = new PurchaseSurveyAnswer();
                purchaseSurveyAnswer.setAllot("1");
                purchaseSurveyAnswer.setDeleted(0);
                purchaseSurveyAnswer.setAnswerAccount(purchaseSurveyHead.getElsAccount());
                purchaseSurveyAnswer.setAnswerName(elsSubAccountDTO.getRealname());
                purchaseSurveyAnswer.setAnswerSubAccount(elsSubAccountDTO.getSubAccount());
                purchaseSurveyAnswer.setHeadId(purchaseSurveyHead.getId());
                purchaseSurveyAnswer.setCreateBy(purchaseSurveyHead.getCreateBy());
                purchaseSurveyAnswer.setCreateById(purchaseSurveyHead.getCreateById());
                purchaseSurveyAnswer.setCreateTime(new Date());
                purchaseSurveyAnswer.setInjectionEls(true);
                purchaseSurveyAnswer.setElsAccount(elsSubAccountDTO.getElsAccount());
                purchaseSurveyAnswers.add(purchaseSurveyAnswer);
            }
            if (purchaseSurveyAnswers.size() > 0) {
                this.purchaseSurveyAnswerMapper.insertBatchSomeColumn(purchaseSurveyAnswers);
            }
        }
    }

    @Override
    public void publish(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyLibrary> purchaseSurveyLibraryList, List<PurchaseSurveyAnswer> purchaseSurveyAnswerList) {
        if (!ServeyScopeEnum.PUBLIC.getValue().equals(purchaseSurveyHead.getSurveyScope())) {
            List<String> strings;
            ArrayList<PurchaseSurveyItem> purchaseSurveyItemList = new ArrayList<PurchaseSurveyItem>();
            ArrayList<PurchaseSurveyAnswerLibrary> purchaseSurveyAnswerLibraryList = new ArrayList<PurchaseSurveyAnswerLibrary>();
            ArrayList<PurchaseSurveyAnswerOption> purchaseSurveyAnswerOptionList = new ArrayList<PurchaseSurveyAnswerOption>();
            HashMap receiveElsAccountMap = new HashMap();
            for (PurchaseSurveyAnswer purchaseSurveyAnswer : purchaseSurveyAnswerList) {
                List<String> strings2;
                PurchaseSurveyItem purchaseSurveyItem = new PurchaseSurveyItem();
                purchaseSurveyItem.setAnswerAccount(purchaseSurveyAnswer.getAnswerAccount());
                purchaseSurveyItem.setAnswerSubAccount(purchaseSurveyAnswer.getAnswerSubAccount());
                purchaseSurveyItem.setAnswerName(purchaseSurveyAnswer.getAnswerName());
                purchaseSurveyItem.setAnswerStatus(ServeyItemStatusEnum.ANSWER.getValue());
                purchaseSurveyItem.setElsAccount(purchaseSurveyHead.getElsAccount());
                purchaseSurveyItem.setHeadId(purchaseSurveyHead.getId());
                purchaseSurveyItem.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseSurveyItem.setId(IdWorker.getIdStr());
                purchaseSurveyItemList.add(purchaseSurveyItem);
                if (receiveElsAccountMap.containsKey(purchaseSurveyAnswer.getAnswerAccount())) {
                    strings2 = (List)receiveElsAccountMap.get(purchaseSurveyAnswer.getAnswerAccount());
                    strings2.add(purchaseSurveyAnswer.getAnswerSubAccount());
                    receiveElsAccountMap.put(purchaseSurveyAnswer.getAnswerAccount(), strings2);
                } else {
                    strings2 = new ArrayList<String>();
                    strings2.add(purchaseSurveyAnswer.getAnswerSubAccount());
                    receiveElsAccountMap.put(purchaseSurveyAnswer.getAnswerAccount(), strings2);
                }
                if (!CollectionUtils.isEmpty(purchaseSurveyLibraryList)) {
                    for (PurchaseSurveyLibrary purchaseSurveyLibrary : purchaseSurveyLibraryList) {
                        PurchaseSurveyAnswerLibrary purchaseSurveyAnswerLibrary = new PurchaseSurveyAnswerLibrary();
                        BeanUtils.copyProperties((Object)((Object)purchaseSurveyLibrary), (Object)((Object)purchaseSurveyAnswerLibrary));
                        purchaseSurveyAnswerLibrary.setId(IdWorker.getIdStr());
                        purchaseSurveyAnswerLibrary.setHeadId(purchaseSurveyItem.getId());
                        purchaseSurveyAnswerLibraryList.add(purchaseSurveyAnswerLibrary);
                        List<PurchaseSurveyOption> purchaseSurveyOptionList = purchaseSurveyLibrary.getPurchaseSurveyOptionList();
                        if (CollectionUtils.isEmpty(purchaseSurveyOptionList)) continue;
                        for (PurchaseSurveyOption purchaseSurveyOption : purchaseSurveyOptionList) {
                            PurchaseSurveyAnswerOption purchaseSurveyAnswerOption = new PurchaseSurveyAnswerOption();
                            BeanUtils.copyProperties((Object)((Object)purchaseSurveyOption), (Object)((Object)purchaseSurveyAnswerOption));
                            purchaseSurveyAnswerOption.setId(IdWorker.getIdStr());
                            purchaseSurveyAnswerOption.setHeadId(purchaseSurveyAnswerLibrary.getId());
                            purchaseSurveyAnswerOptionList.add(purchaseSurveyAnswerOption);
                        }
                    }
                }
                purchaseSurveyAnswer.setAllot("1");
            }
            this.purchaseSurveyAnswerService.updateBatchById(purchaseSurveyAnswerList);
            this.purchaseSurveyItemService.saveBatch(purchaseSurveyItemList);
            if (!purchaseSurveyAnswerLibraryList.isEmpty()) {
                this.purchaseSurveyAnswerLibraryService.saveBatch(purchaseSurveyAnswerLibraryList);
            }
            if (!purchaseSurveyAnswerOptionList.isEmpty()) {
                this.purchaseSurveyAnswerOptionService.saveBatch(purchaseSurveyAnswerOptionList);
            }
            String urlParam = "id=" + purchaseSurveyHead.getId();
            if (receiveElsAccountMap.containsKey(purchaseSurveyHead.getElsAccount())) {
                strings = (List)receiveElsAccountMap.get(purchaseSurveyHead.getElsAccount());
                strings.add(purchaseSurveyHead.getPrincipal().split("_")[0]);
                receiveElsAccountMap.put(purchaseSurveyHead.getElsAccount(), strings);
            } else {
                strings = new ArrayList<String>();
                strings.add(purchaseSurveyHead.getPrincipal().split("_")[0]);
                receiveElsAccountMap.put(purchaseSurveyHead.getElsAccount(), strings);
            }
            super.sendMsg(purchaseSurveyHead.getElsAccount(), receiveElsAccountMap, (Object)purchaseSurveyHead, urlParam, "survey", "publish");
        } else {
            LoginUser user = SysUtil.getLoginUser();
            PurchaseNotice notice = new PurchaseNotice();
            notice.setBusAccount(user.getElsAccount());
            notice.setNoticeTitle(purchaseSurveyHead.getSurveyName());
            notice.setNoticeContent(purchaseSurveyHead.getId());
            notice.setNoticeType("2");
            notice.setTop("1");
            notice.setEffectiveTime(new Date());
            notice.setBusinessType("survey");
            notice.setBusinessId(purchaseSurveyHead.getId());
            notice.setExpiryTime(purchaseSurveyHead.getEndDate());
            notice.setNoticeScope(NoticeScopeEnum.OPEN.getValue());
            this.purchaseNoticeRpcService.publish(notice, Lists.newArrayList(), Lists.newArrayList());
        }
        purchaseSurveyHead.setSurveyStatus(ServeyStatusEnum.PUBLISH.getValue());
        this.purchaseSurveyHeadMapper.updateById((Object)purchaseSurveyHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSurveyLibraryMapper.deleteByMainId(id);
        this.purchaseSurveyItemMapper.deleteByMainId(id);
        this.purchaseSurveyAnswerMapper.deleteByMainId(id);
        this.purchaseSurveyHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSurveyLibraryMapper.deleteByMainId(serializable.toString());
            this.purchaseSurveyItemMapper.deleteByMainId(serializable.toString());
            this.purchaseSurveyAnswerMapper.deleteByMainId(serializable.toString());
            this.purchaseSurveyHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public JSONObject getOutLinkInfo(String id) {
        JSONObject result = new JSONObject();
        String serviceBase = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.address");
        String url = String.valueOf(serviceBase) + "/questionnaire/observe?businessType=survey&businessId=" + id;
        result.put("url", (Object)url);
        result.put("qr", (Object)this.createQr(url));
        return result;
    }

    @Override
    public PurchaseSurveyHead copySurvey(String id) {
        List<PurchaseSurveyLibrary> purchaseSurveyLibraries;
        List<PurchaseSurveyAnswer> purchaseSurveyAnswerList;
        LoginUser loginUser = new LoginUser();
        PurchaseSurveyHead purchaseSurveyHead = (PurchaseSurveyHead)((Object)this.getById((Serializable)((Object)id)));
        PurchaseSurveyHead purchaseSurveyHead1 = new PurchaseSurveyHead();
        if (purchaseSurveyHead != null) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSurveyNumber", (Object)purchaseSurveyHead);
            purchaseSurveyHead1.setSurveyNumber(nextCode);
            purchaseSurveyHead1.setElsAccount(TenantContext.getTenant());
            purchaseSurveyHead1.setAuditStatus(purchaseSurveyHead.getAuditStatus());
            if (StringUtils.isNotBlank((CharSequence)purchaseSurveyHead.getPurchaseName())) {
                purchaseSurveyHead1.setPurchaseName(purchaseSurveyHead.getPurchaseName());
            }
            if (StringUtils.isNotBlank((CharSequence)purchaseSurveyHead.getSurveyDesc())) {
                purchaseSurveyHead1.setSurveyDesc(purchaseSurveyHead.getSurveyDesc());
            }
            if (StringUtils.isNotBlank((CharSequence)purchaseSurveyHead.getSurveyName())) {
                purchaseSurveyHead1.setSurveyName(purchaseSurveyHead.getSurveyName());
            }
            purchaseSurveyHead1.setSurveyStatus("0");
            purchaseSurveyHead1.setSurveyVersion("1");
            purchaseSurveyHead1.setSurveyType(purchaseSurveyHead.getSurveyType());
            purchaseSurveyHead1.setSurveyScope(purchaseSurveyHead.getSurveyScope());
            purchaseSurveyHead1.setStartDate(purchaseSurveyHead.getStartDate());
            purchaseSurveyHead1.setEndDate(purchaseSurveyHead.getEndDate());
            purchaseSurveyHead1.setCreateBy(loginUser.getRealname());
            purchaseSurveyHead1.setCreateById(loginUser.getId());
            purchaseSurveyHead1.setCreateTime(new Date());
            this.purchaseSurveyHeadMapper.insert((Object)purchaseSurveyHead1);
        }
        if (!CollectionUtils.isEmpty(purchaseSurveyAnswerList = this.purchaseSurveyAnswerMapper.selectByMainId(id))) {
            ArrayList<PurchaseSurveyAnswer> purchaseSurveyAnswers = new ArrayList<PurchaseSurveyAnswer>();
            for (PurchaseSurveyAnswer purchaseSurveyAnswer : purchaseSurveyAnswerList) {
                PurchaseSurveyAnswer purchaseSurveyAnswer1 = new PurchaseSurveyAnswer();
                purchaseSurveyAnswer1.setAllot("1");
                purchaseSurveyAnswer1.setDeleted(0);
                purchaseSurveyAnswer1.setAnswerAccount(loginUser.getElsAccount());
                purchaseSurveyAnswer1.setAnswerName(purchaseSurveyAnswer.getAnswerName());
                purchaseSurveyAnswer1.setAnswerAccount(purchaseSurveyAnswer.getAnswerAccount());
                purchaseSurveyAnswer1.setAnswerSubAccount(purchaseSurveyAnswer.getAnswerSubAccount());
                purchaseSurveyAnswer1.setHeadId(purchaseSurveyHead1.getId());
                purchaseSurveyAnswer1.setCreateBy(loginUser.getRealname());
                purchaseSurveyAnswer1.setCreateById(loginUser.getId());
                purchaseSurveyAnswer1.setCreateTime(new Date());
                purchaseSurveyAnswer1.setInjectionEls(true);
                purchaseSurveyAnswer1.setElsAccount(purchaseSurveyHead.getElsAccount());
                purchaseSurveyAnswers.add(purchaseSurveyAnswer1);
            }
            this.purchaseSurveyAnswerMapper.insertBatchSomeColumn(purchaseSurveyAnswers);
        }
        if (!CollectionUtils.isEmpty(purchaseSurveyLibraries = this.purchaseSurveyLibraryMapper.selectByMainId(purchaseSurveyHead.getId()))) {
            ArrayList<PurchaseSurveyLibrary> purchaseSurveyLibraryList = new ArrayList<PurchaseSurveyLibrary>();
            for (PurchaseSurveyLibrary purchaseSurveyLibrary : purchaseSurveyLibraries) {
                PurchaseSurveyLibrary purchaseSurveyLibrary1 = new PurchaseSurveyLibrary();
                purchaseSurveyLibrary1.setId(IdWorker.getIdStr());
                purchaseSurveyLibrary1.setHeadId(purchaseSurveyHead1.getId());
                purchaseSurveyLibrary1.setDeleted(0);
                purchaseSurveyLibrary1.setElsAccount(purchaseSurveyHead.getElsAccount());
                purchaseSurveyLibrary1.setInjectionEls(true);
                purchaseSurveyLibrary1.setItemName(purchaseSurveyLibrary.getItemName());
                purchaseSurveyLibrary1.setItemType(purchaseSurveyLibrary.getItemType());
                purchaseSurveyLibrary1.setLibraryContent(purchaseSurveyLibrary.getLibraryContent());
                purchaseSurveyLibrary1.setPurchaseSurveyOptionList(purchaseSurveyLibrary.getPurchaseSurveyOptionList());
                purchaseSurveyLibrary1.setCreateBy(loginUser.getSubAccount());
                purchaseSurveyLibrary1.setCreateById(loginUser.getId());
                purchaseSurveyLibrary1.setCreateTime(new Date());
                purchaseSurveyLibrary1.setFbk1(purchaseSurveyLibrary.getFbk1());
                purchaseSurveyLibraryList.add(purchaseSurveyLibrary1);
                List<PurchaseSurveyOption> purchaseSurveyOptionList = purchaseSurveyLibrary.getPurchaseSurveyOptionList();
                ArrayList<PurchaseSurveyOption> purchaseSurveyOptionList1 = new ArrayList<PurchaseSurveyOption>();
                for (PurchaseSurveyOption purchaseSurveyOption : purchaseSurveyOptionList) {
                    PurchaseSurveyOption purchaseSurveyOption1 = new PurchaseSurveyOption();
                    BeanUtils.copyProperties((Object)((Object)purchaseSurveyOption), (Object)((Object)purchaseSurveyOption1));
                    purchaseSurveyOption1.setId(IdWorker.getIdStr());
                    purchaseSurveyOption1.setHeadId(purchaseSurveyLibrary1.getId());
                    purchaseSurveyOptionList1.add(purchaseSurveyOption1);
                }
                this.purchaseSurveyOptionMapper.insertBatchSomeColumn(purchaseSurveyOptionList1);
            }
            this.purchaseSurveyLibraryMapper.insertBatchSomeColumn(purchaseSurveyLibraryList);
        }
        return null;
    }

    @Override
    public void test() {
    }

    private String createQr(String url) {
        BufferedImage image = QrCodeUtil.generate((String)url, (int)300, (int)300);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", stream);
        }
        catch (IOException e) {
            this.log.error("createQr_failed:", (Throwable)e);
        }
        String base64 = Base64.encode((byte[])stream.toByteArray());
        return "data:image/png;base64," + base64;
    }
}

