/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.listener;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.modules.message.service.MsgService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.tongtech.client.annotation.HTPMessageListener;
import com.tongtech.client.consumer.PullResult;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyContext;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.tongtech.client.core.HTPPushConsumerLifecycleListener;
import com.tongtech.client.exception.HTPException;
import com.tongtech.client.htp.consumer.HTPPushConsumer;
import com.tongtech.client.message.Message;
import com.tongtech.client.support.HTPListenerConcurrently;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HTPMessageListener(consumerGroup="outputbusinessmessage", topic="outputbusinessmessage", namespace="zhongken")
public class BusinessMessageConcumerListener
implements HTPListenerConcurrently,
HTPPushConsumerLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(BusinessMessageConcumerListener.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private MsgService msgService;
    private HTPPushConsumer pushConsumer;

    public ConsumeConcurrentlyStatus onMessage(PullResult pullResult, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        log.info("push\u6d88\u606f\u6210\u529f,\u7ed3\u679c\uff1a" + pullResult);
        pullResult.getMsgFoundList().forEach(messageExt -> {
            try {
                String errorInfo = "";
                String msgStatus = "";
                String key = messageExt.getMsgId();
                try {
                    String msgBody = new String(messageExt.getBody());
                    JSONObject msgObj = JSONObject.parseObject((String)msgBody);
                    if (!msgObj.containsKey((Object)"busAccount")) {
                        throw new ELSBootException("busAccount can not be blank");
                    }
                    if (!msgObj.containsKey((Object)"msgKey")) {
                        throw new ELSBootException("msgKey can not be blank");
                    }
                    if (!msgObj.containsKey((Object)"businessType")) {
                        throw new ELSBootException("businessType can not be blank");
                    }
                    if (!msgObj.containsKey((Object)"operateType")) {
                        throw new ELSBootException("operateType can not be blank");
                    }
                    if (!msgObj.containsKey((Object)"receiveList")) {
                        throw new ELSBootException("receiveList can not be blank");
                    }
                    if (!msgObj.containsKey((Object)"sendObj")) {
                        throw new ELSBootException("sendObj can not be blank");
                    }
                    if (!msgObj.containsKey((Object)"businessObj")) {
                        throw new ELSBootException("businessObj can not be blank");
                    }
                    this.msgService.sendMsg(msgObj);
                    msgStatus = "1";
                }
                catch (Exception e) {
                    msgStatus = "2";
                    errorInfo = e.getMessage();
                }
                finally {
                    this.invokeBaseRpcService.updateRecord(key, msgStatus, errorInfo);
                }
                this.pushConsumer.acknowledge((Message)messageExt);
            }
            catch (HTPException e) {
                throw new RuntimeException(e);
            }
        });
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    public void prepareStart(HTPPushConsumer htpPushConsumer) {
        this.pushConsumer = htpPushConsumer;
        this.pushConsumer.setClientAcknowledge();
    }
}

