/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.log.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.log.entity.Log;
import com.els.modules.log.mapper.LogMapper;
import com.els.modules.log.rpc.service.MessageInvokeSupplierRpcService;
import com.els.modules.log.service.LogService;
import com.els.modules.log.vo.LogVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class LogServiceImpl
extends ServiceImpl<LogMapper, Log>
implements LogService {
    private static final Logger log = LoggerFactory.getLogger(LogServiceImpl.class);
    @Resource
    private LogMapper logMapper;
    @Resource
    private MessageInvokeSupplierRpcService messageInvokeSupplierRpcService;

    @Override
    public void removeAll() {
        this.logMapper.removeAll();
    }

    @Override
    public Long findTotalVisitCount() {
        return this.logMapper.findTotalVisitCount();
    }

    @Override
    public Long findTodayVisitCount(Date dayStart, Date dayEnd) {
        return this.logMapper.findTodayVisitCount(dayStart, dayEnd);
    }

    @Override
    public Long findTodayIp(Date dayStart, Date dayEnd) {
        return this.logMapper.findTodayIp(dayStart, dayEnd);
    }

    @Override
    @Async
    public void saveLog(Log sysLog) {
        this.save(sysLog);
    }

    @Override
    public IPage<LogVO> findSupplierLoginList(LogVO logVO) {
        Page page = new Page((long)logVO.getFromIndex().intValue(), (long)logVO.getPageSize().intValue());
        List<SupplierMasterDataDTO> supplierList = this.messageInvokeSupplierRpcService.findSupplierList(TenantContext.getTenant(), logVO.getSupplierName());
        if (supplierList.isEmpty()) {
            return page;
        }
        List<String> toElsAccountList = supplierList.stream().map(SupplierMasterDataDTO::getToElsAccount).collect(Collectors.toList());
        Map<String, List<SupplierMasterDataDTO>> map = supplierList.stream().collect(Collectors.groupingBy(SupplierMasterDataDTO::getToElsAccount));
        logVO.setToElsAccountList(toElsAccountList);
        List<LogVO> list = this.logMapper.findSupplierLoginList(logVO);
        for (LogVO vo : list) {
            vo.setToElsAccount(vo.getElsAccount());
            List<SupplierMasterDataDTO> itemList = map.get(vo.getElsAccount());
            if (itemList == null || itemList.size() <= 0) continue;
            vo.setSupplierName(itemList.get(0).getSupplierName());
        }
        int count = this.logMapper.findSupplierLoginListCount(logVO);
        page.setRecords(list);
        page.setSize((long)count);
        page.setTotal((long)count);
        return page;
    }

    @Override
    public List<LogVO> findModuleOptList(LogVO logVO) {
        return this.logMapper.findModuleOptList(logVO);
    }

    @Override
    public List<LogVO> findUserLoginList(LogVO logVO) {
        return this.logMapper.findUserLoginList(logVO);
    }

    @Override
    public void clearLog(int days) {
        Date currentDate = new Date();
        DateTime clearDate = DateUtil.offsetDay((Date)currentDate, (int)(-days));
        List logIdList = this.list((Wrapper)new QueryWrapper().select(new String[]{"id"}).lt((Object)"create_time", (Object)clearDate));
        log.info("\u67e5\u8be2\u5230 " + logIdList.size() + "\u6761\u5f85\u6e05\u7406\u7684\u65e5\u5fd7\uff0c\u5f00\u59cb\u6267\u884c\u6e05\u7406...");
        for (Log log : logIdList) {
            this.logMapper.deleteById(log.getId());
        }
    }
}

