/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.JustAuthConfigDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.rpc.service.MessageInvokeAccountService;
import com.els.modules.message.vo.MsgVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(WxSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        ArrayList busAccountList;
        log.info("WxSendMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u5fae\u4fe1\u6d88\u606f\u7684\u903b\u8f91.");
        Map<String, List<ElsMsgConfigItem>> elsMsgConfigItem = msg.getElsMsgConfigItem();
        if (CollectionUtil.isEmpty(elsMsgConfigItem)) {
            log.warn("WxSendMsgImpl \u7f3a\u5c11\u516c\u4f17\u53f7\u6d88\u606f\u914d\u7f6e");
            return;
        }
        ElsSubAccountDTO account = msg.getReceiveAccount();
        MessageInvokeAccountService thirdAccountService = (MessageInvokeAccountService)SpringContextUtils.getBean(MessageInvokeAccountService.class);
        List<ThirdAccountDTO> list = thirdAccountService.getThirdAccount(busAccountList = Lists.newArrayList((Iterable)Sets.newHashSet((Object[])new String[]{"100000", msg.getBusAccount(), msg.getReceiveAccount().getElsAccount()})), account.getId(), "WECHAT_MP");
        if (list.isEmpty()) {
            log.warn("WxSendMsgImpl receive not bind WECHAT_MP");
            return;
        }
        for (ThirdAccountDTO accountDto : list) {
            List<ElsMsgConfigItem> elsMsgConfigItems = elsMsgConfigItem.get(accountDto.getBusAccount());
            boolean configFlag = this.checkIfConfigByCurrentAccount(msg, accountDto.getBusAccount());
            String configAccount = accountDto.getBusAccount();
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && configFlag) {
                log.warn("\u5f53\u524d\u8d26\u53f7:{}\u6ca1\u6709\u914d\u7f6e{}\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b\u914d\u7f6e", (Object)accountDto.getBusAccount(), (Object)"WECHAT_ENTERPRISE");
                continue;
            }
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && !configFlag) {
                elsMsgConfigItems = elsMsgConfigItem.get("100000");
                configAccount = "100000";
                if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
                    log.warn("\u5f53\u524d\u8d26\u53f7:{}\u6ca1\u6709\u914d\u7f6e{}\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b\u914d\u7f6e", (Object)"100000", (Object)"WECHAT_ENTERPRISE");
                    continue;
                }
            }
            ElsMsgConfigItem item = elsMsgConfigItems.get(0);
            msg.setMsgContent(item.getMsgContent());
            if (StrUtil.isBlank((CharSequence)item.getTemplateNumber())) {
                log.error(":::elsAccount:{}\u53d1\u9001\u516c\u4f17\u53f7\u6d88\u606f\u914d\u7f6e\u6ca1\u6709\u914d\u7f6e\u6a21\u677f\u53f7...", (Object)configAccount);
                continue;
            }
            try {
                JustAuthConfigDTO config = this.getJustConfig(configAccount, "WECHAT_MP");
                if (StrUtil.isEmpty((CharSequence)config.getClientId())) {
                    log.error(":::\u516c\u4f17\u53f7\u7b2c\u4e09\u65b9\u914d\u7f6e\u4e0d\u5b58\u5728,elsAccount:{}", (Object)configAccount);
                    return;
                }
                String urlString = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + ThirdTokenUtil.getWechatMpToken((String)configAccount, (JustAuthConfigDTO)config);
                JSONObject body = new JSONObject();
                body.put("template_id", (Object)item.getTemplateNumber());
                body.put("url", (Object)this.getUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), configAccount));
                if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
                    JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                    String msgContent = TemplateParseUtil.getTemplateText((String)"", (String)item.getMsgContent(), (Map)object);
                    body.put("data", JSONObject.parse((String)msgContent));
                }
                body.put("touser", (Object)accountDto.getThirdUserUuid());
                log.info(":::WxSendMsgImpl msgBody:{}", (Object)body.toString());
                String result = HttpUtil.post((String)urlString, (String)body.toString());
                log.info(":::WxSendMsgImpl send message result:{}", (Object)result);
            }
            catch (Exception e) {
                log.error("WxSendMsgImpl.doSendMsg \u5fae\u4fe1\u53d1\u9001\u6d88\u606f\u5f02\u5e38:", (Object)e.getMessage());
            }
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/account/thirdLogin/render/%s/mobile/wechat_mp";
    }

    public static void main(String[] args) {
        String token = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=46_cdvi4kKxG51o5_ao4LYEVUKSrVEJ2tKBwrgKE688wb6NOaXJuSyH4AJzZmdAHZ_CepbFFpP6AjmiPXQBDMuh50-zESXmm5E28EcH5q5_YJJwXXFyuUuCs-7sjmW5Ydt9BBB_1U2Ztcd4CCgkIOTfABACIN";
        String body = "{\r\n           \"touser\":\"oCQZC6GSLuribL-Ez_WK_Qz4o4XU\",\r\n           \"template_id\":\"TrCHKlWNdYk8_4v-T1ovVbi1t4IOC9guBrj84diJpyo\",\r\n           \"url\":\"http://v5sit.51qqt.com/user/login\",           \r\n           \"data\":{\r\n           \t\"number\": {\r\n                       \"value\":\"aaa\",\r\n                       \"color\":\"#173177\"\r\n                   }\r\n           }\r\n}";
        HttpUtil.post((String)token, (String)body);
    }
}

