/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.survey.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.IPUtils;
import com.els.common.util.SysUtil;
import com.els.modules.survey.entity.PurchaseSurveyAnswerLibrary;
import com.els.modules.survey.entity.PurchaseSurveyAnswerOption;
import com.els.modules.survey.entity.PurchaseSurveyHead;
import com.els.modules.survey.entity.PurchaseSurveyItem;
import com.els.modules.survey.enumerate.ServeyItemStatusEnum;
import com.els.modules.survey.mapper.PurchaseSurveyAnswerLibraryMapper;
import com.els.modules.survey.mapper.PurchaseSurveyAnswerOptionMapper;
import com.els.modules.survey.mapper.PurchaseSurveyItemMapper;
import com.els.modules.survey.service.PurchaseSurveyHeadService;
import com.els.modules.survey.service.PurchaseSurveyItemService;
import com.els.modules.survey.vo.PurchaseSurveyItemVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseSurveyItemServiceImpl
extends BaseServiceImpl<PurchaseSurveyItemMapper, PurchaseSurveyItem>
implements PurchaseSurveyItemService {
    @Resource
    private PurchaseSurveyItemMapper purchaseSurveyItemMapper;
    @Resource
    private PurchaseSurveyAnswerLibraryMapper purchaseSurveyAnswerLibraryMapper;
    @Resource
    private PurchaseSurveyAnswerOptionMapper purchaseSurveyAnswerOptionMapper;
    @Autowired
    private PurchaseSurveyHeadService purchaseSurveyHeadService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSurveyItem purchaseSurveyItem, List<PurchaseSurveyAnswerLibrary> purchaseSurveyAnswerLibraryList) {
        this.purchaseSurveyItemMapper.insert((Object)purchaseSurveyItem);
        this.insertData(purchaseSurveyItem, purchaseSurveyAnswerLibraryList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSurveyItem purchaseSurveyItem, List<PurchaseSurveyAnswerLibrary> purchaseSurveyAnswerLibraryList) {
        this.purchaseSurveyItemMapper.updateById((Object)purchaseSurveyItem);
        this.purchaseSurveyAnswerOptionMapper.deleteByMainId(purchaseSurveyItem.getId());
        this.purchaseSurveyAnswerLibraryMapper.deleteByMainId(purchaseSurveyItem.getId());
        this.insertData(purchaseSurveyItem, purchaseSurveyAnswerLibraryList);
    }

    private void insertData(PurchaseSurveyItem purchaseSurveyItem, List<PurchaseSurveyAnswerLibrary> purchaseSurveyAnswerLibraryList) {
        for (PurchaseSurveyAnswerLibrary entity : purchaseSurveyAnswerLibraryList) {
            entity.setHeadId(purchaseSurveyItem.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSurveyItem);
            entity.setId(IdWorker.getIdStr());
            entity.setElsAccount(purchaseSurveyItem.getElsAccount());
            List<PurchaseSurveyAnswerOption> purchaseSurveyOptionList = entity.getPurchaseSurveyAnswerOptionList();
            if (CollectionUtils.isEmpty(purchaseSurveyOptionList)) continue;
            purchaseSurveyOptionList.forEach(item -> {
                item.setHeadId(entity.getId());
                item.setElsAccount(entity.getElsAccount());
                item.setDeleted(CommonConstant.DEL_FLAG_0);
            });
            this.purchaseSurveyAnswerOptionMapper.insertBatchSomeColumn(purchaseSurveyOptionList);
        }
        if (!purchaseSurveyAnswerLibraryList.isEmpty()) {
            this.purchaseSurveyAnswerLibraryMapper.insertBatchSomeColumn(purchaseSurveyAnswerLibraryList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSurveyAnswerLibraryMapper.deleteByMainId(id);
        this.purchaseSurveyItemMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSurveyAnswerLibraryMapper.deleteByMainId(serializable.toString());
            this.purchaseSurveyItemMapper.deleteById(serializable);
        }
    }

    @Override
    public List<PurchaseSurveyItem> selectByMainId(String mainId) {
        return this.purchaseSurveyItemMapper.selectByMainId(mainId);
    }

    @Override
    public void submitSys(PurchaseSurveyItemVO purchaseSurveyItemVO) {
        PurchaseSurveyItem purchaseSurveyItem = (PurchaseSurveyItem)((Object)this.purchaseSurveyItemMapper.selectById((Serializable)((Object)purchaseSurveyItemVO.getId())));
        String elsAccount = purchaseSurveyItem.getElsAccount();
        if (!purchaseSurveyItem.getAnswerStatus().equals(ServeyItemStatusEnum.ANSWER.getValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QUzEufDs_2d48e9df", (String)"\u95ee\u5377\u72b6\u6001\u975e\u7b54\u9898\u4e2d"));
        }
        PurchaseSurveyHead purchaseSurveyHead = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)purchaseSurveyItem.getHeadId())));
        if (purchaseSurveyHead != null && purchaseSurveyHead.getEndDate().compareTo(new Date()) < 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QUDmIyW_8183bb33", (String)"\u95ee\u5377\u8c03\u67e5\u5df2\u7ed3\u675f"));
        }
        for (PurchaseSurveyAnswerLibrary purchaseSurveyAnswerLibrary : purchaseSurveyItemVO.getPurchaseSurveyAnswerLibraryList()) {
            purchaseSurveyAnswerLibrary.setElsAccount(elsAccount);
            List<PurchaseSurveyAnswerOption> purchaseSurveyAnswerOptionList = purchaseSurveyAnswerLibrary.getPurchaseSurveyAnswerOptionList();
            for (PurchaseSurveyAnswerOption purchaseSurveyAnswerOption : purchaseSurveyAnswerOptionList) {
                purchaseSurveyAnswerOption.setElsAccount(elsAccount);
                this.purchaseSurveyAnswerOptionMapper.alwaysUpdateSomeColumnById((Object)purchaseSurveyAnswerOption);
            }
            this.purchaseSurveyAnswerLibraryMapper.alwaysUpdateSomeColumnById((Object)purchaseSurveyAnswerLibrary);
        }
        purchaseSurveyItem.setAnswerStatus(ServeyItemStatusEnum.SUBMIT.getValue());
        String ipAddr = IPUtils.getIpAddr();
        purchaseSurveyItem.setAnswerIp(ipAddr);
        purchaseSurveyItem.setAnswerDate(new Date());
        this.purchaseSurveyItemMapper.updateById((Object)purchaseSurveyItem);
        String urlParam = "id=" + purchaseSurveyHead.getId();
        HashMap<String, List<String>> receiveElsAccountMap = new HashMap<String, List<String>>();
        receiveElsAccountMap.put(purchaseSurveyHead.getElsAccount(), Arrays.asList(purchaseSurveyHead.getPrincipal().split("_")[0]));
        super.sendMsg(purchaseSurveyItem.getAnswerAccount(), receiveElsAccountMap, (Object)purchaseSurveyHead, urlParam, "survey", "reply");
    }

    @Override
    public void submitOther(PurchaseSurveyItemVO purchaseSurveyItemVO) {
        String headId = purchaseSurveyItemVO.getId();
        PurchaseSurveyHead purchaseSurveyHead = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)headId)));
        if (purchaseSurveyHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UEhxQULV_ec575f8", (String)"\u5e73\u53f0\u53d1\u5e03\u95ee\u5377\u4e3a\u7a7a"));
        }
        if (purchaseSurveyHead.getEndDate().compareTo(new Date()) < 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_QUDmIyW_8183bb33", (String)"\u95ee\u5377\u8c03\u67e5\u5df2\u7ed3\u675f"));
        }
        String elsAccount = purchaseSurveyHead.getElsAccount();
        PurchaseSurveyItem purchaseSurveyItem = new PurchaseSurveyItem();
        BeanUtils.copyProperties((Object)((Object)purchaseSurveyItemVO), (Object)((Object)purchaseSurveyItem));
        purchaseSurveyItem.setId(IdWorker.getIdStr());
        purchaseSurveyItem.setHeadId(headId);
        purchaseSurveyItem.setAnswerStatus(ServeyItemStatusEnum.SUBMIT.getValue());
        String ipAddr = IPUtils.getIpAddr();
        purchaseSurveyItem.setAnswerIp(ipAddr);
        purchaseSurveyItem.setDeleted(CommonConstant.DEL_FLAG_0);
        purchaseSurveyItem.setAnswerDate(new Date());
        purchaseSurveyItem.setElsAccount(elsAccount);
        List<PurchaseSurveyAnswerLibrary> purchaseSurveyAnswerLibraryList = purchaseSurveyItemVO.getPurchaseSurveyAnswerLibraryList();
        for (PurchaseSurveyAnswerLibrary purchaseSurveyAnswerLibrary : purchaseSurveyAnswerLibraryList) {
            purchaseSurveyAnswerLibrary.setElsAccount(elsAccount);
            purchaseSurveyAnswerLibrary.setId(IdWorker.getIdStr());
            purchaseSurveyAnswerLibrary.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseSurveyAnswerLibrary.setHeadId(purchaseSurveyItem.getId());
            List<PurchaseSurveyAnswerOption> purchaseSurveyAnswerOptionList = purchaseSurveyAnswerLibrary.getPurchaseSurveyAnswerOptionList();
            for (PurchaseSurveyAnswerOption purchaseSurveyAnswerOption : purchaseSurveyAnswerOptionList) {
                purchaseSurveyAnswerOption.setElsAccount(elsAccount);
                purchaseSurveyAnswerOption.setId(IdWorker.getIdStr());
                purchaseSurveyAnswerOption.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseSurveyAnswerOption.setHeadId(purchaseSurveyAnswerLibrary.getId());
            }
            if (CollectionUtils.isEmpty(purchaseSurveyAnswerOptionList)) continue;
            this.purchaseSurveyAnswerOptionMapper.insertBatchSomeColumn(purchaseSurveyAnswerOptionList);
        }
        this.purchaseSurveyAnswerLibraryMapper.insertBatchSomeColumn(purchaseSurveyAnswerLibraryList);
        this.purchaseSurveyItemMapper.insert((Object)purchaseSurveyItem);
    }
}

