/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.listener;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.els.common.trace.MqKeyHolder;
import com.els.common.util.SpringContextUtils;
import com.els.config.StaticConfig;
import com.els.modules.message.service.MsgService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class BusinessMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(BusinessMessageConsumer.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private MsgService msgService;

    @Bean(value={"input"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String dianchiPurchaseAccount;
            String key = (String)message.getHeaders().get((Object)"ROCKET_KEYS");
            String mqElsAccount = (String)message.getHeaders().get((Object)"mqElsAccount");
            if (mqElsAccount.equals(dianchiPurchaseAccount = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("dianchiPurchaseAccount"))) {
                DynamicDataSourceContextHolder.push((String)"dianchi");
            } else {
                DynamicDataSourceContextHolder.push((String)"master");
            }
            MqKeyHolder.set((String)key);
            String msgStatus = this.invokeBaseRpcService.getMsgStatusById(key);
            if ("1".equals(msgStatus)) {
                log.error("\u6d88\u606fID\uff1a" + key + " \u5df2\u7ecf\u6d88\u8d39\uff0c\u4e0d\u80fd\u91cd\u590d\u6d88\u8d39\uff01");
                return;
            }
            String msgBody = (String)message.getPayload();
            log.info("mqElsAccount\uff1a" + mqElsAccount + "msgBody: " + msgBody);
            String errorInfo = "";
            try {
                JSONObject msgObj = JSONObject.parseObject((String)msgBody);
                this.msgService.sendMsg(msgObj);
                msgStatus = "1";
            }
            catch (Exception e) {
                log.error("send_msg_failed:" + msgBody, (Throwable)e);
                msgStatus = "2";
                errorInfo = e.getMessage();
            }
            finally {
                this.invokeBaseRpcService.updateRecord(key, msgStatus, errorInfo);
                MqKeyHolder.remove();
                DynamicDataSourceContextHolder.clear();
            }
        };
    }
}

