/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.listener;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.els.modules.log.entity.Log;
import com.els.modules.log.service.LogService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class LogMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(LogMessageConsumer.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private LogService logService;

    @Bean(value={"inputLog"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String msgBody = (String)message.getPayload();
            log.info("receive log:" + msgBody);
            try {
                Log log = (Log)JSONObject.parseObject((String)msgBody, Log.class);
                this.logService.save(log);
            }
            catch (Exception e) {
                log.error("save log failed:", (Throwable)e);
            }
        };
    }

    @Bean(value={"dcInputLog"})
    @DS(value="dianchi")
    public Consumer<Message<String>> dcReceive() {
        return message -> {
            String msgBody = (String)message.getPayload();
            log.info("dianchireceive log:" + msgBody);
            try {
                Log log = (Log)JSONObject.parseObject((String)msgBody, Log.class);
                this.logService.save(log);
            }
            catch (Exception e) {
                log.error("dianchisave log failed:", (Throwable)e);
            }
        };
    }
}

