/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.api.dto.ElsEmailSendLogDto;
import com.els.api.dto.EmailSendRebuildDto;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.email.sender.ElsMailSender;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.config.StaticConfig;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.extend.api.base.dto.ElsEmailConfigExtendDTO;
import com.els.modules.message.entity.ElsEmailConfig;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.rpc.service.MessageInvokeBaseService;
import com.els.modules.message.service.ElsEmailConfigExtendService;
import com.els.modules.message.vo.MsgVO;
import com.els.rpc.service.EmailRpcPersistence;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.mail.javamail.JavaMailSender;

public class EmailSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(EmailSendMsgImpl.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("EmailSendMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u90ae\u4ef6\u6d88\u606f\u7684\u903b\u8f91.");
        ElsSubAccountDTO account = msg.getReceiveAccount();
        Map<String, List<ElsMsgConfigItem>> elsMsgConfigItem = msg.getElsMsgConfigItem();
        List<ElsMsgConfigItem> elsMsgConfigItems = elsMsgConfigItem.get(msg.getBusAccount());
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            elsMsgConfigItems = elsMsgConfigItem.get(msg.getToElsAccount());
            boolean configFlag = this.checkIfConfigByCurrentAccount(msg, msg.getBusAccount());
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && configFlag) {
                log.error("EmailSendMsgImpl\u5f53\u524d\u8d26\u53f7{}\u6ca1\u6709\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\u53d1\u9001:{}", (Object)msg.getBusAccount(), (Object)msg.toString());
                return;
            }
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && !configFlag) {
                elsMsgConfigItems = elsMsgConfigItem.get("100000");
            }
        }
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            return;
        }
        ElsEmailConfigExtendService elsEmailConfigExtendService = (ElsEmailConfigExtendService)SpringContextUtils.getBean(ElsEmailConfigExtendService.class);
        List<ElsEmailConfig> emailConfigList = elsEmailConfigExtendService.getEmailConfigs(elsMsgConfigItems.get(0).getElsAccount());
        List rafflesEmailConfigList = emailConfigList.parallelStream().filter(config -> "1".equals(config.getRafflesStatus())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(rafflesEmailConfigList)) {
            ElsMsgConfigItem item = elsMsgConfigItems.get(0);
            List emailConfigs = Convert.toList(ElsEmailConfigDTO.class, rafflesEmailConfigList);
            msg.setMsgContent(item.getMsgContent());
            log.info("Raffles EmailSendMsgImpl ==> start send email to:" + account.getEmail());
            try {
                int size = emailConfigs.size();
                Integer index = 0;
                Iterator iterator = emailConfigs.iterator();
                if (!iterator.hasNext()) return;
                ElsEmailConfigDTO config2 = (ElsEmailConfigDTO)iterator.next();
                config2.setTo(new String[]{account.getEmail()});
                config2.setCurrentElsAccount(msg.getSendAccount().getElsAccount());
                String msgContent = item.getMsgContent();
                String msgTitle = item.getMsgTitle();
                if (CharSequenceUtil.isNotBlank((CharSequence)msgContent)) {
                    if (msg.getParams() != null) {
                        JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                        if (CharSequenceUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                            if (CharSequenceUtil.isNotBlank((CharSequence)msg.getUrlParam())) {
                                object.put("audthUrl", (Object)this.getAuthUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), account));
                            } else {
                                object.put("audthUrl", (Object)this.getAuthUrl(TemplateParseUtil.getTemplateText((String)"", (String)item.getLinkUrl(), (Map)object), account));
                            }
                        }
                        msgContent = TemplateParseUtil.getTemplateText((String)"", (String)msgContent, (Map)object);
                        msgTitle = TemplateParseUtil.getTemplateText((String)"", (String)msgTitle, (Map)object);
                    }
                    config2.setContent(msgContent);
                }
                config2.setSubject(msgTitle);
                config2.setNeedCc(true);
                EmailRpcPersistence retrySendBuilder = (EmailRpcPersistence)SpringContextUtils.getBean(EmailRpcPersistence.class);
                ElsEmailSendLogDto sendLogDto = new ElsEmailSendLogDto();
                sendLogDto.setMsgItemConfigContent(JSON.toJSONString((Object)msg));
                EmailSendRebuildDto rebuildVo = retrySendBuilder.rebuildToSend(config2, sendLogDto);
                if (null == rebuildVo) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u670d\u52a1\u5668\u90ae\u4ef6\u53d1\u9001\u903b\u8f91\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5"));
                }
                if (rebuildVo.isFlag()) {
                    return;
                }
                config2 = rebuildVo.getConfigDTO();
                MessageInvokeBaseService messageInvokeBaseService = (MessageInvokeBaseService)SpringContextUtils.getBean(MessageInvokeBaseService.class);
                ElsEmailConfigExtendDTO configExtendDTO = new ElsEmailConfigExtendDTO();
                BeanUtils.copyProperties((Object)config2, (Object)configExtendDTO);
                messageInvokeBaseService.sendRafflesMail(configExtendDTO);
                log.info("Raffles EmailSendMsgImpl ==>:::\u53d1\u4ef6\u4eba:{} \u53d1\u9001\u90ae\u4ef6\u7ed9:{},end to send email...", (Object)config2.getEmailUsername(), (Object)account.getEmail());
                return;
            }
            catch (Exception e) {
                log.error("Raffles EmailSendMsgImpl ==>{}", (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6d88\u606f\u7ec4\u4ef6\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
            }
        }
        MessageInvokeBaseService messageInvokeBaseService = (MessageInvokeBaseService)SpringContextUtils.getBean(MessageInvokeBaseService.class);
        List<ElsEmailConfigDTO> emailConfigs = messageInvokeBaseService.getEmailConfigs(elsMsgConfigItems.get(0).getElsAccount());
        if (CollectionUtil.isEmpty(emailConfigs)) {
            emailConfigs = messageInvokeBaseService.getEmailConfigs(msg.getSendAccount().getElsAccount());
        }
        if (StrUtil.isEmpty((CharSequence)account.getEmail())) {
            log.error("EmailSendMsgImpl ==>::: \u6d88\u606f\u63a5\u6536\u65b9\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\uff0c\u65e0\u6cd5\u63a5\u6536\u90ae\u7bb1\u6d88\u606f,");
            return;
        }
        ElsMsgConfigItem item = elsMsgConfigItems.get(0);
        msg.setMsgContent(item.getMsgContent());
        log.info("EmailSendMsgImpl ==> start send email to:" + account.getEmail());
        try {
            int size = emailConfigs.size();
            Integer index = 0;
            for (ElsEmailConfigDTO config3 : emailConfigs) {
                config3.setTo(new String[]{account.getEmail()});
                config3.setCurrentElsAccount(msg.getSendAccount().getElsAccount());
                String msgContent = item.getMsgContent();
                String msgTitle = item.getMsgTitle();
                if (CharSequenceUtil.isNotBlank((CharSequence)msgContent)) {
                    if (msg.getParams() != null) {
                        JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                        if (CharSequenceUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                            if (CharSequenceUtil.isNotBlank((CharSequence)msg.getUrlParam())) {
                                object.put("audthUrl", (Object)this.getAuthUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), account));
                            } else {
                                object.put("audthUrl", (Object)this.getAuthUrl(TemplateParseUtil.getTemplateText((String)"", (String)item.getLinkUrl(), (Map)object), account));
                            }
                        }
                        msgContent = TemplateParseUtil.getTemplateText((String)"", (String)msgContent, (Map)object);
                        msgTitle = TemplateParseUtil.getTemplateText((String)"", (String)msgTitle, (Map)object);
                    }
                    config3.setContent(msgContent);
                }
                config3.setSubject(msgTitle);
                config3.setNeedCc(true);
                EmailRpcPersistence retrySendBuilder = (EmailRpcPersistence)SpringContextUtils.getBean(EmailRpcPersistence.class);
                ElsEmailSendLogDto sendLogDto = new ElsEmailSendLogDto();
                sendLogDto.setMsgItemConfigContent(JSON.toJSONString((Object)msg));
                EmailSendRebuildDto rebuildVo = retrySendBuilder.rebuildToSend(config3, sendLogDto);
                if (null == rebuildVo) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u670d\u52a1\u5668\u90ae\u4ef6\u53d1\u9001\u903b\u8f91\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5"));
                }
                if (rebuildVo.isFlag()) {
                    return;
                }
                config3 = rebuildVo.getConfigDTO();
                if ("mail.cimc-raffles.com".equals(config3.getEmailHost())) {
                    ElsEmailConfigExtendDTO configExtendDTO = new ElsEmailConfigExtendDTO();
                    BeanUtils.copyProperties((Object)config3, (Object)configExtendDTO);
                    messageInvokeBaseService.sendRafflesMail(configExtendDTO);
                    return;
                }
                ElsMailSender mailSender = ElsEmailBuilder.buildElsMailSender((ElsEmailConfigDTO)config3, null, null);
                config3.setPersistenceWhileFailed(index == size - 1);
                boolean result = mailSender.sendEmail(config3, null);
                if (result) {
                    log.info("EmailSendMsgImpl ==>:::\u53d1\u4ef6\u4eba:{} \u53d1\u9001\u90ae\u4ef6\u7ed9:{},end to send email...", (Object)config3.getEmailUsername(), (Object)account.getEmail());
                    return;
                }
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            return;
        }
        catch (Exception e) {
            log.error("EmailSendMsgImpl ==>{}", (Object)e.getMessage());
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6d88\u606f\u7ec4\u4ef6\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
    }

    private boolean sendMessage(JavaMailSender mailSender, MimeMessage message) {
        try {
            mailSender.send(message);
            return true;
        }
        catch (Exception e) {
            log.error("EmailSendMsgImpl==>sendMessage:{}", (Object)e.getMessage());
            return false;
        }
    }

    private String getAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword()));
        return url.toString();
    }
}

