/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.TemplateParseUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.entity.ElsMsgRecord;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.service.ElsMsgRecordService;
import com.els.modules.message.service.impl.ElsMsgRecordServiceImpl;
import com.els.modules.message.vo.MsgVO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstationMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(InstationMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("InstationMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u7ad9\u5185\u4fe1\u7684\u903b\u8f91.");
        try {
            Map<String, List<ElsMsgConfigItem>> elsMsgConfigItem = msg.getElsMsgConfigItem();
            List<ElsMsgConfigItem> elsMsgConfigItems = elsMsgConfigItem.get(msg.getBusAccount());
            if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
                log.info("InstationMsgImpl\u8d26\u53f7{}\u6ca1\u6709\u914d\u7f6e\u7ad9\u5185\u4fe1", (Object)msg.getBusAccount());
                elsMsgConfigItems = elsMsgConfigItem.get(msg.getToElsAccount());
                boolean configFlag = this.checkIfConfigByCurrentAccount(msg, msg.getBusAccount());
                if (CollectionUtil.isEmpty(elsMsgConfigItems) && configFlag) {
                    log.error("InstationMsgImpl\u5f53\u524d\u8d26\u53f7{}\u6ca1\u6709\u914d\u7f6e\u7ad9\u5185\u4fe1\u53d1\u9001:{}", (Object)msg.getBusAccount(), (Object)msg.toString());
                    return;
                }
                if (CollectionUtil.isEmpty(elsMsgConfigItems) && !configFlag) {
                    elsMsgConfigItems = elsMsgConfigItem.get("100000");
                }
            }
            ElsMsgConfigItem item = elsMsgConfigItems.get(0);
            msg.setMsgContent(item.getMsgContent());
            ElsSubAccountDTO account = msg.getReceiveAccount();
            ElsSubAccountDTO sendAccount = msg.getSendAccount();
            ElsMsgRecord record = new ElsMsgRecord();
            if (StrUtil.isEmpty((CharSequence)account.getId())) {
                log.info("InstationMsgImpl\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u8d26\u53f7\u7f3a\u5c11id");
                return;
            }
            log.info("InstationMsgImpl\u5f00\u59cb\u6784\u5efa\u7ad9\u5185\u4fe1\u5185\u5bb9");
            record.setBusinessType(msg.getBusinessType());
            record.setOperateType(msg.getOperateType());
            record.setElsAccount(account.getElsAccount());
            record.setSubAccount(account.getSubAccount());
            record.setReceiverId(account.getId());
            record.setReceiverName(account.getRealname());
            record.setSendElsAccount(sendAccount.getElsAccount());
            record.setSendSubAccount(sendAccount.getSubAccount());
            record.setSendId(sendAccount.getId());
            record.setSendName(sendAccount.getRealname());
            if ("100000".equals(sendAccount.getElsAccount()) && CharSequenceUtil.isEmpty((CharSequence)record.getSendName())) {
                record.setSendName("system");
            }
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            BeanUtil.copyProperties((Object)msg.getParams(), paramsMap, (String[])new String[0]);
            log.info(":::paramMap:{}", paramsMap);
            String msgTitle = item.getMsgTitle();
            if (StrUtil.isNotBlank((CharSequence)msgTitle) && msg.getParams() != null) {
                try {
                    msgTitle = TemplateParseUtil.getTemplateText((String)"", (String)msgTitle, paramsMap);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
            record.setMsgTitle(msgTitle);
            record.setSendTime(new Date());
            record.setCreateBy(sendAccount.getRealname());
            record.setCreateTime(new Date());
            record.setHandleFlag("0");
            String msgContent = item.getMsgContent();
            if (StrUtil.isNotBlank((CharSequence)msgContent)) {
                if (msg.getParams() != null) {
                    paramsMap.put("realname", account.getRealname());
                    msgContent = TemplateParseUtil.getTemplateText((String)"", (String)msgContent, paramsMap);
                }
                record.setMsgContent(msgContent);
            }
            if (StrUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                if (StrUtil.isNotBlank((CharSequence)msg.getUrlParam())) {
                    record.setLinkUrl(item.getLinkUrl().trim() + "?" + msg.getUrlParam());
                } else {
                    record.setLinkUrl(TemplateParseUtil.getTemplateText((String)"", (String)item.getLinkUrl(), paramsMap));
                }
            }
            ElsMsgRecordService msgRecordService = (ElsMsgRecordService)SpringContextUtils.getBean(ElsMsgRecordServiceImpl.class);
            msgRecordService.save((Object)record);
            log.info("InstationMsgImpl\u7ad9\u5185\u4fe1\u53d1\u9001\u5b8c\u6bd5");
        }
        catch (Exception e) {
            log.error("InstationMsgImpl\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }
}

