/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.extend.api.message.dto.SmsMsgDTO;
import com.els.modules.extend.api.message.enumerate.RafflesSmsTypeEnum;
import com.els.modules.message.handle.SmsMsgService;
import com.els.modules.message.handle.enums.SmsSendTemplateTypeEnum;
import com.els.modules.message.rpc.service.MessageInvokeBaseService;
import com.els.modules.message.vo.SmsMsgVO;
import com.els.rpc.service.InvokeBaseRpcService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SmsMsgServiceImpl
implements SmsMsgService {
    private static final Logger log = LoggerFactory.getLogger(SmsMsgServiceImpl.class);
    @Resource
    private MessageInvokeBaseService messageInvokeBaseService;

    @Override
    public void sendSms(SmsMsgVO msgVO) {
        log.info("SmsMsgServiceImpl\u51c6\u5907\u6267\u884c\u53d1\u9001SMS\u7684\u903b\u8f91.");
        ElsSubAccountDTO account = msgVO.getAccount();
        if (StringUtils.isNotBlank((CharSequence)msgVO.getType()) && account != null && StringUtils.isNotBlank((CharSequence)account.getPhone())) {
            if ("1".equals(this.messageInvokeBaseService.getUseAliyunMobChannelValue())) {
                this.sendRafflesSmsMsg(msgVO, account);
            } else {
                this.send(msgVO, account);
            }
        }
    }

    private void sendRafflesSmsMsg(SmsMsgVO msgVO, ElsSubAccountDTO account) {
        log.info("SmsMsgServiceImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u6765\u798f\u58ebSMS\u7684\u903b\u8f91.");
        SmsMsgDTO smsMsgDTO = new SmsMsgDTO();
        SysUtil.copyProperties((Object)msgVO, (Object)smsMsgDTO);
        smsMsgDTO.setPhone(account.getPhone());
        if (!"1".equals(msgVO.getIsDefault())) {
            smsMsgDTO.setSmsType(RafflesSmsTypeEnum.VERIFICATION_CODE.getValue());
        } else {
            smsMsgDTO.setSmsType(RafflesSmsTypeEnum.NOTICE_TYPE.getValue());
        }
        this.messageInvokeBaseService.sendRafflesSmsMsg(smsMsgDTO);
    }

    public void send(SmsMsgVO msgVO, ElsSubAccountDTO account) {
        if (!"1".equals(msgVO.getIsDefault())) {
            JSONObject obj = msgVO.getObject();
            String code = obj.getString("code");
            JSONObject jsonObject = this.messageInvokeBaseService.sendSmsVerification(account.getPhone(), code);
            JSONObject data = jsonObject.getJSONObject("data");
            boolean b = data.getBoolean("status");
            if (b) {
                log.info("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f\uff01phone={}, code={}", (Object)account.getPhone(), (Object)code);
            } else {
                log.error("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25\uff01msg={}", (Object)jsonObject.getString("msg"));
            }
        } else {
            JSONObject requestJSON = new JSONObject();
            requestJSON.put("phone", (Object)account.getPhone());
            requestJSON.put("currentAccount", (Object)TenantContext.getTenant());
            JSONObject obj = new JSONObject();
            obj.put("sendCompany", (Object)msgVO.getSendCompany());
            obj.put("receiveCompany", (Object)msgVO.getReceiveCompany());
            requestJSON.put("content", (Object)obj);
            try {
                InvokeBaseRpcService invokeBaseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
                if (SmsSendTemplateTypeEnum.CHAT.getValue().equals(msgVO.getType()) || SmsSendTemplateTypeEnum.ORDER.getValue().equals(msgVO.getType())) {
                    invokeBaseRpcService.callIPaasInterface(requestJSON, "valueAddedApplication", invokeBaseRpcService.getIpaasInterfaceCode("chatandorder-inform-sms"));
                }
                if (SmsSendTemplateTypeEnum.SUPPLIER.getValue().equals(msgVO.getType())) {
                    obj = new JSONObject();
                    obj.put("purchaseName", (Object)msgVO.getSendCompany());
                    obj.put("supplierName", (Object)account.getRealname());
                    obj.put("purchaseElsAccount", (Object)TenantContext.getTenant());
                    requestJSON.put("content", (Object)obj);
                    invokeBaseRpcService.callIPaasInterface(requestJSON, "valueAddedApplication", invokeBaseRpcService.getIpaasInterfaceCode("turnpotential-inform-sms"));
                }
                if (SmsSendTemplateTypeEnum.INQUIRY.getValue().equals(msgVO.getType())) {
                    invokeBaseRpcService.callIPaasInterface(requestJSON, "valueAddedApplication", invokeBaseRpcService.getIpaasInterfaceCode("enquiry-inform-sms"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

