/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.base.api.enumerate.MailProtocolType;
import com.els.modules.message.entity.ElsEmailConfig;
import com.els.modules.message.mapper.ElsEmailConfigExtendMapper;
import com.els.modules.message.service.ElsEmailConfigExtendService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ElsEmailConfigExtendServiceImpl
extends BaseServiceImpl<ElsEmailConfigExtendMapper, ElsEmailConfig>
implements ElsEmailConfigExtendService {
    private static final Logger log = LoggerFactory.getLogger(ElsEmailConfigExtendServiceImpl.class);

    private boolean sendEmailCheck(ElsEmailConfig config) {
        try {
            if ("1".equals(config.getRafflesStatus())) {
                this.sendSmtp(config);
            } else {
                ElsEmailBuilder.sendEmailWithEp((ElsEmailConfigDTO)((ElsEmailConfigDTO)Convert.convert(ElsEmailConfigDTO.class, (Object)((Object)config))), (String)config.getTestEmail(), (String)"SRM Email Setting Test!", (String)"SRM Email Setting Test!", (String)config.getEmailCc(), (boolean)CharSequenceUtil.isNotBlank((CharSequence)config.getEmailCc()));
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(Arrays.toString(e.getStackTrace()));
            log.error("\u90ae\u7bb1\u53d1\u9001\u62a5\u9519\uff1a" + e.getMessage());
            String message = CharSequenceUtil.emptyToDefault((CharSequence)e.getMessage(), (String)"");
            if (message.contains("Connection timed out")) {
                config.setErrorMsg(I18nUtil.translate((String)"i18n_alert_KyBKVImERjUROVnAPTWKQjiH_cfd799c2", (String)"\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u7684\u57df\u540d\u3001\u7aef\u53e3\u548c\u5f53\u524d\u7f51\u7edc\u662f\u5426\u6709\u6b63\u5e38") + ":" + message);
            } else if (message.contains("AuthenticationFailedException")) {
                config.setErrorMsg(I18nUtil.translate((String)"i18n_alert_lbKmVImeywoKQiR_7a8b150e", (String)"\u6388\u6743\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8d26\u53f7\u3001\u5bc6\u7801\u662f\u5426\u6b63\u786e") + ":" + message);
            } else {
                config.setErrorMsg(message);
            }
            return false;
        }
    }

    private void emailSetting(ElsEmailConfig elsEmailConfig) {
        elsEmailConfig.setEnabled("0");
        if (null == elsEmailConfig.getWeight()) {
            elsEmailConfig.setWeight(100);
        }
        if (null == elsEmailConfig.getSortOrder()) {
            elsEmailConfig.setSortOrder(0);
        }
        if (null == elsEmailConfig.getEmailPort() && !MailProtocolType.exchange.getType().equals(elsEmailConfig.getType())) {
            elsEmailConfig.setEmailPort(25);
        }
        if ("enabled".equals(elsEmailConfig.getStatus())) {
            boolean check = this.sendEmailCheck(elsEmailConfig);
            elsEmailConfig.setEnabled(check ? "1" : "0");
        }
    }

    @Override
    public String add(ElsEmailConfig elsEmailConfig) {
        this.emailSetting(elsEmailConfig);
        String msg = elsEmailConfig.getErrorMsg();
        ((ElsEmailConfigExtendMapper)this.baseMapper).insert((Object)elsEmailConfig);
        return msg;
    }

    @Override
    public String edit(ElsEmailConfig elsEmailConfig) {
        this.emailSetting(elsEmailConfig);
        String msg = elsEmailConfig.getErrorMsg();
        int count = ((ElsEmailConfigExtendMapper)this.baseMapper).updateById((Object)elsEmailConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        return msg;
    }

    @Override
    public void delete(String id) {
        ((ElsEmailConfigExtendMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsEmailConfigExtendMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsEmailConfigDTO getEmailConfig(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsEmailConfig::getStatus, (Object)"enabled")).eq(ElsEmailConfig::getEnabled, (Object)"1")).orderByDesc(ElsEmailConfig::getWeight)).last(" limit 1");
        ElsEmailConfig elsEmailConfig = (ElsEmailConfig)((Object)((ElsEmailConfigExtendMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == elsEmailConfig && !"100000".equals(elsAccount)) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)"100000")).eq(ElsEmailConfig::getStatus, (Object)"enabled")).eq(ElsEmailConfig::getEnabled, (Object)"1")).orderByDesc(ElsEmailConfig::getWeight)).last(" limit 1");
            elsEmailConfig = (ElsEmailConfig)((Object)((ElsEmailConfigExtendMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        }
        return (ElsEmailConfigDTO)Convert.convert(ElsEmailConfigDTO.class, (Object)((Object)elsEmailConfig));
    }

    @Override
    public List<ElsEmailConfig> getEmailConfigs(String elsAccount) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsEmailConfig::getStatus, (Object)"enabled")).eq(ElsEmailConfig::getEnabled, (Object)"1")).orderByDesc(ElsEmailConfig::getWeight);
        List elsEmailConfigs = ((ElsEmailConfigExtendMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)elsEmailConfigs) && !"100000".equals(elsAccount)) {
            wrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseEntity::getElsAccount, (Object)"100000")).eq(ElsEmailConfig::getStatus, (Object)"enabled")).eq(ElsEmailConfig::getEnabled, (Object)"1")).orderByDesc(ElsEmailConfig::getWeight);
            elsEmailConfigs = ((ElsEmailConfigExtendMapper)this.baseMapper).selectList((Wrapper)wrapper);
        }
        Collections.shuffle(elsEmailConfigs);
        return elsEmailConfigs;
    }

    @Override
    public void sendLicenseAlert(String ccEmail, String expireDate) {
    }

    private boolean sendMessage(JavaMailSender mailSender, MimeMessage message) {
        try {
            mailSender.send(message);
            return true;
        }
        catch (Exception e) {
            log.error("EmailSendMsgImpl==>sendMessage:{}", (Object)e.getMessage());
            return false;
        }
    }

    private void sendSmtp(ElsEmailConfig config) throws MessagingException {
        String smtp = config.getEmailHost();
        final String userName = config.getEmailUsername().substring(0, config.getEmailUsername().indexOf("@"));
        final String password = config.getEmailPassword();
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", smtp);
        props.put("mail.smtp.port", config.getEmailPort());
        props.put("mail.smtp.auth", "true");
        props.put("mail.debug", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.starttls.required", "true");
        props.put("mail.smtp.ssl.trust", smtp);
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password);
            }
        });
        session.setDebug(true);
        MimeMessage msg = new MimeMessage(session);
        msg.setSubject("SRM Email Setting Test!", "UTF-8");
        msg.setFrom((Address)new InternetAddress(config.getEmailUsername()));
        msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternetAddress.parse((String)config.getTestEmail()));
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)"SRM Email Setting Test!", "text/html;charset=utf-8");
        multipart.addBodyPart((BodyPart)textPart);
        msg.setContent((Multipart)multipart);
        Transport.send((Message)msg);
    }
}

