/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.util;

import cn.hutool.extra.mail.Mail;
import cn.hutool.extra.mail.MailAccount;
import com.els.api.dto.ElsEmailConfigDTO;
import com.sun.mail.util.MailSSLSocketFactory;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RafflesSendEmailUtil {
    private static final Logger log = LoggerFactory.getLogger(RafflesSendEmailUtil.class);

    public static void sendMail(ElsEmailConfigDTO emailConfigDTO) throws Exception {
        log.info("====>emailConfigDTO:{}", (Object)emailConfigDTO);
        String smtp = emailConfigDTO.getEmailHost();
        log.info("====>emailHost:" + smtp);
        final String userName = emailConfigDTO.getEmailUsername().substring(0, emailConfigDTO.getEmailUsername().indexOf("@"));
        final String password = emailConfigDTO.getEmailPassword();
        for (String to : emailConfigDTO.getTo()) {
            log.info("====>to:" + to);
            Properties props = new Properties();
            props.setProperty("mail.transport.protocol", emailConfigDTO.getProtocol());
            props.put("mail.smtp.host", smtp);
            props.put("mail.smtp.port", emailConfigDTO.getEmailPort());
            props.put("mail.smtp.auth", "true");
            props.put("mail.debug", "true");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.starttls.required", "true");
            props.put("mail.smtp.ssl.trust", smtp);
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userName, password);
                }
            });
            session.setDebug(true);
            MimeMessage msg = new MimeMessage(session);
            msg.setSubject(emailConfigDTO.getSubject(), "UTF-8");
            msg.setFrom((Address)new InternetAddress(emailConfigDTO.getEmailUsername()));
            msg.setRecipients(MimeMessage.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setContent((Object)emailConfigDTO.getContent(), "text/html;charset=utf-8");
            multipart.addBodyPart((BodyPart)textPart);
            msg.setContent((Multipart)multipart);
            Transport.send((Message)msg);
        }
    }

    public static void sendEmail(ElsEmailConfigDTO emailConfigDTO) throws Exception {
        MailAccount mailAccount = new MailAccount();
        mailAccount.setHost(emailConfigDTO.getEmailHost());
        mailAccount.setPort(emailConfigDTO.getEmailPort());
        mailAccount.setCustomProperty("mail.transport.protocol", (Object)emailConfigDTO.getProtocol());
        mailAccount.setFrom(emailConfigDTO.getEmailUsername());
        String userName = emailConfigDTO.getEmailUsername().substring(0, emailConfigDTO.getEmailUsername().indexOf("@"));
        mailAccount.setUser(userName);
        mailAccount.setPass(emailConfigDTO.getEmailPassword());
        mailAccount.setAuth(true);
        mailAccount.setSslEnable(Boolean.valueOf(true));
        MailSSLSocketFactory sf = new MailSSLSocketFactory();
        sf.setTrustAllHosts(true);
        mailAccount.setCustomProperty("mail.smtp.ssl.socketFactory", (Object)sf);
        Mail.create((MailAccount)mailAccount).setTos(emailConfigDTO.getTo()).setTitle(emailConfigDTO.getSubject()).setContent(emailConfigDTO.getContent()).setHtml(true).send();
    }

    public static void main(String[] args) {
        ElsEmailConfigDTO config = new ElsEmailConfigDTO();
        config.setEmailHost("mail.cimc-raffles.com");
        config.setEmailPort(Integer.valueOf(2525));
        config.setEmailUsername("yias@cimc-raffles.com");
        config.setEmailPassword("456@Aa654");
        config.setTo(new String[]{"583746487@qq.com"});
        config.setSubject("Srm Test Email!");
        config.setContent("Srm Test Email!");
        config.setProtocol("smtp");
        try {
            RafflesSendEmailUtil.sendMail(config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

