/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.listener;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.log.entity.Log;
import com.els.modules.log.entity.LogDetail;
import com.els.modules.log.service.LogDetailService;
import com.els.modules.log.service.LogService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class LogMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(LogMessageConsumer.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private LogService logService;
    @Resource
    private LogDetailService logDetailService;

    @Bean(value={"inputLog"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String msgBody = (String)message.getPayload();
            log.info("receive log:" + msgBody);
            try {
                Log log = (Log)JSONObject.parseObject((String)msgBody, Log.class);
                LogDetail detail = new LogDetail();
                detail.setRequestParam(log.getRequestParam());
                detail.setResponseParam(log.getResponseParam());
                detail.setElsAccount(log.getElsAccount());
                log.setRequestParam(null);
                log.setResponseParam(null);
                this.logService.save(log);
                detail.setHeadId(log.getId());
                this.logDetailService.save(detail);
            }
            catch (Exception e) {
                log.error("save log failed:", (Throwable)e);
            }
        };
    }
}

