/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.message.handle.SmsMsgService;
import com.els.modules.message.handle.enums.SmsSendTemplateTypeEnum;
import com.els.modules.message.util.DySmsHelper;
import com.els.modules.message.vo.SmsMsgVO;
import com.els.rpc.service.InvokeBaseRpcService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SmsMsgServiceImpl
implements SmsMsgService {
    private static final Logger log = LoggerFactory.getLogger(SmsMsgServiceImpl.class);

    @Override
    public void sendSms(SmsMsgVO msgVO) {
        log.error("SmsMsgServiceImpl\u51c6\u5907\u6267\u884c\u53d1\u9001SMS\u7684\u903b\u8f91.");
        ElsSubAccountDTO account = msgVO.getAccount();
        if (StringUtils.isNotBlank((CharSequence)msgVO.getType()) && account != null && StringUtils.isNotBlank((CharSequence)account.getPhone())) {
            this.send(msgVO, account);
        }
    }

    public void send(SmsMsgVO msgVO, ElsSubAccountDTO account) {
        if (!"1".equals(msgVO.getIsDefault())) {
            JSONObject obj = msgVO.getObject();
            try {
                DySmsHelper.sendTemplateSms(account.getPhone(), obj, msgVO.getSmsTitle(), msgVO.getSmsCode());
            }
            catch (ClientException clientException) {}
        } else {
            JSONObject requestJSON = new JSONObject();
            requestJSON.put("phone", (Object)account.getPhone());
            requestJSON.put("currentAccount", (Object)TenantContext.getTenant());
            JSONObject obj = new JSONObject();
            obj.put("sendCompany", (Object)msgVO.getSendCompany());
            obj.put("receiveCompany", (Object)msgVO.getReceiveCompany());
            requestJSON.put("content", (Object)obj);
            try {
                InvokeBaseRpcService invokeBaseRpcService = (InvokeBaseRpcService)SpringContextUtils.getBean(InvokeBaseRpcService.class);
                if (SmsSendTemplateTypeEnum.CHAT.getValue().equals(msgVO.getType()) || SmsSendTemplateTypeEnum.ORDER.getValue().equals(msgVO.getType())) {
                    invokeBaseRpcService.callIPaasInterface(requestJSON, "valueAddedApplication", invokeBaseRpcService.getIpaasInterfaceCode("chatandorder-inform-sms"));
                }
                if (SmsSendTemplateTypeEnum.SUPPLIER.getValue().equals(msgVO.getType())) {
                    obj = new JSONObject();
                    obj.put("purchaseName", (Object)msgVO.getSendCompany());
                    obj.put("supplierName", (Object)account.getRealname());
                    obj.put("purchaseElsAccount", (Object)TenantContext.getTenant());
                    requestJSON.put("content", (Object)obj);
                    invokeBaseRpcService.callIPaasInterface(requestJSON, "valueAddedApplication", invokeBaseRpcService.getIpaasInterfaceCode("turnpotential-inform-sms"));
                }
                if (SmsSendTemplateTypeEnum.INQUIRY.getValue().equals(msgVO.getType())) {
                    invokeBaseRpcService.callIPaasInterface(requestJSON, "valueAddedApplication", invokeBaseRpcService.getIpaasInterfaceCode("enquiry-inform-sms"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

