/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.api.dto.ElsEmailSendLogDto;
import com.els.api.dto.EmailSendRebuildDto;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.email.sender.ElsMailSender;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.config.StaticConfig;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.enumerate.MsgNoticeObjectEnum;
import com.els.modules.message.handle.ISendMsgService;
import com.els.modules.message.handle.enums.ReceiveTypeEnum;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.rpc.service.BusinessDataRpcService;
import com.els.modules.message.rpc.service.MessageInvokeAccountService;
import com.els.modules.message.rpc.service.MessageInvokeBaseService;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.service.MsgObjScriptService;
import com.els.modules.message.service.MsgService;
import com.els.modules.message.util.MessageHandleFactory;
import com.els.modules.message.util.MsgGroovyFactory;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.EmailRpcPersistence;
import com.els.rpc.service.InvokeAccountRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MsgServiceImpl
implements MsgService {
    private static final Logger log = LoggerFactory.getLogger(MsgServiceImpl.class);
    @Resource
    private ElsMsgConfigHeadService elsMsgConfigHeadService;
    @Resource
    private ElsMsgConfigItemService elsMsgConfigItemService;
    @Resource
    private MessageInvokeAccountService accountDubboService;

    private List<String> processData(List<PersonalSettingDTO> personalSettings) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SendMsgTypeEnum.IN_MSG.getType());
        for (PersonalSettingDTO personalSetting : personalSettings) {
            if (ReceiveTypeEnum.EMAIL.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.EMAIL.getType());
                continue;
            }
            if (ReceiveTypeEnum.MSG.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.SMS.getType());
                continue;
            }
            if (ReceiveTypeEnum.NEWS.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.IN_MSG.getType());
                continue;
            }
            if (ReceiveTypeEnum.WECHAT.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.WX.getType());
                list.add(SendMsgTypeEnum.WX_GROUP.getType());
                continue;
            }
            if (ReceiveTypeEnum.WECHAT_EP.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.WX_EP.getType());
                list.add(SendMsgTypeEnum.WX_EP_DEVELOP.getType());
                continue;
            }
            if (ReceiveTypeEnum.DINGTALK.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.DINGTALK.getType());
                continue;
            }
            if (!ReceiveTypeEnum.FEISHU.getValue().equals(personalSetting.getReceiveType())) continue;
            list.add(SendMsgTypeEnum.FEISHU.getType());
        }
        return list;
    }

    private ElsMsgConfigHead getMsgConfigHead(String busAccount, String businessType, String operateType) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)businessType)).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).eq(BaseEntity::getElsAccount, (Object)busAccount)).last("limit 1");
        ElsMsgConfigHead configHead = (ElsMsgConfigHead)((Object)this.elsMsgConfigHeadService.getOne((Wrapper)queryWrapper));
        if (configHead == null) {
            queryWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)businessType)).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).eq(BaseEntity::getElsAccount, (Object)"100000")).last("limit 1");
            configHead = (ElsMsgConfigHead)((Object)this.elsMsgConfigHeadService.getOne((Wrapper)queryWrapper));
        }
        if (configHead == null) {
            queryWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)"systemSrm")).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).eq(BaseEntity::getElsAccount, (Object)"100000")).last("limit 1");
            configHead = (ElsMsgConfigHead)((Object)this.elsMsgConfigHeadService.getOne((Wrapper)queryWrapper));
        }
        return configHead;
    }

    private List<ElsMsgConfigItem> getMsgConfigItemListByBusAccount(String headId, String busAccount, String businessType, String operateType) {
        List<Object> resultList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)headId) && !(resultList = this.elsMsgConfigItemService.selectByMainId(headId)).isEmpty()) {
            return resultList;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)businessType)).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).eq(BaseEntity::getElsAccount, (Object)busAccount)).eq(ElsMsgConfigHead::getStatus, (Object)"1")).orderByDesc(BaseEntity::getUpdateTime);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)configHeadList)) {
            return Lists.newArrayList();
        }
        List<ElsMsgConfigItem> configItemList = this.elsMsgConfigItemService.selectByMainId(((ElsMsgConfigHead)((Object)configHeadList.get(0))).getId());
        HashMap<String, String> distinctMap = new HashMap<String, String>();
        for (ElsMsgConfigItem item : configItemList) {
            if (distinctMap.containsKey(item.getMsgType())) continue;
            resultList.add((Object)item);
            distinctMap.put(item.getMsgType(), item.getMsgType());
        }
        return resultList;
    }

    private List<ElsMsgConfigItem> getMsgConfigItemList(String headId, List<String> busAccountList, String businessType, String operateType) {
        List resultList;
        if (StrUtil.isNotBlank((CharSequence)headId) && !(resultList = this.elsMsgConfigItemService.selectByMainId(headId)).isEmpty()) {
            return resultList;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)businessType)).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).eq(ElsMsgConfigHead::getStatus, (Object)"1")).in(BaseEntity::getElsAccount, busAccountList)).orderByDesc(BaseEntity::getUpdateTime);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)configHeadList)) {
            queryWrapper.clear();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)"systemSrm")).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).eq(ElsMsgConfigHead::getStatus, (Object)"1")).in(BaseEntity::getElsAccount, busAccountList)).orderByDesc(BaseEntity::getUpdateTime);
            configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        }
        Assert.notEmpty((Collection)configHeadList, (String)I18nUtil.translate((String)"", (String)(businessType + "_" + operateType + ":\u672a\u627e\u5230\u542f\u7528\u7684\u6d88\u606f\u914d\u7f6e\uff01")));
        Collection values = configHeadList.stream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity(), (v1, v2) -> v1)).values();
        List headIdList = values.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(ElsMsgConfigItem::getHeadId, headIdList);
        resultList = this.elsMsgConfigItemService.list((Wrapper)wrapper);
        return resultList;
    }

    private List<String> getOneToManyBusinessType() {
        return Lists.newArrayList((Object[])new String[]{"enquiry_publish", "enquiry_confirm"});
    }

    private void buildMsg(JSONObject msg) {
        try {
            String businessId = msg.getString("businessId");
            String businessBean = msg.getString("businessBean");
            String businessType = msg.getString("businessType") + "_" + msg.getString("operateType");
            if (CharSequenceUtil.isNotEmpty((CharSequence)businessId) && CharSequenceUtil.isNotEmpty((CharSequence)businessBean)) {
                JSONObject busObj = ((BusinessDataRpcService)SpringContextUtils.getBean(BusinessDataRpcService.class)).getRpcService(businessBean).getBusinessDataById(businessId);
                msg.put("businessObj", (Object)busObj);
                if (this.getOneToManyBusinessType().contains(businessType)) {
                    Map dataMapById = ((BusinessDataRpcService)SpringContextUtils.getBean(BusinessDataRpcService.class)).getRpcService(businessBean).getOneToManyBusinessDataMapById(businessId);
                    msg.put("businessObjMap", (Object)dataMapById);
                }
            }
            JSONObject businessObj = msg.getJSONObject("businessObj");
            String busAccount = msg.getString("busAccount");
            JSONArray toElsAccountArray = msg.getJSONArray("toElsAccountList");
            if (null == toElsAccountArray || toElsAccountArray.isEmpty()) {
                log.error("\u53d1\u9001\u6d88\u606ftoElsAccountList\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u6392\u67e5\u4e1a\u52a1\u662f\u5426\u9700\u8981\u5f53\u524d\u53c2\u6570");
                return;
            }
            ElsMsgConfigHead configHead = this.getMsgConfigHead(busAccount, msg.getString("businessType"), msg.getString("operateType"));
            InvokeAccountRpcService accountRpcService = (InvokeAccountRpcService)SpringContextUtils.getBean(InvokeAccountRpcService.class);
            JSONArray receiveArray = new JSONArray();
            ArrayList<String> userIdList = new ArrayList<String>();
            for (Object obj : toElsAccountArray) {
                ElsSubAccountDTO subAccount;
                MsgObjScriptService scriptService;
                String principal;
                String createById;
                String toElsAccount = (String)obj;
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)toElsAccount);
                ArrayList<ElsSubAccountDTO> subAccountList = null;
                String noticeObj = null;
                String script = null;
                String principalCode = "purchasePrincipal";
                if (busAccount.equals(toElsAccount)) {
                    noticeObj = configHead == null ? "" : configHead.getPurchaseNoticeObj();
                    script = configHead == null ? "" : configHead.getPurchaseScript();
                } else {
                    noticeObj = configHead == null ? "" : configHead.getSaleNoticeObj();
                    script = configHead == null ? "" : configHead.getSaleScript();
                    principalCode = "salePrincipal";
                }
                if (noticeObj == null) {
                    noticeObj = "";
                }
                if (noticeObj.contains(MsgNoticeObjectEnum.CREATE_BY.getValue()) && StrUtil.isNotBlank((CharSequence)(createById = businessObj.getString("createById")))) {
                    userIdList.add(createById);
                }
                if (noticeObj.contains(MsgNoticeObjectEnum.PRINCIPAL_BY.getValue()) && StrUtil.isNotBlank((CharSequence)(principal = businessObj.getString(principalCode)))) {
                    String target = principal.split("_")[0];
                    if (this.isId(target)) {
                        userIdList.add(target);
                    } else {
                        ElsSubAccountDTO subAccount2 = accountRpcService.getAccount(toElsAccount, target);
                        userIdList.add(subAccount2.getId());
                    }
                }
                if (noticeObj.contains(MsgNoticeObjectEnum.ASSIGNEE.getValue()) && configHead != null && StrUtil.isNotBlank((CharSequence)configHead.getPurchaseAssignee())) {
                    userIdList.addAll(Arrays.asList(configHead.getPurchaseAssignee().split(",")));
                }
                if (noticeObj.contains(MsgNoticeObjectEnum.SCRIPT.getValue()) && StrUtil.isNotBlank((CharSequence)script) && (scriptService = MsgGroovyFactory.getInstance().getMsgObjScriptServiceFromCode(script)) != null) {
                    userIdList.addAll(scriptService.getUserIdByScript(businessObj));
                }
                if (noticeObj.contains(MsgNoticeObjectEnum.JOB_FUNCTION.getValue()) && configHead != null && StrUtil.isNotBlank((CharSequence)configHead.getJobFunction())) {
                    CoreInvokeSupplierRpcService supplierRpcService = (CoreInvokeSupplierRpcService)SpringContextUtils.getBean(CoreInvokeSupplierRpcService.class);
                    userIdList.addAll(supplierRpcService.getUserIdByJobFunction(configHead.getJobFunction(), busAccount, toElsAccount));
                }
                log.info("MsgServiceImpl sendElsAccount:{},userIdList:{},businessBean:{}", new Object[]{obj, userIdList, businessBean});
                if (!userIdList.isEmpty()) {
                    subAccountList = accountRpcService.getAccountById(userIdList);
                }
                if ((subAccountList == null || subAccountList.isEmpty()) && (subAccount = accountRpcService.getAccount(toElsAccount, "1001")) != null) {
                    subAccountList = new ArrayList<ElsSubAccountDTO>();
                    subAccountList.add(subAccount);
                }
                if (subAccountList != null) {
                    JSONArray toSubAccountArray = JSONArray.parseArray((String)JSON.toJSONString((Object)subAccountList));
                    receiveObj.put("toSubAccountList", (Object)toSubAccountArray);
                }
                receiveArray.add((Object)receiveObj);
            }
            msg.put("receiveList", (Object)receiveArray);
        }
        catch (Exception e) {
            log.error("buildMsg_failed:" + msg.toJSONString(), (Throwable)e);
        }
    }

    @Override
    public void sendMsg(JSONObject msg) {
        if (msg.containsKey((Object)"msgId")) {
            this.buildMsg(msg);
        }
        String busAccount = msg.getString("busAccount");
        String businessType = msg.getString("businessType");
        String operateType = msg.getString("operateType");
        String msgConfigHeadId = msg.getString("msgConfigHeadId");
        String tempOperateType = operateType;
        if ((operateType.contains("submitAudit") || operateType.contains("resultSubmitAudit")) && operateType.contains(WorkFlowType.BPMN.getValue())) {
            tempOperateType = operateType.split("_")[1];
        }
        ArrayList busAccountList = Lists.newArrayList((Iterable)Sets.newHashSet((Object[])new String[]{"100000", busAccount}));
        List<ElsMsgConfigItem> configItemList = this.getMsgConfigItemList(msgConfigHeadId, busAccountList, businessType, tempOperateType);
        if (operateType.contains("submitAudit") && operateType.contains(WorkFlowType.BPMN.getValue())) {
            String link = null;
            BaseRpcService baseRpcService = (BaseRpcService)SpringContextUtils.getBean(BaseRpcService.class);
            List todoListLink = baseRpcService.queryDictItemsByCode("todo_list_link", busAccount);
            Map<String, String> todoListLinkMap = todoListLink.stream().collect(Collectors.toMap(DictDTO::getText, DictDTO::getValue));
            link = operateType.contains(WorkFlowType.BPMN.getValue()) ? todoListLinkMap.get(WorkFlowType.BPMN.getValue()) : todoListLinkMap.get(WorkFlowType.UFLO.getValue());
            ElsMsgConfigItem elsMsgConfigItem = configItemList.get(0);
            elsMsgConfigItem.setLinkUrl(link);
        }
        JSONObject businessObj = msg.getJSONObject("businessObj");
        Map businessObjMap = (Map)msg.getObject("businessObjMap", Map.class);
        ElsSubAccountDTO sendAccount = (ElsSubAccountDTO)msg.getObject("sendObj", ElsSubAccountDTO.class);
        JSONArray receiveArray = msg.getJSONArray("receiveList");
        for (Object obj : receiveArray) {
            JSONObject receiveObj = (JSONObject)obj;
            String toElsAccount = receiveObj.getString("toElsAccount");
            String urlParam = receiveObj.getString("urlParam");
            JSONArray toSubAccountArray = receiveObj.getJSONArray("toSubAccountList");
            for (Object subObj : toSubAccountArray) {
                List<ElsMsgConfigItem> receiveAccountItemList;
                ElsSubAccountDTO receive = (ElsSubAccountDTO)JSONObject.parseObject((String)((JSONObject)subObj).toJSONString(), ElsSubAccountDTO.class);
                ArrayList<ElsMsgConfigItem> currentConfigItemList = new ArrayList<ElsMsgConfigItem>(configItemList);
                if (CharSequenceUtil.isEmpty((CharSequence)msgConfigHeadId) && !busAccountList.contains(receive.getElsAccount()) && CollectionUtil.isNotEmpty(receiveAccountItemList = this.getMsgConfigItemListByBusAccount(msgConfigHeadId, receive.getElsAccount(), businessType, tempOperateType))) {
                    currentConfigItemList.addAll(receiveAccountItemList);
                }
                List<PersonalSettingDTO> personalSettings = this.accountDubboService.getPersonalSetting(toElsAccount, receive.getSubAccount());
                List<String> list = this.processData(personalSettings);
                Map itemTypeMap = currentConfigItemList.stream().collect(Collectors.groupingBy(ElsMsgConfigItem::getMsgType, Collectors.groupingBy(BaseEntity::getElsAccount, Collectors.toList())));
                if (itemTypeMap.containsKey(SendMsgTypeEnum.WX_EP.getType())) {
                    itemTypeMap.put(SendMsgTypeEnum.WX_EP_DEVELOP.getType(), itemTypeMap.get(SendMsgTypeEnum.WX_EP.getType()));
                }
                Map<String, List<ElsMsgConfigItem>> msgItemAccountMap = currentConfigItemList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
                log.info("\u51c6\u5907\u53d1\u9001\u7684\u6d88\u606f\u7c7b\u578b:{}", list);
                JSONObject tembBusinessObj = null;
                if (null != businessObjMap) {
                    tembBusinessObj = (JSONObject)businessObjMap.get(toElsAccount);
                }
                for (String type : itemTypeMap.keySet()) {
                    if (!list.contains(type)) continue;
                    try {
                        ISendMsgService sendMsgHandle = MessageHandleFactory.getMsgHandle(type);
                        MsgVO msgVO = new MsgVO();
                        msgVO.setElsMsgConfigItem(itemTypeMap.get(type));
                        msgVO.setMsgItemAccountMap(msgItemAccountMap);
                        msgVO.setReceiveAccount(receive);
                        msgVO.setSendAccount(sendAccount);
                        if (null != tembBusinessObj) {
                            msgVO.setParams(tembBusinessObj);
                        } else {
                            msgVO.setParams(businessObj);
                        }
                        msgVO.setUrlParam(urlParam);
                        msgVO.setBusinessType(businessType);
                        msgVO.setOperateType(operateType);
                        msgVO.setBusAccount(busAccount);
                        msgVO.setToElsAccount(toElsAccount);
                        msgVO.setMsgType(type);
                        sendMsgHandle.sendMsg(msgVO);
                    }
                    catch (Exception e) {
                        log.error("MsgServiceImpl-sendMsg,type:{},data:{},error:{}", new Object[]{type, msg.toJSONString(), e.getMessage()});
                    }
                }
            }
        }
    }

    @Override
    public void retrySendEmail(ElsEmailSendLogDto sendLogDto) {
        if (CharSequenceUtil.isNotEmpty((CharSequence)sendLogDto.getMsgItemConfigContent())) {
            this.sendByItemConfig(sendLogDto);
        } else {
            String msgConfigContent = sendLogDto.getMsgConfigContent();
            if (CharSequenceUtil.isEmpty((CharSequence)msgConfigContent)) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u90ae\u4ef6\u53d1\u9001\u8bb0\u5f55\u4fe1\u606f\u6709\u8bef\uff0c\u65e0\u6cd5\u91cd\u8bd5"));
            }
            ElsEmailConfigDTO config = (ElsEmailConfigDTO)JSON.parseObject((String)msgConfigContent, ElsEmailConfigDTO.class);
            config.setSendLogId(sendLogDto.getSendLogId());
            EmailRpcPersistence retrySendBuilder = (EmailRpcPersistence)SpringContextUtils.getBean(EmailRpcPersistence.class);
            EmailSendRebuildDto rebuildVo = retrySendBuilder.rebuildToSend(config, sendLogDto);
            if (null == rebuildVo) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u670d\u52a1\u5668\u90ae\u4ef6\u53d1\u9001\u91cd\u8bd5\u903b\u8f91\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5"));
            }
            if (rebuildVo.isFlag()) {
                return;
            }
            config = rebuildVo.getConfigDTO();
            ElsMailSender mailSender = ElsEmailBuilder.buildElsMailSender((ElsEmailConfigDTO)config, null, null);
            mailSender.sendEmail(config, null);
        }
    }

    private void sendByItemConfig(ElsEmailSendLogDto sendLogDto) {
        log.info("## retrySendEmail\u51c6\u5907\u6267\u884c\u90ae\u4ef6\u91cd\u65b0\u53d1\u9001\u7684\u903b\u8f91, \u90ae\u4ef6\u53d1\u9001\u5931\u8d25\u8bb0\u5f55id:{}, \u5e8f\u5217id:{}", (Object)sendLogDto.getSendLogId(), (Object)sendLogDto.getSerializableId());
        MsgVO msg = (MsgVO)JSON.parseObject((String)sendLogDto.getMsgItemConfigContent(), MsgVO.class);
        ElsSubAccountDTO account = msg.getReceiveAccount();
        Map<String, List<ElsMsgConfigItem>> elsMsgConfigItem = msg.getElsMsgConfigItem();
        List<ElsMsgConfigItem> elsMsgConfigItems = elsMsgConfigItem.get(msg.getBusAccount());
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            elsMsgConfigItems = elsMsgConfigItem.get(msg.getToElsAccount());
            boolean configFlag = this.checkIfConfigByCurrentAccount(msg, msg.getBusAccount());
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && configFlag) {
                log.error("EmailSendMsgImpl\u5f53\u524d\u8d26\u53f7{}\u6ca1\u6709\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\u53d1\u9001:{}", (Object)msg.getBusAccount(), (Object)msg.toString());
                return;
            }
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && !configFlag) {
                elsMsgConfigItems = elsMsgConfigItem.get("100000");
            }
        }
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            return;
        }
        MessageInvokeBaseService messageInvokeBaseService = (MessageInvokeBaseService)SpringContextUtils.getBean(MessageInvokeBaseService.class);
        List<ElsEmailConfigDTO> emailConfigs = messageInvokeBaseService.getEmailConfigs(elsMsgConfigItems.get(0).getElsAccount());
        if (StrUtil.isEmpty((CharSequence)account.getEmail())) {
            log.error("EmailSendMsgImpl ==>::: \u6d88\u606f\u63a5\u6536\u65b9\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\uff0c\u65e0\u6cd5\u63a5\u6536\u90ae\u7bb1\u6d88\u606f,");
            return;
        }
        ElsMsgConfigItem item = elsMsgConfigItems.get(0);
        try {
            int size = emailConfigs.size();
            Integer index = 0;
            for (ElsEmailConfigDTO config : emailConfigs) {
                String ccEmail1;
                config.setSendLogId(sendLogDto.getSendLogId());
                config.setSubject(item.getMsgTitle());
                config.setTo(new String[]{account.getEmail()});
                String msgContent = item.getMsgContent();
                if (CharSequenceUtil.isNotBlank((CharSequence)msgContent)) {
                    if (msg.getParams() != null) {
                        JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                        if (CharSequenceUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                            object.put("audthUrl", (Object)this.getAuthUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), account));
                        }
                        msgContent = TemplateParseUtil.getTemplateText((String)"", (String)msgContent, (Map)object);
                    }
                    config.setContent(msgContent);
                }
                String string = ccEmail1 = CharSequenceUtil.isBlank((CharSequence)config.getEmailCc()) ? config.getEmailUsername() : config.getEmailCc();
                if (!"exception".equals(item.getMsgType())) {
                    config.setEmailCc(ccEmail1);
                }
                config.setAttachmentPathList(sendLogDto.getAttachmentPathList());
                config.setInlineAttachmentPathMap(sendLogDto.getInlineAttachmentPathMap());
                EmailRpcPersistence retrySendBuilder = (EmailRpcPersistence)SpringContextUtils.getBean(EmailRpcPersistence.class);
                EmailSendRebuildDto rebuildVo = retrySendBuilder.rebuildToSend(config, sendLogDto);
                if (null == rebuildVo) {
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u670d\u52a1\u5668\u90ae\u4ef6\u53d1\u9001\u91cd\u8bd5\u903b\u8f91\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5"));
                }
                if (rebuildVo.isFlag()) {
                    return;
                }
                config = rebuildVo.getConfigDTO();
                ElsMailSender mailSender = ElsEmailBuilder.buildElsMailSender((ElsEmailConfigDTO)config, null, null);
                config.setPersistenceWhileFailed(index == size - 1);
                boolean result = mailSender.sendEmail(config, null);
                if (result) {
                    log.info("\u5931\u8d25\u90ae\u4ef6\u53d1\u9001\u91cd\u8bd5 ==>:::\u53d1\u4ef6\u4eba:{}\u53d1\u9001\u90ae\u4ef6\u7ed9:{},end to send email...", (Object)config.getEmailUsername(), (Object)account.getEmail());
                    break;
                }
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
        }
        catch (Exception e) {
            log.error("sendByItemConfig ==>{}", (Object)e.getMessage());
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6d88\u606f\u7ec4\u4ef6\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
    }

    protected boolean checkIfConfigByCurrentAccount(MsgVO msg, String bussAccount) {
        Map<String, List<ElsMsgConfigItem>> msgItemAccountMap = msg.getMsgItemAccountMap();
        return msgItemAccountMap.containsKey(bussAccount);
    }

    private String getAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword()));
        return url.toString();
    }

    private boolean isId(String str) {
        return NumberUtil.isNumber((CharSequence)str) && str.length() == 19;
    }
}

