/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.util;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.els.common.util.I18nUtil;
import com.els.modules.message.config.SmsConfig;
import com.els.modules.message.util.DySmsEnum;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={SmsConfig.class})
public class DySmsHelper {
    private static final Logger log = LoggerFactory.getLogger(DySmsHelper.class);
    @Autowired
    private SmsConfig smsConfig;
    private static final Logger logger = LoggerFactory.getLogger(DySmsHelper.class);
    static String PRODUCT;
    static String DOMAIN;
    static String regionId;
    static String endpointName;
    static String accessKeyId;
    static String accessKeySecret;

    @PostConstruct
    void init() {
        accessKeyId = this.smsConfig.getAccessKeyId();
        accessKeySecret = this.smsConfig.getAccessKeySecret();
        DOMAIN = this.smsConfig.getDomain();
        PRODUCT = this.smsConfig.getProduct();
        regionId = this.smsConfig.getRegionId();
        endpointName = this.smsConfig.getEndpointName();
    }

    public static void setAccessKeyId(String accessKeyId) {
        DySmsHelper.accessKeyId = accessKeyId;
    }

    public static void setAccessKeySecret(String accessKeySecret) {
        DySmsHelper.accessKeySecret = accessKeySecret;
    }

    public static String getAccessKeyId() {
        return accessKeyId;
    }

    public static String getAccessKeySecret() {
        return accessKeySecret;
    }

    public static String getPRODUCT() {
        return PRODUCT;
    }

    public static void setPRODUCT(String pRODUCT) {
        PRODUCT = pRODUCT;
    }

    public static void setDOMAIN(String dOMAIN) {
        DOMAIN = dOMAIN;
    }

    public static String getDOMAIN() {
        return DOMAIN;
    }

    public static void setRegionId(String regionId) {
        DySmsHelper.regionId = regionId;
    }

    public static String getRegionId() {
        return regionId;
    }

    public static void setEndpointName(String endpointName) {
        DySmsHelper.endpointName = endpointName;
    }

    public static String getEndpointName() {
        return endpointName;
    }

    public static boolean sendSms(String phone, JSONObject templateParamJson, DySmsEnum dySmsEnum) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = null;
        log.error("accessKeyId:{},accessKeySecret:{},regionId:{},endpointName:{},PRODUCT:{},DOMAIN:{}", new Object[]{accessKeyId, accessKeySecret, regionId, endpointName, PRODUCT, DOMAIN});
        try {
            profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultProfile.addEndpoint((String)endpointName, (String)regionId, (String)PRODUCT, (String)DOMAIN);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(phone);
        request.setSignName(dySmsEnum.getSignName());
        request.setTemplateCode(dySmsEnum.getTemplateCode());
        request.setTemplateParam(templateParamJson.toJSONString());
        boolean result = false;
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        logger.info("\u77ed\u4fe1\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e----------------");
        logger.info("{Code:" + sendSmsResponse.getCode() + ",Message:" + sendSmsResponse.getMessage() + ",RequestId:" + sendSmsResponse.getRequestId() + ",BizId:" + sendSmsResponse.getBizId() + "}");
        if ("OK".equals(sendSmsResponse.getCode())) {
            result = true;
        }
        return result;
    }

    public static boolean sendTemplateSms(String phone, JSONObject templateParamJson, String signName, String code) throws ClientException {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = null;
        try {
            profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultProfile.addEndpoint((String)endpointName, (String)regionId, (String)PRODUCT, (String)DOMAIN);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(phone);
        request.setSignName(signName);
        request.setTemplateCode(code);
        request.setTemplateParam(templateParamJson.toJSONString());
        boolean result = false;
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        logger.info("\u77ed\u4fe1\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e----------------");
        logger.info("{Code:" + sendSmsResponse.getCode() + ",Message:" + sendSmsResponse.getMessage() + ",RequestId:" + sendSmsResponse.getRequestId() + ",BizId:" + sendSmsResponse.getBizId() + "}");
        if ("OK".equals(sendSmsResponse.getCode())) {
            result = true;
        }
        return result;
    }

    private static void validateParam(JSONObject templateParamJson, DySmsEnum dySmsEnum) {
        String[] keyArr;
        String keys = dySmsEnum.getKeys();
        for (String item : keyArr = keys.split(",")) {
            if (templateParamJson.containsKey((Object)item)) continue;
            throw new RuntimeException(I18nUtil.translate((String)"", (String)("\u6a21\u677f\u7f3a\u5c11\u53c2\u6570\uff1a" + item)));
        }
    }

    public static void main(String[] args) throws ClientException, InterruptedException {
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)"1234");
        DySmsHelper.sendSms("13800138000", obj, DySmsEnum.FORGET_PASSWORD_TEMPLATE_CODE);
    }

    static {
        accessKeyId = "";
        accessKeySecret = "";
    }
}

