/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.listener;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.modules.log.entity.Log;
import com.els.modules.log.entity.LogDetail;
import com.els.modules.log.service.LogDetailService;
import com.els.modules.log.service.LogService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;

@Service
public class LogMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(LogMessageConsumer.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private LogService logService;
    @Resource
    private LogDetailService logDetailService;
    private static final String SAVE_LOG_DETAILL = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.saveLogDetaill");

    @Bean(value={"inputLog"})
    public Consumer<Message<String>> receive() {
        return message -> {
            String msgBody = (String)message.getPayload();
            log.info("receive log:" + msgBody);
            try {
                Log log = (Log)JSONObject.parseObject((String)msgBody, Log.class);
                LogDetail detail = new LogDetail();
                detail.setRequestParam(log.getRequestParam());
                detail.setResponseParam(log.getResponseParam());
                detail.setElsAccount(log.getElsAccount());
                log.setRequestParam(null);
                log.setResponseParam(null);
                if (StringUtils.isNotBlank((CharSequence)log.getIp())) {
                    try {
                        String url = "https://www.ip.cn/api/index?type=1&ip=" + log.getIp();
                        String response = HttpRequest.get((String)url).execute().body();
                        JSONObject object = JSONObject.parseObject((String)response);
                        if ("0".equals(object.getString("code"))) {
                            log.setIp(log.getIp() + " " + object.getString("address"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.logService.save(log);
                if ("1".equals(SAVE_LOG_DETAILL)) {
                    detail.setHeadId(log.getId());
                    this.logDetailService.save(detail);
                }
            }
            catch (Exception e) {
                log.error("save log failed:", (Throwable)e);
            }
        };
    }
}

