/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.listener;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.els.common.util.SpringContextUtils;
import com.els.modules.log.entity.Log;
import com.els.modules.log.entity.LogDetail;
import com.els.modules.log.service.LogDetailService;
import com.els.modules.log.service.LogService;
import com.tongtech.client.annotation.HTPMessageListener;
import com.tongtech.client.consumer.PullResult;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyContext;
import com.tongtech.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.tongtech.client.core.HTPPushConsumerLifecycleListener;
import com.tongtech.client.exception.HTPException;
import com.tongtech.client.htp.consumer.HTPPushConsumer;
import com.tongtech.client.message.Message;
import com.tongtech.client.support.HTPListenerConcurrently;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@HTPMessageListener(consumerGroup="els_sys_log", topic="els_sys_log", namespace="dongfangtonghtp")
public class LogMessageConcumerListener
implements HTPListenerConcurrently,
HTPPushConsumerLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(LogMessageConcumerListener.class);
    @Resource
    private LogService logService;
    private HTPPushConsumer pushConsumer;
    @Resource
    private LogDetailService logDetailService;
    private static final String SAVE_LOG_DETAILL = ((Environment)SpringContextUtils.getBean(Environment.class)).getProperty("els.config.saveLogDetaill");

    public ConsumeConcurrentlyStatus onMessage(PullResult pullResult, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        log.info("push\u6d88\u606f\u6210\u529f,\u7ed3\u679c\uff1a" + pullResult);
        pullResult.getMsgFoundList().forEach(messageExt -> {
            try {
                Log log = (Log)JSONObject.parseObject((byte[])messageExt.getBody(), Log.class, (Feature[])new Feature[0]);
                LogDetail detail = new LogDetail();
                detail.setRequestParam(log.getRequestParam());
                detail.setResponseParam(log.getResponseParam());
                detail.setElsAccount(log.getElsAccount());
                log.setRequestParam(null);
                log.setResponseParam(null);
                if (StringUtils.isNotBlank((CharSequence)log.getIp())) {
                    try {
                        String url = "https://www.ip.cn/api/index?type=1&ip=" + log.getIp();
                        String response = HttpRequest.get((String)url).execute().body();
                        JSONObject object = JSONObject.parseObject((String)response);
                        if ("0".equals(object.getString("code"))) {
                            log.setIp(log.getIp() + " " + object.getString("address"));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.logService.save(log);
                if ("1".equals(SAVE_LOG_DETAILL)) {
                    detail.setHeadId(log.getId());
                    this.logDetailService.save(detail);
                }
                this.pushConsumer.acknowledge((Message)messageExt);
            }
            catch (HTPException e) {
                throw new RuntimeException(e);
            }
        });
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    public void prepareStart(HTPPushConsumer htpPushConsumer) {
        this.pushConsumer = htpPushConsumer;
        this.pushConsumer.setClientAcknowledge();
    }
}

