/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.util.ThirdTokenUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.JustAuthConfigDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.rpc.service.MessageInvokeAccountService;
import com.els.modules.message.util.TemplateParseUtil;
import com.els.modules.message.vo.MsgVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxEnterpriseSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(WxEnterpriseSendMsgImpl.class);

    protected String getType() {
        return "WECHAT_ENTERPRISE";
    }

    @Override
    public void doSendMsg(MsgVO msg) {
        ArrayList busAccountList;
        log.info("enter into WxEnterpriseSendMsgImpl.doSendMsg");
        Map<String, List<ElsMsgConfigItem>> elsMsgConfigItem = msg.getElsMsgConfigItem();
        if (CollectionUtil.isEmpty(elsMsgConfigItem)) {
            log.warn("WxEnterpriseSendMsgImpl \u7f3a\u5c11\u5fae\u4fe1\u6d88\u606f\u914d\u7f6e");
            return;
        }
        ElsSubAccountDTO account = msg.getReceiveAccount();
        MessageInvokeAccountService thirdAccountService = (MessageInvokeAccountService)SpringContextUtils.getBean(MessageInvokeAccountService.class);
        List<ThirdAccountDTO> list = thirdAccountService.getThirdAccount(busAccountList = Lists.newArrayList((Iterable)Sets.newHashSet((Object[])new String[]{"100000", msg.getBusAccount(), msg.getReceiveAccount().getElsAccount()})), account.getId(), this.getType());
        if (list.isEmpty()) {
            log.warn("WxEnterpriseSendMsgImpl receive not bind " + this.getType());
            return;
        }
        for (ThirdAccountDTO accountDto : list) {
            List<ElsMsgConfigItem> elsMsgConfigItems = elsMsgConfigItem.get(accountDto.getBusAccount());
            boolean configFlag = this.checkIfConfigByCurrentAccount(msg, accountDto.getBusAccount());
            String configAccount = accountDto.getBusAccount();
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && configFlag) {
                log.warn("\u5f53\u524d\u8d26\u53f7:{}\u6ca1\u6709\u914d\u7f6e{}\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b\u914d\u7f6e", (Object)accountDto.getBusAccount(), (Object)this.getType());
                continue;
            }
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && !configFlag) {
                elsMsgConfigItems = elsMsgConfigItem.get("100000");
                configAccount = "100000";
                if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
                    log.warn("\u5f53\u524d\u8d26\u53f7:{}\u6ca1\u6709\u914d\u7f6e{}\u7684\u6d88\u606f\u53d1\u9001\u7c7b\u578b\u914d\u7f6e", (Object)"100000", (Object)this.getType());
                    continue;
                }
            }
            try {
                JustAuthConfigDTO config = this.getJustConfig(configAccount, this.getType());
                if (StrUtil.isEmpty((CharSequence)config.getClientId())) {
                    log.error(":::\u4f01\u4e1a\u5fae\u4fe1\u7b2c\u4e09\u65b9\u914d\u7f6e\u4e0d\u5b58\u5728,elsAccount:{}", (Object)configAccount);
                    continue;
                }
                ElsMsgConfigItem item = elsMsgConfigItems.get(0);
                msg.setMsgContent(item.getMsgContent());
                String urlString = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=" + ThirdTokenUtil.getWechatEpToken((String)configAccount, (JustAuthConfigDTO)config);
                JSONObject body = new JSONObject();
                if (StrUtil.isEmpty((CharSequence)config.getAgentId())) {
                    log.error(":::\u4f01\u4e1a\u5fae\u4fe1\u7b2c\u4e09\u65b9\u914d\u7f6e\u4e0d\u5b58\u5728,elsAccount:{}", (Object)configAccount);
                    continue;
                }
                body.put("agentid", (Object)config.getAgentId());
                body.put("msgtype", (Object)"textcard");
                JSONObject textcard = new JSONObject();
                textcard.put("btntxt", (Object)"");
                textcard.put("title", (Object)item.getMsgTitle());
                textcard.put("url", (Object)this.getUrl(item.getLinkUrl() + this.getConcat(item.getLinkUrl()) + msg.getUrlParam(), configAccount));
                log.info(":::\u4f01\u4e1a\u5fae\u4fe1\u53d1\u9001\u6d88\u606furl:{}", textcard.get((Object)"url"));
                if (StrUtil.isNotBlank((CharSequence)item.getMsgContent()) && msg.getParams() != null) {
                    JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                    String msgContent = TemplateParseUtil.getTemplateText("", item.getMsgContent(), (Map<String, Object>)object);
                    textcard.put("description", (Object)msgContent);
                }
                body.put("textcard", (Object)textcard);
                body.put("touser", (Object)accountDto.getThirdUserUuid());
                log.info(":::WxEnterpriseSendMsgImpl msgBody:{}", (Object)body.toString());
                String result = HttpUtil.post((String)urlString, (String)body.toString());
                log.info(":::WxEnterpriseSendMsgImpl send message result:{}", (Object)result);
            }
            catch (Exception e) {
                log.error("WxEnterpriseSendMsgImpl.doSendMsg \u4f01\u4e1a\u5fae\u4fe1\u53d1\u9001\u6d88\u606f\u5f02\u5e38:", (Object)e.getMessage());
            }
        }
    }

    @Override
    protected String getOauthUrl() {
        return "/els/account/thirdLogin/render/%s/mobile/wechat_enterprise_web";
    }

    public static void main(String[] args) {
        String token = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=46_cdvi4kKxG51o5_ao4LYEVUKSrVEJ2tKBwrgKE688wb6NOaXJuSyH4AJzZmdAHZ_CepbFFpP6AjmiPXQBDMuh50-zESXmm5E28EcH5q5_YJJwXXFyuUuCs-7sjmW5Ydt9BBB_1U2Ztcd4CCgkIOTfABACIN";
        String body = "{\r\n           \"touser\":\"oCQZC6GSLuribL-Ez_WK_Qz4o4XU\",\r\n           \"template_id\":\"TrCHKlWNdYk8_4v-T1ovVbi1t4IOC9guBrj84diJpyo\",\r\n           \"url\":\"http://v5sit.51qqt.com/user/login\",           \r\n           \"data\":{\r\n           \t\"number\": {\r\n                       \"value\":\"aaa\",\r\n                       \"color\":\"#173177\"\r\n                   }\r\n           }\r\n}";
        HttpUtil.post((String)token, (String)body);
    }
}

