/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.news.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.news.entity.ElsTenantPortalNews;
import com.els.modules.news.enums.NewsStatusEnum;
import com.els.modules.news.service.ElsTenantPortalNewsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u95e8\u6237\u65b0\u95fb\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/news/elsTenantPortalNews"})
public class ElsTenantPortalNewsController
extends BaseController<ElsTenantPortalNews, ElsTenantPortalNewsService> {
    @Autowired
    private ElsTenantPortalNewsService elsTenantPortalNewsService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(ElsTenantPortalNews elsTenantPortalNews, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTenantPortalNews), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        queryWrapper.lambda().select(new SFunction[]{BaseEntity::getId, ElsTenantPortalNews::getPortalNewsThumbnail, ElsTenantPortalNews::getPortalNewsType, ElsTenantPortalNews::getPortalNewsTitle, ElsTenantPortalNews::getPortalNewsIntro, ElsTenantPortalNews::getStatus, ElsTenantPortalNews::getVisitorVolume, ElsTenantPortalNews::getSort, ElsTenantPortalNews::getEffectiveTime, ElsTenantPortalNews::getPublishTime, ElsTenantPortalNews::getExpiryTime, ElsTenantPortalNews::getNewsRedirectType, ElsTenantPortalNews::getLinkUrl, ElsTenantPortalNews::getRemark, BaseEntity::getCreateTime, BaseEntity::getCreateBy, BaseEntity::getUpdateTime, BaseEntity::getUpdateBy});
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTenantPortalNewsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u95e8\u6237\u65b0\u95fb\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ElsTenantPortalNews elsTenantPortalNews) {
        elsTenantPortalNews.setSort(CharSequenceUtil.emptyToDefault((CharSequence)elsTenantPortalNews.getSort(), (String)"0"));
        elsTenantPortalNews.setStatus(NewsStatusEnum.UNPUBLISHED.getCode());
        this.elsTenantPortalNewsService.saveElsTenantPortalNews(elsTenantPortalNews);
        return Result.ok((Object)((Object)elsTenantPortalNews));
    }

    @AutoLog(value="\u95e8\u6237\u65b0\u95fb\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ElsTenantPortalNews elsTenantPortalNews) {
        elsTenantPortalNews.setStatus(NewsStatusEnum.UNPUBLISHED.getCode());
        this.elsTenantPortalNewsService.updateElsTenantPortalNews(elsTenantPortalNews);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u95e8\u6237\u65b0\u95fb\u7ba1\u7406-\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish/{id}"})
    public Result<?> publish(@PathVariable(value="id") String id) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)updateWrapper.set(ElsTenantPortalNews::getStatus, (Object)NewsStatusEnum.PUBLISHED.getCode())).set(ElsTenantPortalNews::getPublishTime, (Object)new Date());
        ((LambdaUpdateWrapper)updateWrapper.eq(BaseEntity::getId, (Object)id)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        this.elsTenantPortalNewsService.update((Object)new ElsTenantPortalNews(), (Wrapper)updateWrapper);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u95e8\u6237\u65b0\u95fb\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestBody List<String> ids) {
        this.elsTenantPortalNewsService.removeByIds(ids);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsTenantPortalNews elsTenantPortalNews = (ElsTenantPortalNews)((Object)this.elsTenantPortalNewsService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)elsTenantPortalNews));
    }

    @GetMapping(value={"/noToken/detail"})
    public Result<?> detail(@RequestParam(name="id") String id) {
        ElsTenantPortalNews elsTenantPortalNews = (ElsTenantPortalNews)((Object)this.elsTenantPortalNewsService.getById((Serializable)((Object)id)));
        if (!NewsStatusEnum.PUBLISHED.getCode().equals(elsTenantPortalNews.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u95e8\u6237\u65b0\u95fb\u672a\u53d1\u5e03"));
        }
        return Result.ok((Object)((Object)elsTenantPortalNews));
    }

    @GetMapping(value={"/noToken/page"})
    public Result<?> detail(@RequestParam(name="type", defaultValue="") String type, @RequestParam(name="elsAccount", defaultValue="") String elsAccount, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getElsAccount, (Object)CharSequenceUtil.emptyToDefault((CharSequence)elsAccount, (String)SysUtil.getPurchaseAccount()))).eq(ElsTenantPortalNews::getStatus, (Object)NewsStatusEnum.PUBLISHED.getCode())).eq(CharSequenceUtil.isNotEmpty((CharSequence)type), ElsTenantPortalNews::getPortalNewsType, (Object)type);
        queryWrapper.select(new SFunction[]{BaseEntity::getId, ElsTenantPortalNews::getPortalNewsType, ElsTenantPortalNews::getPortalNewsTitle, ElsTenantPortalNews::getPortalNewsIntro, BaseEntity::getCreateTime, BaseEntity::getUpdateTime, ElsTenantPortalNews::getPublishTime, ElsTenantPortalNews::getNewsRedirectType, ElsTenantPortalNews::getLinkUrl, ElsTenantPortalNews::getPortalNewsThumbnail});
        DateTime now = DateUtil.date();
        ((LambdaQueryWrapper)queryWrapper.le(ElsTenantPortalNews::getEffectiveTime, (Object)now)).ge(ElsTenantPortalNews::getExpiryTime, (Object)now);
        queryWrapper.orderByAsc(ElsTenantPortalNews::getSort);
        queryWrapper.orderByDesc(ElsTenantPortalNews::getPublishTime);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Page portalNewsPage = (Page)this.elsTenantPortalNewsService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)portalNewsPage);
    }
}

