/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.survey.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.notice.api.enumerate.NoticeScopeEnum;
import com.els.modules.notice.entity.PurchaseNotice;
import com.els.modules.notice.service.PurchaseNoticeService;
import com.els.modules.survey.entity.PurchaseSurveyAnswer;
import com.els.modules.survey.entity.PurchaseSurveyAnswerLibrary;
import com.els.modules.survey.entity.PurchaseSurveyAnswerOption;
import com.els.modules.survey.entity.PurchaseSurveyHead;
import com.els.modules.survey.entity.PurchaseSurveyItem;
import com.els.modules.survey.entity.PurchaseSurveyLibrary;
import com.els.modules.survey.entity.PurchaseSurveyOption;
import com.els.modules.survey.enumerate.ServeyItemStatusEnum;
import com.els.modules.survey.enumerate.ServeyScopeEnum;
import com.els.modules.survey.enumerate.ServeyStatusEnum;
import com.els.modules.survey.mapper.PurchaseSurveyAnswerLibraryMapper;
import com.els.modules.survey.mapper.PurchaseSurveyAnswerMapper;
import com.els.modules.survey.mapper.PurchaseSurveyAnswerOptionMapper;
import com.els.modules.survey.mapper.PurchaseSurveyHeadMapper;
import com.els.modules.survey.mapper.PurchaseSurveyItemMapper;
import com.els.modules.survey.mapper.PurchaseSurveyLibraryMapper;
import com.els.modules.survey.mapper.PurchaseSurveyOptionMapper;
import com.els.modules.survey.service.PurchaseSurveyHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseSurveyHeadServiceImpl
extends BaseServiceImpl<PurchaseSurveyHeadMapper, PurchaseSurveyHead>
implements PurchaseSurveyHeadService {
    @Resource
    private PurchaseSurveyHeadMapper purchaseSurveyHeadMapper;
    @Resource
    private PurchaseSurveyLibraryMapper purchaseSurveyLibraryMapper;
    @Resource
    private PurchaseSurveyOptionMapper purchaseSurveyOptionMapper;
    @Resource
    private PurchaseSurveyItemMapper purchaseSurveyItemMapper;
    @Resource
    private PurchaseSurveyAnswerMapper purchaseSurveyAnswerMapper;
    @Resource
    private PurchaseSurveyAnswerLibraryMapper purchaseSurveyAnswerLibraryMapper;
    @Resource
    private PurchaseSurveyAnswerOptionMapper purchaseSurveyAnswerOptionMapper;
    @Resource
    private PurchaseNoticeService purchaseNoticeRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyLibrary> purchaseSurveyLibraryList, List<PurchaseSurveyItem> purchaseSurveyItemList, List<PurchaseSurveyAnswer> purchaseSurveyAnswerList) {
        if (StringUtils.isBlank((CharSequence)purchaseSurveyHead.getSurveyNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSurveyNumber", (Object)purchaseSurveyHead);
            purchaseSurveyHead.setSurveyNumber(nextCode);
            LoginUser loginUser = SysUtil.getLoginUser();
            purchaseSurveyHead.setPurchaseName(loginUser.getEnterpriseName());
        }
        if ("1".equals(purchaseSurveyHead.getAudit())) {
            purchaseSurveyHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSurveyHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        purchaseSurveyHead.setSurveyStatus("0");
        this.purchaseSurveyHeadMapper.insert((Object)purchaseSurveyHead);
        this.insertData(purchaseSurveyHead, purchaseSurveyLibraryList, purchaseSurveyItemList, purchaseSurveyAnswerList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyLibrary> purchaseSurveyLibraryList, List<PurchaseSurveyItem> purchaseSurveyItemList, List<PurchaseSurveyAnswer> purchaseSurveyAnswerList) {
        List<PurchaseSurveyLibrary> libraries;
        if (StringUtils.isBlank((CharSequence)purchaseSurveyHead.getSurveyNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSurveyNumber", (Object)purchaseSurveyHead);
            purchaseSurveyHead.setSurveyNumber(nextCode);
            LoginUser loginUser = SysUtil.getLoginUser();
            purchaseSurveyHead.setPurchaseName(loginUser.getEnterpriseName());
        }
        if ("1".equals(purchaseSurveyHead.getAudit())) {
            purchaseSurveyHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSurveyHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseSurveyHeadMapper.updateById((Object)purchaseSurveyHead);
        this.log.error("\u66f4\u65b0\u83b7\u53d6SurveyheadId:" + purchaseSurveyHead.getId());
        if (!CollectionUtils.isEmpty(purchaseSurveyLibraryList) && StringUtils.isNotBlank((CharSequence)purchaseSurveyHead.getId()) && (libraries = this.purchaseSurveyLibraryMapper.selectByMainId(purchaseSurveyHead.getId())).size() > 0) {
            ArrayList<String> ids = new ArrayList<String>();
            libraries.forEach(library -> ids.add(library.getId()));
            this.purchaseSurveyOptionMapper.deleteByMainIds(ids);
            this.purchaseSurveyLibraryMapper.deleteByMainId(purchaseSurveyHead.getId());
        }
        if ("0".equals(purchaseSurveyHead.getSurveyStatus()) && StringUtils.isNotBlank((CharSequence)purchaseSurveyHead.getId())) {
            this.purchaseSurveyAnswerMapper.deleteByMainId(purchaseSurveyHead.getId());
        }
        this.purchaseSurveyItemMapper.deleteByMainId(purchaseSurveyHead.getId());
        this.insertData(purchaseSurveyHead, purchaseSurveyLibraryList, purchaseSurveyItemList, purchaseSurveyAnswerList);
    }

    private void insertData(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyLibrary> purchaseSurveyLibraryList, List<PurchaseSurveyItem> purchaseSurveyItemList, List<PurchaseSurveyAnswer> purchaseSurveyAnswerList) {
        if (!CollectionUtils.isEmpty(purchaseSurveyLibraryList)) {
            for (PurchaseSurveyLibrary purchaseSurveyLibrary : purchaseSurveyLibraryList) {
                purchaseSurveyLibrary.setHeadId(purchaseSurveyHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseSurveyLibrary, (BaseEntity)purchaseSurveyHead);
                purchaseSurveyLibrary.setId(IdWorker.getIdStr());
                purchaseSurveyLibrary.setElsAccount(purchaseSurveyHead.getElsAccount());
                List<PurchaseSurveyOption> purchaseSurveyOptionList = purchaseSurveyLibrary.getPurchaseSurveyOptionList();
                if (CollectionUtils.isEmpty(purchaseSurveyOptionList)) continue;
                purchaseSurveyOptionList.forEach(item -> {
                    item.setHeadId(purchaseSurveyLibrary.getId());
                    item.setElsAccount(purchaseSurveyLibrary.getElsAccount());
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                });
                this.purchaseSurveyOptionMapper.insertBatchSomeColumn(purchaseSurveyOptionList);
            }
            if (!purchaseSurveyLibraryList.isEmpty()) {
                this.purchaseSurveyLibraryMapper.insertBatchSomeColumn(purchaseSurveyLibraryList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseSurveyItemList)) {
            for (PurchaseSurveyItem purchaseSurveyItem : purchaseSurveyItemList) {
                purchaseSurveyItem.setHeadId(purchaseSurveyHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseSurveyItem, (BaseEntity)purchaseSurveyHead);
            }
            if (!purchaseSurveyItemList.isEmpty()) {
                this.purchaseSurveyItemMapper.insertBatchSomeColumn(purchaseSurveyItemList);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseSurveyAnswerList)) {
            for (PurchaseSurveyAnswer purchaseSurveyAnswer : purchaseSurveyAnswerList) {
                purchaseSurveyAnswer.setHeadId(purchaseSurveyHead.getId());
                SysUtil.setSysParam((BaseEntity)purchaseSurveyAnswer, (BaseEntity)purchaseSurveyHead);
            }
            if (!purchaseSurveyAnswerList.isEmpty()) {
                this.purchaseSurveyAnswerMapper.insertBatchSomeColumn(purchaseSurveyAnswerList);
            }
        }
    }

    @Override
    public void publish(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyLibrary> purchaseSurveyLibraryList, List<PurchaseSurveyAnswer> purchaseSurveyAnswerList) {
        if (!ServeyScopeEnum.PUBLIC.getValue().equals(purchaseSurveyHead.getSurveyScope())) {
            ArrayList<PurchaseSurveyItem> objects = new ArrayList<PurchaseSurveyItem>();
            for (PurchaseSurveyAnswer purchaseSurveyAnswer : purchaseSurveyAnswerList) {
                PurchaseSurveyItem purchaseSurveyItem = new PurchaseSurveyItem();
                purchaseSurveyItem.setAnswerAccount(purchaseSurveyAnswer.getAnswerAccount());
                purchaseSurveyItem.setAnswerSubAccount(purchaseSurveyAnswer.getAnswerSubAccount());
                purchaseSurveyItem.setAnswerName(purchaseSurveyAnswer.getAnswerName());
                purchaseSurveyItem.setAnswerStatus(ServeyItemStatusEnum.ANSWER.getValue());
                purchaseSurveyItem.setElsAccount(purchaseSurveyHead.getElsAccount());
                purchaseSurveyItem.setHeadId(purchaseSurveyHead.getId());
                purchaseSurveyItem.setDeleted(CommonConstant.DEL_FLAG_0);
                purchaseSurveyItem.setId(IdWorker.getIdStr());
                objects.add(purchaseSurveyItem);
                ArrayList<PurchaseSurveyAnswerLibrary> purchaseSurveyAnswerLibraryList = new ArrayList<PurchaseSurveyAnswerLibrary>();
                if (!CollectionUtils.isEmpty(purchaseSurveyLibraryList)) {
                    for (PurchaseSurveyLibrary purchaseSurveyLibrary : purchaseSurveyLibraryList) {
                        PurchaseSurveyAnswerLibrary purchaseSurveyAnswerLibrary = new PurchaseSurveyAnswerLibrary();
                        BeanUtils.copyProperties((Object)((Object)purchaseSurveyLibrary), (Object)((Object)purchaseSurveyAnswerLibrary));
                        purchaseSurveyAnswerLibrary.setId(IdWorker.getIdStr());
                        purchaseSurveyAnswerLibrary.setHeadId(purchaseSurveyItem.getId());
                        purchaseSurveyAnswerLibraryList.add(purchaseSurveyAnswerLibrary);
                        List<PurchaseSurveyOption> purchaseSurveyOptionList = purchaseSurveyLibrary.getPurchaseSurveyOptionList();
                        if (CollectionUtils.isEmpty(purchaseSurveyOptionList)) continue;
                        ArrayList<PurchaseSurveyAnswerOption> purchaseSurveyAnswerOptionList = new ArrayList<PurchaseSurveyAnswerOption>();
                        for (PurchaseSurveyOption purchaseSurveyOption : purchaseSurveyOptionList) {
                            PurchaseSurveyAnswerOption purchaseSurveyAnswerOption = new PurchaseSurveyAnswerOption();
                            BeanUtils.copyProperties((Object)((Object)purchaseSurveyOption), (Object)((Object)purchaseSurveyAnswerOption));
                            purchaseSurveyAnswerOption.setId(IdWorker.getIdStr());
                            purchaseSurveyAnswerOption.setHeadId(purchaseSurveyAnswerLibrary.getId());
                            purchaseSurveyAnswerOptionList.add(purchaseSurveyAnswerOption);
                        }
                        this.purchaseSurveyAnswerOptionMapper.insertBatchSomeColumn(purchaseSurveyAnswerOptionList);
                    }
                }
                purchaseSurveyAnswer.setAllot("1");
                this.purchaseSurveyAnswerMapper.alwaysUpdateSomeColumnById((Object)purchaseSurveyAnswer);
                this.purchaseSurveyAnswerLibraryMapper.insertBatchSomeColumn(purchaseSurveyAnswerLibraryList);
            }
            this.purchaseSurveyItemMapper.insertBatchSomeColumn(objects);
        } else {
            LoginUser user = SysUtil.getLoginUser();
            PurchaseNotice notice = new PurchaseNotice();
            notice.setBusAccount(user.getElsAccount());
            notice.setNoticeTitle(purchaseSurveyHead.getSurveyName());
            notice.setNoticeContent(purchaseSurveyHead.getId());
            notice.setNoticeType("2");
            notice.setTop("1");
            notice.setEffectiveTime(new Date());
            notice.setBusinessType("survey");
            notice.setBusinessId(purchaseSurveyHead.getId());
            notice.setExpiryTime(purchaseSurveyHead.getEndDate());
            notice.setNoticeScope(NoticeScopeEnum.OPEN.getValue());
            this.purchaseNoticeRpcService.publish(notice, Lists.newArrayList(), Lists.newArrayList());
        }
        purchaseSurveyHead.setSurveyStatus(ServeyStatusEnum.PUBLISH.getValue());
        this.purchaseSurveyHeadMapper.updateById((Object)purchaseSurveyHead);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSurveyLibraryMapper.deleteByMainId(id);
        this.purchaseSurveyItemMapper.deleteByMainId(id);
        this.purchaseSurveyAnswerMapper.deleteByMainId(id);
        this.purchaseSurveyHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSurveyLibraryMapper.deleteByMainId(serializable.toString());
            this.purchaseSurveyItemMapper.deleteByMainId(serializable.toString());
            this.purchaseSurveyAnswerMapper.deleteByMainId(serializable.toString());
            this.purchaseSurveyHeadMapper.deleteById(serializable);
        }
    }
}

