/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.EmailBuilder;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.config.StaticConfig;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.ElsEmailConfigDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.rpc.service.MessageInvokeBaseService;
import com.els.modules.message.vo.MsgVO;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(EmailSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        ElsSubAccountDTO account = msg.getReceiveAccount();
        Map<String, List<ElsMsgConfigItem>> elsMsgConfigItem = msg.getElsMsgConfigItem();
        List<ElsMsgConfigItem> elsMsgConfigItems = elsMsgConfigItem.get(msg.getBusAccount());
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            elsMsgConfigItems = elsMsgConfigItem.get(msg.getToElsAccount());
            boolean configFlag = this.checkIfConfigByCurrentAccount(msg, msg.getBusAccount());
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && configFlag) {
                log.error("EmailSendMsgImpl\u5f53\u524d\u8d26\u53f7{}\u6ca1\u6709\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\u53d1\u9001:{}", (Object)msg.getBusAccount(), (Object)msg.toString());
                return;
            }
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && !configFlag) {
                elsMsgConfigItems = elsMsgConfigItem.get("100000");
            }
        }
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            return;
        }
        MessageInvokeBaseService messageInvokeBaseService = (MessageInvokeBaseService)SpringContextUtils.getBean(MessageInvokeBaseService.class);
        List<ElsEmailConfigDTO> emailConfigs = messageInvokeBaseService.getEmailConfigs(elsMsgConfigItems.get(0).getElsAccount());
        if (StrUtil.isEmpty((CharSequence)account.getEmail())) {
            log.error("EmailSendMsgImpl ==>::: \u6d88\u606f\u63a5\u6536\u65b9\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\uff0c\u65e0\u6cd5\u63a5\u6536\u90ae\u7bb1\u6d88\u606f,");
            return;
        }
        ElsMsgConfigItem item = elsMsgConfigItems.get(0);
        msg.setMsgContent(item.getMsgContent());
        log.info("EmailSendMsgImpl ==> start send email to:" + account.getEmail());
        try {
            for (ElsEmailConfigDTO config : emailConfigs) {
                String ccEmail1;
                JavaMailSender mailSender = EmailBuilder.buildJavaMailSender((ElsEmailConfigDTO)config);
                MimeMessage message = mailSender.createMimeMessage();
                MimeMessageHelper helper = new MimeMessageHelper(message, true);
                helper.setTo(account.getEmail());
                helper.setSubject(item.getMsgTitle());
                String msgContent = item.getMsgContent();
                if (CharSequenceUtil.isNotBlank((CharSequence)msgContent)) {
                    if (msg.getParams() != null) {
                        JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                        if (CharSequenceUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                            object.put("audthUrl", (Object)this.getAuthUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), account));
                        }
                        msgContent = TemplateParseUtil.getTemplateText((String)"", (String)msgContent, (Map)object);
                    }
                    helper.setText(msgContent, true);
                }
                String string = ccEmail1 = CharSequenceUtil.isBlank((CharSequence)config.getEmailCc()) ? config.getEmailUsername() : config.getEmailCc();
                if (!"exception".equals(item.getMsgType())) {
                    helper.setCc(ccEmail1);
                }
                helper.setFrom(config.getEmailUsername());
                boolean result = this.sendMessage(mailSender, message);
                if (!result) continue;
                log.info("EmailSendMsgImpl ==>:::end to send email...");
                break;
            }
        }
        catch (MessagingException e) {
            log.error("EmailSendMsgImpl ==>{}", (Object)e.getMessage());
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6d88\u606f\u7ec4\u4ef6\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
    }

    private boolean sendMessage(JavaMailSender mailSender, MimeMessage message) {
        try {
            mailSender.send(message);
            return true;
        }
        catch (Exception e) {
            log.error("EmailSendMsgImpl==>sendMessage:{}", (Object)e.getMessage());
            return false;
        }
    }

    private String getAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword()));
        return url.toString();
    }

    public static void main(String[] args) {
        String url = "/srm/bidding/sale/SaleBiddingHeadList?templateNumber=TC2021051401&templateVersion=1&id=1404452506648141826&busAccount=307000";
        System.out.println(URLUtil.encodeAll((String)url));
    }
}

