/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.api.dto.ElsEmailConfigDTO;
import com.els.api.dto.ElsEmailSendLogDto;
import com.els.api.dto.EmailSendRebuildDto;
import com.els.common.email.ElsEmailBuilder;
import com.els.common.email.sender.ElsMailSender;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.config.StaticConfig;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.impl.AbstractSendMsgImpl;
import com.els.modules.message.rpc.service.MessageInvokeBaseService;
import com.els.modules.message.vo.MsgVO;
import com.els.rpc.service.EmailRpcPersistence;
import java.util.List;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;

public class EmailSendMsgImpl
extends AbstractSendMsgImpl {
    private static final Logger log = LoggerFactory.getLogger(EmailSendMsgImpl.class);

    @Override
    public void doSendMsg(MsgVO msg) {
        log.info("EmailSendMsgImpl\u51c6\u5907\u6267\u884c\u53d1\u9001\u90ae\u4ef6\u6d88\u606f\u7684\u903b\u8f91.");
        ElsSubAccountDTO account = msg.getReceiveAccount();
        Map<String, List<ElsMsgConfigItem>> elsMsgConfigItem = msg.getElsMsgConfigItem();
        List<ElsMsgConfigItem> elsMsgConfigItems = elsMsgConfigItem.get(msg.getBusAccount());
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            elsMsgConfigItems = elsMsgConfigItem.get(msg.getToElsAccount());
            boolean configFlag = this.checkIfConfigByCurrentAccount(msg, msg.getBusAccount());
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && configFlag) {
                log.error("EmailSendMsgImpl\u5f53\u524d\u8d26\u53f7{}\u6ca1\u6709\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\u53d1\u9001:{}", (Object)msg.getBusAccount(), (Object)msg.toString());
                return;
            }
            if (CollectionUtil.isEmpty(elsMsgConfigItems) && !configFlag) {
                elsMsgConfigItems = elsMsgConfigItem.get("100000");
            }
        }
        if (CollectionUtil.isEmpty(elsMsgConfigItems)) {
            return;
        }
        MessageInvokeBaseService messageInvokeBaseService = (MessageInvokeBaseService)SpringContextUtils.getBean(MessageInvokeBaseService.class);
        List<ElsEmailConfigDTO> emailConfigs = messageInvokeBaseService.getEmailConfigs(elsMsgConfigItems.get(0).getElsAccount());
        if (CollectionUtil.isEmpty(emailConfigs)) {
            emailConfigs = messageInvokeBaseService.getEmailConfigs(msg.getSendAccount().getElsAccount());
        }
        if (StrUtil.isEmpty((CharSequence)account.getEmail())) {
            log.error("EmailSendMsgImpl ==>::: \u6d88\u606f\u63a5\u6536\u65b9\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\uff0c\u65e0\u6cd5\u63a5\u6536\u90ae\u7bb1\u6d88\u606f,");
            return;
        }
        ElsMsgConfigItem item = elsMsgConfigItems.get(0);
        msg.setMsgContent(item.getMsgContent());
        log.info("EmailSendMsgImpl ==> start send email to:" + account.getEmail());
        try {
            int size = emailConfigs.size();
            Integer index = 0;
            for (ElsEmailConfigDTO config : emailConfigs) {
                config.setTo(new String[]{account.getEmail()});
                config.setCurrentElsAccount(msg.getSendAccount().getElsAccount());
                String msgContent = item.getMsgContent();
                String msgTitle = item.getMsgTitle();
                if (CharSequenceUtil.isNotBlank((CharSequence)msgContent)) {
                    if (msg.getParams() != null) {
                        JSONObject object = SysUtil.objectToJSON((Object)msg.getParams());
                        if (CharSequenceUtil.isNotBlank((CharSequence)item.getLinkUrl())) {
                            if (CharSequenceUtil.isNotBlank((CharSequence)msg.getUrlParam())) {
                                object.put("audthUrl", (Object)this.getAuthUrl(item.getLinkUrl() + "?" + msg.getUrlParam(), account));
                            } else {
                                object.put("audthUrl", (Object)this.getAuthUrl(TemplateParseUtil.getTemplateText((String)"", (String)item.getLinkUrl(), (Map)object), account));
                            }
                        }
                        msgContent = TemplateParseUtil.getTemplateText((String)"", (String)msgContent, (Map)object);
                        msgTitle = TemplateParseUtil.getTemplateText((String)"", (String)msgTitle, (Map)object);
                    }
                    config.setContent(msgContent);
                }
                config.setSubject(msgTitle);
                config.setNeedCc(true);
                EmailRpcPersistence retrySendBuilder = (EmailRpcPersistence)SpringContextUtils.getBean(EmailRpcPersistence.class);
                ElsEmailSendLogDto sendLogDto = new ElsEmailSendLogDto();
                sendLogDto.setMsgItemConfigContent(JSON.toJSONString((Object)msg));
                EmailSendRebuildDto rebuildVo = retrySendBuilder.rebuildToSend(config, sendLogDto);
                if (null == rebuildVo) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_BSAjIhdWtjSVIm_3cd1e218", (String)"\u670d\u52a1\u5668\u90ae\u4ef6\u53d1\u9001\u903b\u8f91\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5"));
                }
                if (rebuildVo.isFlag()) {
                    return;
                }
                config = rebuildVo.getConfigDTO();
                ElsMailSender mailSender = ElsEmailBuilder.buildElsMailSender((ElsEmailConfigDTO)config, null, null);
                config.setPersistenceWhileFailed(index == size - 1);
                boolean result = mailSender.sendEmail(config, null);
                if (result) {
                    log.info("EmailSendMsgImpl ==>:::\u53d1\u4ef6\u4eba:{} \u53d1\u9001\u90ae\u4ef6\u7ed9:{},end to send email...", (Object)config.getEmailUsername(), (Object)account.getEmail());
                    break;
                }
                Integer n = index;
                index = index + 1;
            }
        }
        catch (Exception e) {
            log.error("EmailSendMsgImpl ==>{}", (Object)e.getMessage());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_XHVIhdXHKm_7ea856a4", (String)"\u6d88\u606f\u7ec4\u4ef6\u53d1\u9001\u6d88\u606f\u5931\u8d25"));
        }
    }

    private boolean sendMessage(JavaMailSender mailSender, MimeMessage message) {
        try {
            mailSender.send(message);
            return true;
        }
        catch (Exception e) {
            log.error("EmailSendMsgImpl==>sendMessage:{}", (Object)e.getMessage());
            return false;
        }
    }

    private String getAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword()));
        return url.toString();
    }

    public static void main(String[] args) {
        String url = "/srm/bidding/sale/SaleBiddingHeadList?templateNumber=TC2021051401&templateVersion=1&id=1404452506648141826&busAccount=307000";
        System.out.println(URLUtil.encodeAll((String)url));
    }
}

