/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.notice.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.inquiry.api.enumerate.SourceTypeEnum;
import com.els.modules.notice.api.enumerate.NoticeScopeEnum;
import com.els.modules.notice.api.enumerate.NoticeStatusEnum;
import com.els.modules.notice.entity.PurchaseNotice;
import com.els.modules.notice.entity.PurchaseNoticeSupplier;
import com.els.modules.notice.entity.SaleNotice;
import com.els.modules.notice.mapper.PurchaseNoticeMapper;
import com.els.modules.notice.mapper.PurchaseNoticeSupplierMapper;
import com.els.modules.notice.mapper.SaleNoticeMapper;
import com.els.modules.notice.service.PurchaseNoticeService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseNoticeServiceImpl
extends ServiceImpl<PurchaseNoticeMapper, PurchaseNotice>
implements PurchaseNoticeService {
    @Resource
    private PurchaseNoticeMapper purchaseNoticeMapper;
    @Resource
    private PurchaseNoticeSupplierMapper purchaseNoticeSupplierMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleNoticeMapper saleNoticeMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseNotice purchaseNotice, List<PurchaseNoticeSupplier> purchaseNoticeSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseNotice.setBusAccount(TenantContext.getTenant());
        String noticeNumber = this.invokeBaseRpcService.getNextCode("srmNoticeNo", (Object)purchaseNotice);
        purchaseNotice.setNoticeNumber(noticeNumber);
        if (StrUtil.isBlank((CharSequence)purchaseNotice.getNoticeStatus())) {
            purchaseNotice.setNoticeStatus(NoticeStatusEnum.NEW.getValue());
        }
        purchaseNotice.setTop("0");
        this.purchaseNoticeMapper.insert((Object)purchaseNotice);
        this.insertData(purchaseNotice, purchaseNoticeSupplierList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseNotice purchaseNotice, List<PurchaseNoticeSupplier> purchaseNoticeSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        this.purchaseNoticeMapper.updateById((Object)purchaseNotice);
        this.purchaseNoticeSupplierMapper.deleteByMainId(purchaseNotice.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseNotice.getId());
        this.insertData(purchaseNotice, purchaseNoticeSupplierList, purchaseAttachmentList);
    }

    private void insertData(PurchaseNotice purchaseNotice, List<PurchaseNoticeSupplier> purchaseNoticeSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        for (PurchaseNoticeSupplier purchaseNoticeSupplier : purchaseNoticeSupplierList) {
            purchaseNoticeSupplier.setHeadId(purchaseNotice.getId());
            purchaseNoticeSupplier.setReadStatus("1");
            SysUtil.setSysParam((BaseEntity)purchaseNoticeSupplier, (BaseEntity)purchaseNotice);
        }
        if (!purchaseNoticeSupplierList.isEmpty()) {
            this.purchaseNoticeSupplierMapper.insertBatchSomeColumn(purchaseNoticeSupplierList);
        }
        if (purchaseAttachmentList != null) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentList) {
                purchaseAttachmentDTO.setHeadId(purchaseNotice.getId());
                purchaseAttachmentDTO.setId(null);
                SysUtil.setSysParam((BaseDTO)purchaseAttachmentDTO, (BaseEntity)purchaseNotice);
            }
            if (!purchaseAttachmentList.isEmpty()) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseNoticeSupplierMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
        this.purchaseNoticeMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseNoticeSupplierMapper.deleteByMainId(serializable.toString());
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(serializable.toString());
            this.purchaseNoticeMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publish(PurchaseNotice purchaseNotice, List<PurchaseNoticeSupplier> purchaseNoticeSupplierList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseNotice.setNoticeStatus(NoticeStatusEnum.PUBLISH.getValue());
        purchaseNotice.setPublishTime(new Date());
        LoginUser sysUser = SysUtil.getLoginUser();
        purchaseNotice.setPublishUser(sysUser.getRealname());
        purchaseNotice.setPublishUserId(sysUser.getId());
        if (StrUtil.isEmpty((CharSequence)purchaseNotice.getId())) {
            this.saveMain(purchaseNotice, purchaseNoticeSupplierList, purchaseAttachmentList);
        } else {
            this.updateMain(purchaseNotice, purchaseNoticeSupplierList, purchaseAttachmentList);
        }
        if (NoticeScopeEnum.ASSIGN_SUPPLIER.getValue().equals(purchaseNotice.getNoticeScope())) {
            ArrayList<SaleNotice> saleNoticeList = new ArrayList<SaleNotice>();
            ArrayList<SaleAttachmentDTO> saleAttachmentDTOList = new ArrayList<SaleAttachmentDTO>();
            for (PurchaseNoticeSupplier supplier : purchaseNoticeSupplierList) {
                SaleNotice saleNotice = new SaleNotice();
                BeanUtils.copyProperties((Object)((Object)purchaseNotice), (Object)((Object)saleNotice));
                saleNotice.setDeleted(CommonConstant.DEL_FLAG_0);
                saleNotice.setId(IdWorker.getIdStr());
                saleNotice.setElsAccount(supplier.getToElsAccount());
                saleNotice.setToElsAccount(purchaseNotice.getElsAccount());
                saleNotice.setNoticeSupplierId(supplier.getId());
                saleNoticeList.add(saleNotice);
                if (!CollectionUtil.isNotEmpty(purchaseAttachmentList)) continue;
                for (PurchaseAttachmentDTO entity : purchaseAttachmentList) {
                    SaleAttachmentDTO saleAttachmentDTO = new SaleAttachmentDTO();
                    BeanUtils.copyProperties((Object)entity, (Object)saleAttachmentDTO);
                    saleAttachmentDTO.setHeadId(saleNotice.getId());
                    saleAttachmentDTO.setId(null);
                    SysUtil.setSysParam((BaseDTO)saleAttachmentDTO, (BaseEntity)saleNotice);
                    saleAttachmentDTOList.add(saleAttachmentDTO);
                }
            }
            if (!saleAttachmentDTOList.isEmpty()) {
                this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachmentDTOList);
            }
            if (!saleNoticeList.isEmpty()) {
                this.saleNoticeMapper.insertBatchSomeColumn(saleNoticeList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancel(String id) {
        PurchaseNotice updateNotice = new PurchaseNotice();
        updateNotice.setId(id);
        updateNotice.setNoticeStatus(NoticeStatusEnum.CANCEL.getValue());
        this.purchaseNoticeMapper.updateById((Object)updateNotice);
        PurchaseNotice purchaseNotice = (PurchaseNotice)((Object)this.purchaseNoticeMapper.selectById((Serializable)((Object)id)));
        if (NoticeScopeEnum.ASSIGN_SUPPLIER.getValue().equals(purchaseNotice.getNoticeScope())) {
            SaleNotice saleNotice = new SaleNotice();
            saleNotice.setToElsAccount(purchaseNotice.getElsAccount());
            saleNotice.setNoticeNumber(purchaseNotice.getNoticeNumber());
            saleNotice.setNoticeStatus(NoticeStatusEnum.CANCEL.getValue());
            this.saleNoticeMapper.update((Object)saleNotice, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"to_els_account", (Object)saleNotice.getToElsAccount())).eq((Object)"notice_number", (Object)saleNotice.getNoticeNumber()));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void setTopOpt(String id) {
        PurchaseNotice purchaseNotice = (PurchaseNotice)((Object)this.purchaseNoticeMapper.selectById((Serializable)((Object)id)));
        String top = purchaseNotice.getTop();
        top = "1".equals(top) ? "0" : "1";
        PurchaseNotice updateNotice = new PurchaseNotice();
        updateNotice.setId(id);
        updateNotice.setTop(top);
        this.purchaseNoticeMapper.updateById((Object)updateNotice);
        if (NoticeScopeEnum.ASSIGN_SUPPLIER.getValue().equals(purchaseNotice.getNoticeScope())) {
            SaleNotice saleNotice = new SaleNotice();
            saleNotice.setToElsAccount(purchaseNotice.getElsAccount());
            saleNotice.setNoticeNumber(purchaseNotice.getNoticeNumber());
            saleNotice.setTop(top);
            this.saleNoticeMapper.update((Object)saleNotice, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"to_els_account", (Object)saleNotice.getToElsAccount())).eq((Object)"notice_number", (Object)saleNotice.getNoticeNumber()));
        }
    }

    @Override
    public List<PurchaseNotice> getPublicNoticeList() {
        return this.purchaseNoticeMapper.getPublicNotice().stream().filter(notice -> !SourceTypeEnum.ENQUIRY.getValue().equals(notice.getBusinessType()) && !SourceTypeEnum.EBIDDING.getValue().equals(notice.getBusinessType()) && !SourceTypeEnum.BIDDING.getValue().equals(notice.getBusinessType())).collect(Collectors.toList());
    }

    @Override
    public List<PurchaseNotice> getPublicInquiryNoticeList() {
        return this.purchaseNoticeMapper.getPublicNotice().stream().filter(notice -> SourceTypeEnum.ENQUIRY.getValue().equals(notice.getBusinessType()) || SourceTypeEnum.EBIDDING.getValue().equals(notice.getBusinessType()) || SourceTypeEnum.BIDDING.getValue().equals(notice.getBusinessType()) || SourceTypeEnum.TENDER_BULLETIN.getValue().equals(notice.getBusinessType())).collect(Collectors.toList());
    }

    @Override
    public IPage<PurchaseNotice> getHomePageNoticeList(Integer fromIndex, Integer pageSize, String keyWord) {
        List<PurchaseNotice> noticeList = this.purchaseNoticeMapper.getHomePageNoticeList(TenantContext.getTenant(), fromIndex, pageSize, keyWord);
        int count = this.purchaseNoticeMapper.getHomePageNoticeListCount(TenantContext.getTenant(), fromIndex, pageSize, keyWord);
        Page page = new Page((long)fromIndex.intValue(), (long)pageSize.intValue());
        page.setRecords(noticeList);
        page.setSize((long)count);
        page.setTotal((long)count);
        return page;
    }

    @Override
    public List<String> getPurchaseNoticeIdList(String headId) {
        List<String> strings = this.purchaseNoticeMapper.selectByHeadId(headId);
        return strings;
    }
}

