/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.mapper.ElsMsgConfigHeadMapper;
import com.els.modules.message.mapper.ElsMsgConfigItemMapper;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ElsMsgConfigHeadServiceImpl
extends ServiceImpl<ElsMsgConfigHeadMapper, ElsMsgConfigHead>
implements ElsMsgConfigHeadService {
    @Resource
    private ElsMsgConfigHeadMapper elsMsgConfigHeadMapper;
    @Resource
    private ElsMsgConfigItemMapper elsMsgConfigItemMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        this.duplicateHeadCheck(elsMsgConfigHead.getBusinessType(), elsMsgConfigHead.getOperateType(), null);
        this.duplicateItemCheck(elsMsgConfigItemList);
        this.elsMsgConfigHeadMapper.insert((Object)elsMsgConfigHead);
        this.insertData(elsMsgConfigHead, elsMsgConfigItemList);
    }

    private void duplicateHeadCheck(String businessType, String operateType, String id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)businessType)).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant())).ne(CharSequenceUtil.isNotBlank((CharSequence)id), BaseEntity::getId, (Object)id)).eq(ElsMsgConfigHead::getStatus, (Object)"1");
        Integer count = ((ElsMsgConfigHeadMapper)this.baseMapper).selectCount((Wrapper)wrapper);
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rXHtkERIMKiKAjjERW_da535640", (String)"\u8be5\u6d88\u606f\u64cd\u4f5c\u914d\u7f6e\u5df2\u5b58\u5728\u6b63\u5728\u542f\u7528\u7684\u914d\u7f6e!"));
        }
    }

    private void duplicateItemCheck(List<ElsMsgConfigItem> elsMsgConfigItemList) {
        if (CollUtil.isEmpty(elsMsgConfigItemList)) {
            return;
        }
        int length = elsMsgConfigItemList.size();
        long count = elsMsgConfigItemList.stream().map(ElsMsgConfigItem::getMsgType).distinct().count();
        if (count != (long)length) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_XHcERMKVBWFWVImSKDJW_2fda456f", (String)"\u6d88\u606f\u884c\u914d\u7f6e\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u540e\u5728\u63d0\u4ea4!"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        this.duplicateHeadCheck(elsMsgConfigHead.getBusinessType(), elsMsgConfigHead.getOperateType(), elsMsgConfigHead.getId());
        this.duplicateItemCheck(elsMsgConfigItemList);
        this.elsMsgConfigHeadMapper.updateById((Object)elsMsgConfigHead);
        this.elsMsgConfigItemMapper.deleteByMainId(elsMsgConfigHead.getId());
        this.insertData(elsMsgConfigHead, elsMsgConfigItemList);
    }

    private void insertData(ElsMsgConfigHead elsMsgConfigHead, List<ElsMsgConfigItem> elsMsgConfigItemList) {
        for (ElsMsgConfigItem entity : elsMsgConfigItemList) {
            entity.setHeadId(elsMsgConfigHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)elsMsgConfigHead);
        }
        if (!elsMsgConfigItemList.isEmpty()) {
            this.elsMsgConfigItemMapper.insertBatchSomeColumn(elsMsgConfigItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.elsMsgConfigItemMapper.deleteByMainId(id);
        this.elsMsgConfigHeadMapper.PhysicalDeleteById(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.elsMsgConfigItemMapper.deleteByMainId(serializable.toString());
            this.elsMsgConfigHeadMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addToEnterprise(String id) {
        ElsMsgConfigHead elsMsgConfigHead = (ElsMsgConfigHead)((Object)this.elsMsgConfigHeadMapper.selectById((Serializable)((Object)id)));
        List<ElsMsgConfigItem> items = this.elsMsgConfigItemMapper.selectByMainId(id);
        String subAccount = SysUtil.getLoginUser().getSubAccount();
        String elsAccount = TenantContext.getTenant();
        this.duplicateHeadCheck(elsMsgConfigHead.getBusinessType(), elsMsgConfigHead.getOperateType(), null);
        elsMsgConfigHead.setId(null);
        elsMsgConfigHead.setElsAccount(elsAccount);
        elsMsgConfigHead.setCreateBy(subAccount);
        elsMsgConfigHead.setUpdateBy(subAccount);
        elsMsgConfigHead.setOperateType(elsMsgConfigHead.getOperateType());
        elsMsgConfigHead.setCreateTime(new Date());
        elsMsgConfigHead.setUpdateTime(new Date());
        this.elsMsgConfigHeadMapper.insert((Object)elsMsgConfigHead);
        for (ElsMsgConfigItem item : items) {
            item.setId(null);
            item.setHeadId(elsMsgConfigHead.getId());
            item.setElsAccount(elsAccount);
            item.setCreateBy(subAccount);
            item.setUpdateBy(subAccount);
            item.setCreateTime(new Date());
            item.setUpdateTime(new Date());
        }
        if (!items.isEmpty()) {
            this.elsMsgConfigItemMapper.insertBatchSomeColumn(items);
        }
    }
}

