/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.survey.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.survey.entity.PurchaseSurveyHead;
import com.els.modules.survey.entity.PurchaseSurveyItem;
import com.els.modules.survey.entity.PurchaseSurveyLibrary;
import com.els.modules.survey.entity.PurchaseSurveyTemplateHead;
import com.els.modules.survey.entity.PurchaseSurveyTemplateItem;
import com.els.modules.survey.entity.PurchaseSurveyTemplateOption;
import com.els.modules.survey.mapper.PurchaseSurveyTemplateHeadMapper;
import com.els.modules.survey.mapper.PurchaseSurveyTemplateItemMapper;
import com.els.modules.survey.mapper.PurchaseSurveyTemplateOptionMapper;
import com.els.modules.survey.service.PurchaseSurveyTemplateHeadService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseSurveyTemplateHeadServiceImpl
extends BaseServiceImpl<PurchaseSurveyTemplateHeadMapper, PurchaseSurveyTemplateHead>
implements PurchaseSurveyTemplateHeadService {
    @Resource
    private PurchaseSurveyTemplateHeadMapper purchaseSurveyTemplateHeadMapper;
    @Resource
    private PurchaseSurveyTemplateItemMapper purchaseSurveyTemplateItemMapper;
    @Resource
    private PurchaseSurveyTemplateOptionMapper purchaseSurveyTemplateOptionMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSurveyTemplateHead purchaseSurveyTemplateHead, List<PurchaseSurveyTemplateItem> purchaseSurveyTemplateItemList) {
        if (StrUtil.isBlank((CharSequence)purchaseSurveyTemplateHead.getSurveyTemplateNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSurveyTemplateNumber", (Object)purchaseSurveyTemplateHead);
            purchaseSurveyTemplateHead.setSurveyTemplateNumber(nextCode);
        }
        this.purchaseSurveyTemplateHeadMapper.insert((Object)purchaseSurveyTemplateHead);
        this.insertData(purchaseSurveyTemplateHead, purchaseSurveyTemplateItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSurveyTemplateHead purchaseSurveyTemplateHead, List<PurchaseSurveyTemplateItem> purchaseSurveyTemplateItemList) {
        if (StrUtil.isBlank((CharSequence)purchaseSurveyTemplateHead.getSurveyTemplateNumber())) {
            String nextCode = this.invokeBaseRpcService.getNextCode("srmSurveyTemplateNumber", (Object)purchaseSurveyTemplateHead);
            purchaseSurveyTemplateHead.setSurveyTemplateNumber(nextCode);
        }
        this.purchaseSurveyTemplateHeadMapper.updateById((Object)purchaseSurveyTemplateHead);
        this.purchaseSurveyTemplateOptionMapper.deleteByMainId(purchaseSurveyTemplateHead.getId());
        this.purchaseSurveyTemplateItemMapper.deleteByMainId(purchaseSurveyTemplateHead.getId());
        this.insertData(purchaseSurveyTemplateHead, purchaseSurveyTemplateItemList);
    }

    @Override
    public void surveyAddTemplate(PurchaseSurveyHead purchaseSurveyHead, List<PurchaseSurveyLibrary> purchaseSurveyLibraryList, List<PurchaseSurveyItem> purchaseSurveyItemList) {
        PurchaseSurveyTemplateHead purchaseSurveyTemplateHead = new PurchaseSurveyTemplateHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSurveyHead), (Object)((Object)purchaseSurveyTemplateHead));
        purchaseSurveyTemplateHead.setId(null);
        purchaseSurveyTemplateHead.setSurveyTemplateName(purchaseSurveyHead.getSurveyName());
        purchaseSurveyTemplateHead.setSurveyTemplateVersion(1);
        purchaseSurveyTemplateHead.setTemplateDesc(purchaseSurveyHead.getSurveyDesc());
        purchaseSurveyTemplateHead.setTemplateType(purchaseSurveyHead.getSurveyType());
        List<PurchaseSurveyTemplateItem> collect = new ArrayList<PurchaseSurveyTemplateItem>();
        if (!CollectionUtils.isEmpty(purchaseSurveyLibraryList)) {
            collect = purchaseSurveyLibraryList.parallelStream().map(item -> {
                PurchaseSurveyTemplateItem purchaseSurveyTemplateItem = new PurchaseSurveyTemplateItem();
                BeanUtils.copyProperties((Object)item, (Object)((Object)purchaseSurveyTemplateItem));
                return purchaseSurveyTemplateItem;
            }).collect(Collectors.toList());
        }
        this.saveMain(purchaseSurveyTemplateHead, collect);
    }

    private void insertData(PurchaseSurveyTemplateHead purchaseSurveyTemplateHead, List<PurchaseSurveyTemplateItem> purchaseSurveyTemplateItemList) {
        if (!CollectionUtils.isEmpty(purchaseSurveyTemplateItemList)) {
            for (PurchaseSurveyTemplateItem entity : purchaseSurveyTemplateItemList) {
                entity.setHeadId(purchaseSurveyTemplateHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSurveyTemplateHead);
                entity.setId(IdWorker.getIdStr());
                entity.setElsAccount(purchaseSurveyTemplateHead.getElsAccount());
                List<PurchaseSurveyTemplateOption> purchaseSurveyOptionList = entity.getPurchaseSurveyTemplateOptionList();
                if (CollectionUtils.isEmpty(purchaseSurveyOptionList)) continue;
                purchaseSurveyOptionList.forEach(item -> {
                    item.setHeadId(entity.getId());
                    item.setElsAccount(entity.getElsAccount());
                    item.setDeleted(CommonConstant.DEL_FLAG_0);
                });
                this.purchaseSurveyTemplateOptionMapper.insertBatchSomeColumn(purchaseSurveyOptionList);
            }
            if (!purchaseSurveyTemplateItemList.isEmpty()) {
                this.purchaseSurveyTemplateItemMapper.insertBatchSomeColumn(purchaseSurveyTemplateItemList);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSurveyTemplateItemMapper.deleteByMainId(id);
        this.purchaseSurveyTemplateHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSurveyTemplateItemMapper.deleteByMainId(serializable.toString());
            this.purchaseSurveyTemplateHeadMapper.deleteById(serializable);
        }
    }
}

