/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.log.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.log.entity.Log;
import com.els.modules.log.mapper.LogMapper;
import com.els.modules.log.rpc.service.MessageInvokeSupplierRpcService;
import com.els.modules.log.service.LogDetailService;
import com.els.modules.log.service.LogService;
import com.els.modules.log.vo.LogVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class LogServiceImpl
extends ServiceImpl<LogMapper, Log>
implements LogService {
    private static final Logger log = LoggerFactory.getLogger(LogServiceImpl.class);
    @Resource
    private LogMapper logMapper;
    @Resource
    private MessageInvokeSupplierRpcService messageInvokeSupplierRpcService;
    @Resource
    private LogDetailService logDetailService;

    @Override
    @Async
    public void saveLog(Log sysLog) {
        this.save(sysLog);
    }

    @Override
    public Long countSupplierLoginList(LogVO logVO) {
        List<SupplierMasterDataDTO> supplierList = this.messageInvokeSupplierRpcService.findSupplierList(TenantContext.getTenant(), logVO.getSupplierName());
        if (supplierList.isEmpty()) {
            return 0L;
        }
        List<String> toElsAccountList = supplierList.stream().map(SupplierMasterDataDTO::getToElsAccount).collect(Collectors.toList());
        logVO.setToElsAccountList(toElsAccountList);
        return this.logMapper.findSupplierLoginListCount(logVO);
    }

    @Override
    public List<LogVO> findModuleOptList(LogVO logVO) {
        return this.logMapper.findModuleOptList(logVO);
    }

    @Override
    public List<LogVO> findUserLoginList(LogVO logVO) {
        return this.logMapper.findUserLoginList(logVO);
    }

    @Override
    public void clearLog(int days) {
        Date currentDate = new Date();
        DateTime clearDate = DateUtil.offsetDay((Date)currentDate, (int)(-days));
        List logIdList = this.list((Wrapper)new QueryWrapper().select(new String[]{"id"}).lt((Object)"create_time", (Object)clearDate));
        log.info("\u67e5\u8be2\u5230 " + logIdList.size() + "\u6761\u5f85\u6e05\u7406\u7684\u65e5\u5fd7\uff0c\u5f00\u59cb\u6267\u884c\u6e05\u7406...");
        for (Log log : logIdList) {
            this.logMapper.halfDeleteById(log.getId());
            this.logDetailService.remove((Wrapper)new QueryWrapper().eq((Object)"head_id", (Object)log.getId()));
        }
    }

    @Override
    public List<LogVO> exportSupplierLoginList(LogVO logVO) {
        List<SupplierMasterDataDTO> supplierList = this.messageInvokeSupplierRpcService.findSupplierList(TenantContext.getTenant(), logVO.getSupplierName());
        if (supplierList.isEmpty()) {
            return new ArrayList<LogVO>();
        }
        List<String> toElsAccountList = supplierList.stream().map(SupplierMasterDataDTO::getToElsAccount).collect(Collectors.toList());
        Map<String, List<SupplierMasterDataDTO>> map = supplierList.stream().collect(Collectors.groupingBy(SupplierMasterDataDTO::getToElsAccount));
        logVO.setToElsAccountList(toElsAccountList);
        List<LogVO> list = this.logMapper.exportSupplierLoginList(logVO);
        for (LogVO vo : list) {
            vo.setToElsAccount(vo.getElsAccount());
            List<SupplierMasterDataDTO> itemList = map.get(vo.getElsAccount());
            if (itemList == null || itemList.size() <= 0) continue;
            vo.setSupplierName(itemList.get(0).getSupplierName());
        }
        return list;
    }

    @Override
    public IPage<Log> selectPageList(LogVO logVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        Page page = new Page((long)logVO.getPageNo().intValue(), (long)logVO.getPageSize().intValue());
        List<SupplierMasterDataDTO> supplierList = this.messageInvokeSupplierRpcService.findSupplierList(TenantContext.getTenant(), logVO.getSupplierName());
        if (supplierList.isEmpty()) {
            return page;
        }
        List toElsAccountList = supplierList.stream().map(SupplierMasterDataDTO::getToElsAccount).collect(Collectors.toList());
        queryWrapper.lambda().eq(StrUtil.isNotBlank((CharSequence)logVO.getLogMonth()), Log::getLogMonth, (Object)logVO.getLogMonth());
        queryWrapper.lambda().in(Log::getElsAccount, toElsAccountList);
        IPage<Log> iPage = ((LogMapper)this.baseMapper).selectPageList((Page<Log>)page, (QueryWrapper<Log>)queryWrapper);
        Map<String, List<SupplierMasterDataDTO>> map = supplierList.stream().collect(Collectors.groupingBy(SupplierMasterDataDTO::getToElsAccount));
        List logList = iPage.getRecords();
        for (Log vo : logList) {
            vo.setToElsAccount(vo.getElsAccount());
            List<SupplierMasterDataDTO> itemList = map.get(vo.getElsAccount());
            if (itemList == null || itemList.size() <= 0) continue;
            vo.setSupplierName(itemList.get(0).getSupplierName());
        }
        return iPage;
    }
}

