/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.rpc.service.MessageInvokeAccountService;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.service.MsgConfigBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MsgConfigBuilderImpl
implements MsgConfigBuilder {
    @Resource
    private ElsMsgConfigHeadService elsMsgConfigHeadService;
    @Resource
    private ElsMsgConfigItemService elsMsgConfigItemService;
    @Resource
    private MessageInvokeAccountService accountDubboService;

    @Override
    public List<ElsMsgConfigItem> loadMsgConfigItem(String type, String headId, List<String> busAccountList, String businessType, String operateType) {
        switch (type = CharSequenceUtil.blankToDefault((CharSequence)type, (String)"db")) {
            case "db": {
                return this.getMsgConfigItemListFromDb(headId, busAccountList, businessType, operateType);
            }
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ElsMsgConfigItem> loadMsgConfigItemListByBusAccount(String type, String headId, String busAccount, String businessType, String operateType) {
        switch (type = CharSequenceUtil.blankToDefault((CharSequence)type, (String)"db")) {
            case "db": {
                return this.getMsgConfigItemListByBusAccount(headId, busAccount, businessType, operateType);
            }
        }
        return Lists.newArrayList();
    }

    @Override
    public List<String> supportMsgType(String type) {
        switch (type = CharSequenceUtil.blankToDefault((CharSequence)type, (String)"db")) {
            case "db": {
                return Arrays.stream(SendMsgTypeEnum.values()).map(SendMsgTypeEnum::getType).collect(Collectors.toList());
            }
            case "im": {
                return Lists.newArrayList((Object[])new String[]{"2", "3", "4", "5", "6", "7", "8"});
            }
        }
        return Lists.newArrayList((Object[])new String[]{"1"});
    }

    private List<ElsMsgConfigItem> getMsgConfigItemListFromDb(String headId, List<String> busAccountList, String businessType, String operateType) {
        List resultList;
        if (StrUtil.isNotBlank((CharSequence)headId) && !(resultList = this.elsMsgConfigItemService.selectByMainId(headId)).isEmpty()) {
            return resultList;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)businessType)).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).in(BaseEntity::getElsAccount, busAccountList);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        Assert.notEmpty((Collection)configHeadList, (String)I18nUtil.translate((String)"", (String)(businessType + "_" + operateType + ":\u672a\u627e\u5230\u6d88\u606f\u914d\u7f6e\uff01")));
        List headIdList = configHeadList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.in(ElsMsgConfigItem::getHeadId, headIdList);
        resultList = this.elsMsgConfigItemService.list((Wrapper)wrapper);
        return resultList;
    }

    private List<ElsMsgConfigItem> getMsgConfigItemListByBusAccount(String headId, String busAccount, String businessType, String operateType) {
        List<Object> resultList = new ArrayList();
        if (StrUtil.isNotBlank((CharSequence)headId) && !(resultList = this.elsMsgConfigItemService.selectByMainId(headId)).isEmpty()) {
            return resultList;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ElsMsgConfigHead::getBusinessType, (Object)businessType)).eq(ElsMsgConfigHead::getOperateType, (Object)operateType)).eq(BaseEntity::getElsAccount, (Object)busAccount);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)configHeadList)) {
            return Lists.newArrayList();
        }
        List<ElsMsgConfigItem> configItemList = this.elsMsgConfigItemService.selectByMainId(((ElsMsgConfigHead)((Object)configHeadList.get(0))).getId());
        HashMap<String, String> distinctMap = new HashMap<String, String>();
        for (ElsMsgConfigItem item : configItemList) {
            if (distinctMap.containsKey(item.getMsgType())) continue;
            resultList.add((Object)item);
            distinctMap.put(item.getMsgType(), item.getMsgType());
        }
        return resultList;
    }
}

