/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.delivery.api.dto.PurchaseDeliveryItemDTO;
import com.els.modules.delivery.api.service.DeliveryItemRpcService;
import com.els.modules.eightReport.enumerate.BuTypeEnum;
import com.els.modules.extend.api.dto.delivery.PurchaseVoucherItemSimpleExtDTO;
import com.els.modules.extend.api.dto.jit.JitPackagingMaterialsBoardDTO;
import com.els.modules.extend.api.dto.order.PurchaseOrderDeliveryPlanSimpleExtendDTO;
import com.els.modules.extend.api.dto.order.PurchaseOrderItemSimpleExtDTO;
import com.els.modules.extend.api.service.delivery.PurchaseVoucherItemExtendService;
import com.els.modules.extend.api.service.jit.JitPackagingMaterialsBoardExtendRpcService;
import com.els.modules.extend.api.service.material.PurchaseMaterialHeadExtRpcService;
import com.els.modules.extend.api.service.order.PurchaseOrderItemExtendService;
import com.els.modules.extend.api.service.supplier.SupplierMasterCustom1ExtendRpcService;
import com.els.modules.report.entity.PurchasePerformanceDetailReport;
import com.els.modules.report.enumerate.PerformanceDeduceResultEnum;
import com.els.modules.report.enumerate.QuantityDeduceResultEnum;
import com.els.modules.report.enumerate.TimeDeduceResultEnum;
import com.els.modules.report.rpc.service.InvokeOrderRpcService;
import com.els.modules.report.rpc.service.ReportInvokeSupplierRpcService;
import com.els.modules.report.service.PurchasePerformanceDetailReportService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="performanceDetailScheduleJob")
public class PerformanceDetailScheduleJob
implements JobRpcService {
    private final Integer pageSize = 100;
    private static final Logger logger = LoggerFactory.getLogger(PerformanceDetailScheduleJob.class);
    @Autowired
    private PurchasePerformanceDetailReportService purchasePerformanceDetailReportService;
    @Resource
    private PurchaseMaterialHeadExtRpcService purchaseMaterialHeadExtRpcService;
    @Autowired
    private PlatformTransactionManager txManager;
    @Autowired
    private RedisUtil redisUtil;
    private final String LOCK_PREFIX = "performanceDetail_schedule_";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private InvokeOrderRpcService invokeOrderRpcService;
    @Autowired
    @Qualifier(value="reportInvokerSupplierRpcServiceImplReport")
    private ReportInvokeSupplierRpcService reportInvokeSupplierRpcService;
    @Resource
    private SupplierMasterCustom1ExtendRpcService supplierMasterCustom1ExtRpcService;
    @Resource
    private JitPackagingMaterialsBoardExtendRpcService jitPackagingMaterialsBoardExtendRpcService;
    @Resource
    private PurchaseOrderItemExtendService purchaseOrderItemExtendService;
    @Resource
    private PurchaseVoucherItemExtendService purchaseVoucherItemExtendService;
    @Resource
    private DeliveryItemRpcService purchaseDeliveryItemRpcService;

    @Async
    public void execute(String parameter) {
        String requestId;
        String lockKey;
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        if (!this.redisUtil.tryGetDistributedLock(lockKey = "performanceDetail_schedule_" + paramObj.getString("tenantId"), requestId = UUID.randomUUID().toString(), 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tXRHiKRcsWVxPVBRc_ec23d2d0", (String)"\u7ee9\u6548\u660e\u7ec6\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            logger.info(" \u7ee9\u6548\u62a5\u8868\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1 PerformanceDetailScheduleJob \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
            TenantContext.setTenant((String)tenantId);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)tenantId);
            this.purchasePerformanceDetailReportService.remove((Wrapper)queryWrapper);
            List<Integer> betweenYear = this.getBetweenYear(2024);
            for (Integer year : betweenYear) {
                LocalDate current = LocalDate.now();
                Integer currentYear = current.getYear();
                int quarter = 4;
                if (year.compareTo(currentYear) == 0) {
                    quarter = (current.getMonthValue() - 1) / 3 + 1;
                }
                for (int i = 1; i < quarter + 1; ++i) {
                    String startTime = this.getQuarterDates(year, i, true);
                    String endTime = this.getQuarterDates(year, i, false);
                    this.processPerformanceDetail(startTime, endTime, year, i);
                }
            }
            logger.info(" \u7ee9\u6548\u62a5\u8868\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1 PerformanceDetailScheduleJob \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            logger.info(Thread.currentThread().getName() + "\u5904\u7406\u4ea4\u8d27\u8ba1\u5212\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock(lockKey, requestId);
        }
        this.txManager.commit(status);
    }

    public void processPerformanceDetail(String startTime, String endTime, Integer year, Integer quarter) {
        HashMap<String, List<PurchaseVoucherItemSimpleExtDTO>> groupVoucherMap;
        List voucherItemList;
        List listGroup;
        List orderMasterCustom1ExtendDTOS;
        List delievryMasterCustom1ExtendDTOS;
        List<Object> jitElsAccountList = new ArrayList();
        List<Object> delievryElsAccountList = new ArrayList();
        List<Object> orderElsAccountList = new ArrayList();
        List jitMasterCustom1ExtendDTOS = this.supplierMasterCustom1ExtRpcService.selectJitSupplerList();
        if (CollectionUtil.isNotEmpty((Collection)jitMasterCustom1ExtendDTOS) && CollectionUtil.isNotEmpty(jitElsAccountList = jitMasterCustom1ExtendDTOS.stream().map(BaseDTO::getElsAccount).collect(Collectors.toList()))) {
            jitElsAccountList = jitElsAccountList.stream().distinct().collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty((Collection)(delievryMasterCustom1ExtendDTOS = this.supplierMasterCustom1ExtRpcService.selectDeliveryModeSupplerList("A001-DS"))) && CollectionUtil.isNotEmpty(delievryElsAccountList = delievryMasterCustom1ExtendDTOS.stream().map(BaseDTO::getElsAccount).collect(Collectors.toList()))) {
            delievryElsAccountList = delievryElsAccountList.stream().distinct().collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty((Collection)(orderMasterCustom1ExtendDTOS = this.supplierMasterCustom1ExtRpcService.selectDeliveryModeSupplerList("A002-DD"))) && CollectionUtil.isNotEmpty(orderElsAccountList = orderMasterCustom1ExtendDTOS.stream().map(BaseDTO::getElsAccount).collect(Collectors.toList()))) {
            orderElsAccountList = orderElsAccountList.stream().distinct().collect(Collectors.toList());
        }
        ArrayList<PurchasePerformanceDetailReport> performanceDetailReports = new ArrayList<PurchasePerformanceDetailReport>();
        if (CollectionUtil.isNotEmpty(jitElsAccountList)) {
            listGroup = ListUtil.partition(jitElsAccountList, (int)500);
            for (List jitElsAccounts : listGroup) {
                List jitBoardList;
                voucherItemList = this.purchaseVoucherItemExtendService.selectListByToElsAccounts(jitElsAccounts, startTime, endTime);
                groupVoucherMap = new HashMap();
                if (CollectionUtil.isNotEmpty((Collection)voucherItemList)) {
                    groupVoucherMap = voucherItemList.stream().collect(Collectors.groupingBy(o -> o.getOrderNumber() + "_" + o.getMaterialNumber() + "_" + DateUtils.formatDate((Date)o.getVoucherDate(), (String)"yyyy-MM-dd")));
                }
                if (!CollectionUtil.isNotEmpty((Collection)(jitBoardList = this.jitPackagingMaterialsBoardExtendRpcService.selectJitListByToElsAccounts(jitElsAccounts, startTime, endTime)))) continue;
                List<PurchasePerformanceDetailReport> jitReportList = this.procseeJitPerformanceDetailReport(groupVoucherMap, jitBoardList);
                performanceDetailReports.addAll(jitReportList);
            }
        }
        if (CollectionUtil.isNotEmpty(delievryElsAccountList)) {
            listGroup = ListUtil.partition(delievryElsAccountList, (int)500);
            for (List delievryElsAccouts : listGroup) {
                voucherItemList = this.purchaseVoucherItemExtendService.selectListByToElsAccounts(delievryElsAccouts, startTime, endTime);
                List<PurchaseDeliveryItemDTO> deliveryItemList = this.getPurchaseDeliveryItemList(voucherItemList);
                Map<String, List<PurchaseVoucherItemSimpleExtDTO>> voucherItemExistDeliveryPlanGroup = this.getVoucherItemExistDeliveryPlan(voucherItemList, deliveryItemList);
                List deliveryPlanList = this.purchaseOrderItemExtendService.selectDeliveryPlanItemByToElsAccounts(delievryElsAccouts, startTime, endTime);
                if (!CollectionUtil.isNotEmpty((Collection)deliveryPlanList)) continue;
                List<PurchasePerformanceDetailReport> deliveryPlanReportList = this.processDeliveryPlanPerformanceDetailReport(voucherItemExistDeliveryPlanGroup, deliveryPlanList);
                performanceDetailReports.addAll(deliveryPlanReportList);
            }
        }
        if (CollectionUtil.isNotEmpty(orderElsAccountList)) {
            listGroup = ListUtil.partition(orderElsAccountList, (int)500);
            for (List orderElsAccouts : listGroup) {
                List orderItemList;
                voucherItemList = this.purchaseVoucherItemExtendService.selectListByToElsAccounts(orderElsAccouts, startTime, endTime);
                groupVoucherMap = new HashMap();
                if (CollectionUtil.isNotEmpty((Collection)voucherItemList)) {
                    groupVoucherMap = voucherItemList.stream().collect(Collectors.groupingBy(o -> o.getOrderNumber() + "_" + o.getOrderItemNumber()));
                }
                if (!CollectionUtil.isNotEmpty((Collection)(orderItemList = this.purchaseOrderItemExtendService.selectOrderItemByToElsAccounts(orderElsAccouts, startTime, endTime)))) continue;
                List<PurchasePerformanceDetailReport> orderItemReportList = this.processOrderItemPerformanceDeatil(groupVoucherMap, orderItemList);
                performanceDetailReports.addAll(orderItemReportList);
            }
        }
        if (CollectionUtil.isNotEmpty(performanceDetailReports)) {
            List materialNumbers = performanceDetailReports.stream().map(PurchasePerformanceDetailReport::getMaterialNumber).collect(Collectors.toList());
            Map productGroupMap = this.purchaseMaterialHeadExtRpcService.getProductGroupByMaterialNumbers(materialNumbers);
            Map productLineMap = this.purchaseMaterialHeadExtRpcService.getProductLineByMaterialNumbers(materialNumbers);
            for (PurchasePerformanceDetailReport performanceDetailReport : performanceDetailReports) {
                performanceDetailReport.setParticularYear(String.valueOf(year));
                performanceDetailReport.setParticularQuarter(String.valueOf(quarter));
                String productGroup = (String)productGroupMap.get(performanceDetailReport.getMaterialNumber());
                String productLine = (String)productLineMap.get(performanceDetailReport.getMaterialNumber() + "_" + performanceDetailReport.getFactory());
                String buValue = null;
                if (StringUtils.isNotBlank((CharSequence)productGroup)) {
                    buValue = productGroup;
                }
                if (StringUtils.isNotBlank((CharSequence)productLine)) {
                    buValue = StringUtils.isNotBlank((CharSequence)productLine) ? productLine : buValue + productLine;
                }
                if (StringUtils.isNotBlank((CharSequence)buValue)) {
                    performanceDetailReport.setBu(BuTypeEnum.getDesc((String)buValue));
                }
                if (null != performanceDetailReport.getDifDate()) {
                    if (performanceDetailReport.getDifDate() >= 0) {
                        performanceDetailReport.setOtdDeliveryScore(new BigDecimal("100"));
                    } else if (performanceDetailReport.getDifDate() == -1) {
                        performanceDetailReport.setOtdDeliveryScore(new BigDecimal("80"));
                    } else if (performanceDetailReport.getDifDate() == -2) {
                        performanceDetailReport.setOtdDeliveryScore(new BigDecimal("60"));
                    } else if (performanceDetailReport.getDifDate() == -3) {
                        performanceDetailReport.setOtdDeliveryScore(new BigDecimal("40"));
                    } else if (performanceDetailReport.getDifDate() == -4) {
                        performanceDetailReport.setOtdDeliveryScore(new BigDecimal("20"));
                    } else if (performanceDetailReport.getDifDate() <= -5) {
                        performanceDetailReport.setOtdDeliveryScore(new BigDecimal("0"));
                    }
                }
                if (performanceDetailReport.getReceiceQuantity() != null && performanceDetailReport.getQuantity() != null && performanceDetailReport.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal deliveryQuantityScore = performanceDetailReport.getReceiceQuantity().divide(performanceDetailReport.getQuantity(), 1, 4);
                    performanceDetailReport.setDeliveryQuantityScore(deliveryQuantityScore);
                    if (performanceDetailReport.getDeliveryQuantityScore().compareTo(BigDecimal.ONE) > 0) {
                        performanceDetailReport.setDeliveryQuantityScore(BigDecimal.ONE);
                    }
                }
                if (performanceDetailReport.getDeliveryQuantityScore() == null || performanceDetailReport.getOtdDeliveryScore() == null) continue;
                BigDecimal otdFinalScore = performanceDetailReport.getDeliveryQuantityScore().multiply(performanceDetailReport.getOtdDeliveryScore()).multiply(new BigDecimal("0.2"));
                performanceDetailReport.setOtdFinalScore(otdFinalScore);
            }
            this.purchasePerformanceDetailReportService.saveBatch(performanceDetailReports, 1000);
        }
    }

    private List<PurchasePerformanceDetailReport> processOrderItemPerformanceDeatil(Map<String, List<PurchaseVoucherItemSimpleExtDTO>> groupVoucherMap, List<PurchaseOrderItemSimpleExtDTO> orderItemList) {
        ArrayList<PurchasePerformanceDetailReport> purchasePerformanceDetailReports = new ArrayList<PurchasePerformanceDetailReport>();
        for (PurchaseOrderItemSimpleExtDTO orderItemExtDTO : orderItemList) {
            PurchasePerformanceDetailReport purchasePerformanceDetailReport = new PurchasePerformanceDetailReport();
            purchasePerformanceDetailReport.setId(IdWorker.getIdStr());
            purchasePerformanceDetailReport.setSourceType("purchaseOrderItem");
            purchasePerformanceDetailReport.setElsAccount(TenantContext.getTenant());
            purchasePerformanceDetailReport.setDeleted(Integer.valueOf(Integer.parseInt("0")));
            purchasePerformanceDetailReport.setOrderNumber(orderItemExtDTO.getOrderNumber());
            purchasePerformanceDetailReport.setOrderItemNumber(orderItemExtDTO.getItemNumber());
            purchasePerformanceDetailReport.setToElsAccount(orderItemExtDTO.getToElsAccount());
            purchasePerformanceDetailReport.setSupplierCode(orderItemExtDTO.getSupplierCode());
            purchasePerformanceDetailReport.setSupplierName(orderItemExtDTO.getSupplierName());
            purchasePerformanceDetailReport.setMaterialNumber(orderItemExtDTO.getMaterialNumber());
            purchasePerformanceDetailReport.setQuantity(orderItemExtDTO.getQuantity());
            purchasePerformanceDetailReport.setArriveDate(orderItemExtDTO.getRequireDate());
            purchasePerformanceDetailReport.setCompany(orderItemExtDTO.getCompany());
            purchasePerformanceDetailReport.setFactory(orderItemExtDTO.getFactory());
            purchasePerformanceDetailReport.setMaterialDesc(StringUtils.isNotBlank((CharSequence)orderItemExtDTO.getMaterialName()) ? orderItemExtDTO.getMaterialName() : orderItemExtDTO.getMaterialDesc());
            List<PurchaseVoucherItemSimpleExtDTO> voucherItems = groupVoucherMap.get(orderItemExtDTO.getOrderNumber() + "_" + orderItemExtDTO.getItemNumber());
            this.processPerformanceWithVoucherItems(purchasePerformanceDetailReport, voucherItems);
            purchasePerformanceDetailReports.add(purchasePerformanceDetailReport);
        }
        return purchasePerformanceDetailReports;
    }

    private List<PurchasePerformanceDetailReport> processDeliveryPlanPerformanceDetailReport(Map<String, List<PurchaseVoucherItemSimpleExtDTO>> voucherItemExistDeliveryPlanGroup, List<PurchaseOrderDeliveryPlanSimpleExtendDTO> deliveryPlanList) {
        ArrayList<PurchasePerformanceDetailReport> purchasePerformanceDetailReports = new ArrayList<PurchasePerformanceDetailReport>();
        for (PurchaseOrderDeliveryPlanSimpleExtendDTO deliveryPlan : deliveryPlanList) {
            PurchasePerformanceDetailReport purchasePerformanceDetailReport = new PurchasePerformanceDetailReport();
            purchasePerformanceDetailReport.setId(IdWorker.getIdStr());
            purchasePerformanceDetailReport.setSourceType("deliveryPlan");
            purchasePerformanceDetailReport.setElsAccount(TenantContext.getTenant());
            purchasePerformanceDetailReport.setDeleted(Integer.valueOf(Integer.parseInt("0")));
            purchasePerformanceDetailReport.setOrderNumber(deliveryPlan.getOrderNumber());
            purchasePerformanceDetailReport.setOrderItemNumber(deliveryPlan.getOrderItemNumber());
            purchasePerformanceDetailReport.setFbk1(deliveryPlan.getItemNumber());
            purchasePerformanceDetailReport.setToElsAccount(deliveryPlan.getToElsAccount());
            purchasePerformanceDetailReport.setSupplierCode(deliveryPlan.getSupplierCode());
            purchasePerformanceDetailReport.setSupplierName(deliveryPlan.getSupplierName());
            purchasePerformanceDetailReport.setMaterialNumber(deliveryPlan.getMaterialNumber());
            purchasePerformanceDetailReport.setQuantity(deliveryPlan.getPlanDeliveryQuantity());
            purchasePerformanceDetailReport.setArriveDate(deliveryPlan.getPlanDeliveryDate());
            purchasePerformanceDetailReport.setCompany(deliveryPlan.getCompany());
            purchasePerformanceDetailReport.setMaterialDesc(deliveryPlan.getMaterialDesc());
            purchasePerformanceDetailReport.setFactory(deliveryPlan.getFactory());
            List<PurchaseVoucherItemSimpleExtDTO> voucherItems = voucherItemExistDeliveryPlanGroup.get(deliveryPlan.getId());
            this.processPerformanceWithVoucherItems(purchasePerformanceDetailReport, voucherItems);
            purchasePerformanceDetailReports.add(purchasePerformanceDetailReport);
        }
        return purchasePerformanceDetailReports;
    }

    private List<PurchasePerformanceDetailReport> procseeJitPerformanceDetailReport(Map<String, List<PurchaseVoucherItemSimpleExtDTO>> groupVoucherMap, List<JitPackagingMaterialsBoardDTO> jitBoardList) {
        ArrayList<PurchasePerformanceDetailReport> purchasePerformanceDetailReports = new ArrayList<PurchasePerformanceDetailReport>();
        Map<String, List<JitPackagingMaterialsBoardDTO>> groupJitMap = jitBoardList.stream().collect(Collectors.groupingBy(o -> o.getMatchOrderNumber() + "_" + o.getMatnr() + "_" + o.getFbk1()));
        for (Map.Entry<String, List<JitPackagingMaterialsBoardDTO>> entry : groupJitMap.entrySet()) {
            List<JitPackagingMaterialsBoardDTO> jitMergeList = entry.getValue();
            PurchasePerformanceDetailReport purchasePerformanceDetailReport = new PurchasePerformanceDetailReport();
            purchasePerformanceDetailReport.setId(IdWorker.getIdStr());
            purchasePerformanceDetailReport.setSourceType("jitPackagingMaterialsBoard");
            purchasePerformanceDetailReport.setElsAccount(TenantContext.getTenant());
            purchasePerformanceDetailReport.setDeleted(Integer.valueOf(Integer.parseInt("0")));
            purchasePerformanceDetailReport.setOrderNumber(jitMergeList.get(0).getMatchOrderNumber());
            purchasePerformanceDetailReport.setToElsAccount(jitMergeList.get(0).getToElsAccount());
            purchasePerformanceDetailReport.setSupplierCode(jitMergeList.get(0).getSupplierCode());
            purchasePerformanceDetailReport.setSupplierName(jitMergeList.get(0).getSupplierName());
            purchasePerformanceDetailReport.setMaterialNumber(jitMergeList.get(0).getMatnr());
            purchasePerformanceDetailReport.setFactory(jitMergeList.get(0).getWerks());
            BigDecimal mergeJitQuantity = jitMergeList.stream().filter(Objects::nonNull).map(JitPackagingMaterialsBoardDTO::getBdmng).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchasePerformanceDetailReport.setQuantity(mergeJitQuantity);
            try {
                purchasePerformanceDetailReport.setArriveDate(DateUtils.parseDate((String)jitMergeList.get(0).getFbk1(), (String)"yyyy-MM-dd"));
            }
            catch (Exception e) {
                logger.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a" + e);
            }
            List<PurchaseVoucherItemSimpleExtDTO> voucherItems = groupVoucherMap.get(entry.getKey());
            this.processPerformanceWithVoucherItems(purchasePerformanceDetailReport, voucherItems);
            purchasePerformanceDetailReports.add(purchasePerformanceDetailReport);
        }
        return purchasePerformanceDetailReports;
    }

    private void processPerformanceWithVoucherItems(PurchasePerformanceDetailReport purchasePerformanceDetailReport, List<PurchaseVoucherItemSimpleExtDTO> voucherItems) {
        if (CollectionUtil.isNotEmpty(voucherItems)) {
            BigDecimal mergeVoucherQuantity = voucherItems.stream().filter(Objects::nonNull).map(PurchaseVoucherItemSimpleExtDTO::getVoucherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            purchasePerformanceDetailReport.setReceiceQuantity(mergeVoucherQuantity);
            if (StringUtils.isBlank((CharSequence)purchasePerformanceDetailReport.getMaterialDesc())) {
                purchasePerformanceDetailReport.setMaterialDesc(voucherItems.get(0).getMaterialName());
            }
            if (StringUtils.isBlank((CharSequence)purchasePerformanceDetailReport.getCompany())) {
                purchasePerformanceDetailReport.setMaterialDesc(voucherItems.get(0).getCompany());
            }
            purchasePerformanceDetailReport.setPostDate(this.getMaxDateFromVoucherItem(voucherItems));
            purchasePerformanceDetailReport.setDifQuantity(Integer.valueOf(mergeVoucherQuantity.subtract(purchasePerformanceDetailReport.getQuantity()).intValue()));
            Long difDate = this.getDifDate(purchasePerformanceDetailReport);
            purchasePerformanceDetailReport.setDifDate(Integer.valueOf(difDate.intValue()));
            purchasePerformanceDetailReport.setQuantityDeduce(this.quantityDeduce(purchasePerformanceDetailReport));
            purchasePerformanceDetailReport.setTimeDeduce(this.timeDeduce(difDate));
            purchasePerformanceDetailReport.setPerformanceDeduce(this.performanceDeduce(purchasePerformanceDetailReport));
            String voucherNumberStr = voucherItems.stream().map(o -> o.getVoucherNumber() + "_" + o.getItemNumber()).collect(Collectors.joining(","));
            purchasePerformanceDetailReport.setFbk2(voucherNumberStr);
        } else {
            purchasePerformanceDetailReport.setQuantityDeduce(QuantityDeduceResultEnum.UN_ACCEPTABLE.getValue());
            purchasePerformanceDetailReport.setTimeDeduce(TimeDeduceResultEnum.DELAY.getValue());
            purchasePerformanceDetailReport.setPerformanceDeduce(PerformanceDeduceResultEnum.UN_ACCEPTABLE.getValue());
        }
    }

    private Long getDifDate(PurchasePerformanceDetailReport purchasePerformanceDetailReport) {
        Long difDate = DateUtil.between((Date)purchasePerformanceDetailReport.getPostDate(), (Date)purchasePerformanceDetailReport.getArriveDate(), (DateUnit)DateUnit.DAY, (boolean)false);
        return difDate;
    }

    public String timeDeduce(Long difDate) {
        if (difDate == null) {
            return TimeDeduceResultEnum.DELAY.getValue();
        }
        if (difDate > 0L) {
            return TimeDeduceResultEnum.PREP.getValue();
        }
        if (difDate < 0L) {
            return TimeDeduceResultEnum.DELAY.getValue();
        }
        if (difDate == 0L) {
            return TimeDeduceResultEnum.ACCEPTABLE.getValue();
        }
        return TimeDeduceResultEnum.DELAY.getValue();
    }

    private String quantityDeduce(PurchasePerformanceDetailReport purchasePerformanceDetailReport) {
        BigDecimal quantity = purchasePerformanceDetailReport.getQuantity();
        BigDecimal receiveQuantity = purchasePerformanceDetailReport.getReceiceQuantity();
        if (quantity == null || receiveQuantity == null) {
            return QuantityDeduceResultEnum.UN_ACCEPTABLE.getValue();
        }
        if (receiveQuantity.compareTo(quantity) >= 0) {
            return QuantityDeduceResultEnum.ACCEPTABLE.getValue();
        }
        return QuantityDeduceResultEnum.UN_ACCEPTABLE.getValue();
    }

    private String performanceDeduce(PurchasePerformanceDetailReport purchasePerformanceDetailReport) {
        String quantityDeduce = purchasePerformanceDetailReport.getQuantityDeduce();
        String timeDeduce = purchasePerformanceDetailReport.getTimeDeduce();
        if ((TimeDeduceResultEnum.ACCEPTABLE.getValue().equals(timeDeduce) || TimeDeduceResultEnum.PREP.getValue().equals(timeDeduce)) && QuantityDeduceResultEnum.ACCEPTABLE.getValue().equals(quantityDeduce)) {
            return PerformanceDeduceResultEnum.ACCEPTABLE.getValue();
        }
        return PerformanceDeduceResultEnum.UN_ACCEPTABLE.getValue();
    }

    public Date getMaxDateFromVoucherItem(List<PurchaseVoucherItemSimpleExtDTO> list) {
        Date maxDate = null;
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        for (PurchaseVoucherItemSimpleExtDTO head : list) {
            if (head.getVoucherDate() == null) continue;
            if (maxDate == null && head.getVoucherDate() != null) {
                maxDate = head.getVoucherDate();
                continue;
            }
            if (head.getVoucherDate() == null || maxDate == null || head.getVoucherDate().compareTo(maxDate) <= 0) continue;
            maxDate = head.getVoucherDate();
        }
        return maxDate;
    }

    private String getQuarterDates(int year, int quarter, boolean isStart) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, (quarter - 1) * 3);
        calendar.set(5, 1);
        if (isStart) {
            Date startDate = calendar.getTime();
            return DateUtils.formatDate((Date)startDate, (String)"yyyy-MM-dd");
        }
        calendar.add(2, 2);
        calendar.set(5, calendar.getActualMaximum(5));
        Date endDate = calendar.getTime();
        return DateUtils.formatDate((Date)endDate, (String)"yyyy-MM-dd");
    }

    private List<Integer> getBetweenYear(int startYear) {
        Calendar calendar = Calendar.getInstance();
        int endYear = calendar.get(1);
        ArrayList<Integer> yearList = new ArrayList<Integer>();
        for (int year = startYear; year <= endYear; ++year) {
            yearList.add(year);
        }
        return yearList;
    }

    private Map<String, List<PurchaseVoucherItemSimpleExtDTO>> getVoucherItemExistDeliveryPlan(List<PurchaseVoucherItemSimpleExtDTO> voucherItemList, List<PurchaseDeliveryItemDTO> deliveryItemList) {
        HashMap<String, List<PurchaseVoucherItemSimpleExtDTO>> groupVoucherMap = new HashMap<String, List<PurchaseVoucherItemSimpleExtDTO>>();
        if (CollectionUtil.isNotEmpty(deliveryItemList)) {
            Map<String, List<PurchaseDeliveryItemDTO>> deliveryItemGroup = deliveryItemList.stream().collect(Collectors.groupingBy(o -> o.getDeliveryNumber() + "_" + o.getItemNumber()));
            for (PurchaseVoucherItemSimpleExtDTO voucherItem : voucherItemList) {
                List<PurchaseDeliveryItemDTO> deliveryItemDTOS = deliveryItemGroup.get(voucherItem.getDeliveryNumber() + "_" + voucherItem.getDeliveryItemNumber());
                if (!CollectionUtil.isNotEmpty(deliveryItemDTOS)) continue;
                PurchaseDeliveryItemDTO deliveryItemDTO = deliveryItemDTOS.get(0);
                if (groupVoucherMap.containsKey(deliveryItemDTO.getSourceItemId())) {
                    ((List)groupVoucherMap.get(deliveryItemDTO.getSourceItemId())).add(voucherItem);
                    continue;
                }
                ArrayList<PurchaseVoucherItemSimpleExtDTO> voucherItemExtDTOList = new ArrayList<PurchaseVoucherItemSimpleExtDTO>();
                voucherItemExtDTOList.add(voucherItem);
                groupVoucherMap.put(deliveryItemDTO.getSourceItemId(), voucherItemExtDTOList);
            }
        }
        return groupVoucherMap;
    }

    private List<PurchaseDeliveryItemDTO> getPurchaseDeliveryItemList(List<PurchaseVoucherItemSimpleExtDTO> voucherItemList) {
        List deliveryNumberList;
        List deliveryItemList;
        List<Object> filterList = new ArrayList<PurchaseDeliveryItemDTO>();
        if (CollectionUtil.isNotEmpty(voucherItemList) && CollectionUtil.isNotEmpty((Collection)(deliveryItemList = this.purchaseDeliveryItemRpcService.selectDeliveryItemByNumber(deliveryNumberList = voucherItemList.stream().map(PurchaseVoucherItemSimpleExtDTO::getDeliveryNumber).collect(Collectors.toList()))))) {
            filterList = deliveryItemList.stream().filter(a -> "deliveryPlan".equals(a.getSourceType())).collect(Collectors.toList());
        }
        return filterList;
    }
}

